/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.gl.attrib;

import com.jozufozu.flywheel.backend.gl.GlNumericType;
import com.jozufozu.flywheel.backend.gl.attrib.IAttribSpec;
import org.lwjgl.opengl.GL20;

public class VertexAttribSpec
implements IAttribSpec {
    private final GlNumericType type;
    private final int count;
    private final int size;
    private final int attributeCount;
    private final boolean normalized;

    public VertexAttribSpec(GlNumericType type, int count) {
        this(type, count, false);
    }

    public VertexAttribSpec(GlNumericType type, int count, boolean normalized) {
        this.type = type;
        this.count = count;
        this.size = type.getByteWidth() * count;
        this.attributeCount = (this.size + 15) / 16;
        this.normalized = normalized;
    }

    @Override
    public void vertexAttribPointer(int stride, int index, int pointer) {
        GL20.glVertexAttribPointer((int)index, (int)this.count, (int)this.type.getGlEnum(), (boolean)this.normalized, (int)stride, (long)pointer);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getAttributeCount() {
        return this.attributeCount;
    }
}

