/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.instancing;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.instancing.IDynamicInstance;
import com.jozufozu.flywheel.backend.instancing.IInstance;
import com.jozufozu.flywheel.backend.instancing.ITickableInstance;
import com.jozufozu.flywheel.backend.material.MaterialManager;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;

public abstract class InstanceManager<T>
implements MaterialManager.OriginShiftListener {
    public final MaterialManager<?> materialManager;
    private final Set<T> queuedAdditions;
    private final Set<T> queuedUpdates;
    protected final Map<T, IInstance> instances;
    protected final Object2ObjectOpenHashMap<T, ITickableInstance> tickableInstances;
    protected final Object2ObjectOpenHashMap<T, IDynamicInstance> dynamicInstances;
    protected int frame;
    protected int tick;
    private static final int[] divisorSequence = new int[]{1, 2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31};

    public InstanceManager(MaterialManager<?> materialManager) {
        this.materialManager = materialManager;
        this.queuedUpdates = new HashSet<T>(64);
        this.queuedAdditions = new HashSet<T>(64);
        this.instances = new HashMap<T, IInstance>();
        this.dynamicInstances = new Object2ObjectOpenHashMap();
        this.tickableInstances = new Object2ObjectOpenHashMap();
        materialManager.addListener(this);
    }

    protected abstract boolean canInstance(T var1);

    protected abstract boolean canCreateInstance(T var1);

    @Nullable
    protected abstract IInstance createRaw(T var1);

    public void tick(double cameraX, double cameraY, double cameraZ) {
        ++this.tick;
        this.processQueuedUpdates();
        int cX = (int)cameraX;
        int cY = (int)cameraY;
        int cZ = (int)cameraZ;
        if (this.tickableInstances.size() > 0) {
            this.tickableInstances.object2ObjectEntrySet().parallelStream().forEach(e -> {
                int dZ;
                int dY;
                ITickableInstance instance = (ITickableInstance)e.getValue();
                if (!instance.decreaseTickRateWithDistance()) {
                    instance.tick();
                    return;
                }
                BlockPos pos = instance.getWorldPosition();
                int dX = pos.func_177958_n() - cX;
                if (this.tick % this.getUpdateDivisor(dX, dY = pos.func_177956_o() - cY, dZ = pos.func_177952_p() - cZ) == 0) {
                    instance.tick();
                }
            });
        }
    }

    public void beginFrame(ActiveRenderInfo info) {
        ++this.frame;
        this.processQueuedAdditions();
        Vector3f look = info.func_227996_l_();
        float lookX = look.func_195899_a();
        float lookY = look.func_195900_b();
        float lookZ = look.func_195902_c();
        int cX = (int)info.func_216785_c().field_72450_a;
        int cY = (int)info.func_216785_c().field_72448_b;
        int cZ = (int)info.func_216785_c().field_72449_c;
        if (this.dynamicInstances.size() > 0) {
            this.dynamicInstances.object2ObjectEntrySet().parallelStream().forEach(e -> {
                IDynamicInstance dyn = (IDynamicInstance)e.getValue();
                if (!dyn.decreaseFramerateWithDistance() || this.shouldFrameUpdate(dyn.getWorldPosition(), lookX, lookY, lookZ, cX, cY, cZ)) {
                    dyn.beginFrame();
                }
            });
        }
    }

    public void add(T obj) {
        if (!Backend.getInstance().canUseInstancing()) {
            return;
        }
        if (this.canInstance(obj)) {
            this.addInternal(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueAdd(T obj) {
        if (!Backend.getInstance().canUseInstancing()) {
            return;
        }
        Set<T> set = this.queuedAdditions;
        synchronized (set) {
            this.queuedAdditions.add(obj);
        }
    }

    public void update(T obj) {
        IInstance instance;
        if (!Backend.getInstance().canUseInstancing()) {
            return;
        }
        if (this.canInstance(obj) && (instance = this.getInstance(obj, false)) != null) {
            if (instance.shouldReset()) {
                this.removeInternal(obj, instance);
                this.createInternal(obj);
            } else {
                instance.update();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueUpdate(T obj) {
        if (!Backend.getInstance().canUseInstancing()) {
            return;
        }
        Set<T> set = this.queuedUpdates;
        synchronized (set) {
            this.queuedUpdates.add(obj);
        }
    }

    public void onLightUpdate(T obj) {
        IInstance instance;
        if (!Backend.getInstance().canUseInstancing()) {
            return;
        }
        if (this.canInstance(obj) && (instance = this.getInstance(obj, false)) != null) {
            instance.updateLight();
        }
    }

    public void remove(T obj) {
        IInstance instance;
        if (!Backend.getInstance().canUseInstancing()) {
            return;
        }
        if (this.canInstance(obj) && (instance = this.getInstance(obj, false)) != null) {
            this.removeInternal(obj, instance);
        }
    }

    public void invalidate() {
        this.instances.values().forEach(IInstance::remove);
        this.instances.clear();
        this.dynamicInstances.clear();
        this.tickableInstances.clear();
    }

    @Nullable
    protected <I extends T> IInstance getInstance(I obj, boolean create) {
        if (!Backend.getInstance().canUseInstancing()) {
            return null;
        }
        IInstance instance = this.instances.get(obj);
        if (instance != null) {
            return instance;
        }
        if (create && this.canCreateInstance(obj)) {
            return this.createInternal(obj);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processQueuedAdditions() {
        ArrayList<T> queued;
        Set<T> set = this.queuedAdditions;
        synchronized (set) {
            queued = new ArrayList<T>(this.queuedAdditions);
            this.queuedAdditions.clear();
        }
        if (queued.size() > 0) {
            queued.forEach(this::addInternal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processQueuedUpdates() {
        ArrayList<T> queued;
        Set<T> set = this.queuedUpdates;
        synchronized (set) {
            queued = new ArrayList<T>(this.queuedUpdates);
            this.queuedUpdates.clear();
        }
        if (queued.size() > 0) {
            queued.forEach(this::update);
        }
    }

    protected boolean shouldFrameUpdate(BlockPos worldPos, float lookX, float lookY, float lookZ, int cX, int cY, int cZ) {
        int dZ;
        int dY;
        int dist;
        int dX = worldPos.func_177958_n() - cX;
        float dot = ((float)dX + lookX * (float)(dist = 2)) * lookX + ((float)(dY = worldPos.func_177956_o() - cY) + lookY * (float)dist) * lookY + ((float)(dZ = worldPos.func_177952_p() - cZ) + lookZ * (float)dist) * lookZ;
        if (dot < 0.0f) {
            return false;
        }
        return this.frame % this.getUpdateDivisor(dX, dY, dZ) == 0;
    }

    protected int getUpdateDivisor(int dX, int dY, int dZ) {
        int dSq = dX * dX + dY * dY + dZ * dZ;
        int i = dSq / 2048;
        return divisorSequence[MathHelper.func_76125_a((int)i, (int)0, (int)(divisorSequence.length - 1))];
    }

    protected void addInternal(T tile) {
        this.getInstance(tile, true);
    }

    protected void removeInternal(T obj, IInstance instance) {
        instance.remove();
        this.instances.remove(obj);
        this.dynamicInstances.remove(obj);
        this.tickableInstances.remove(obj);
    }

    protected IInstance createInternal(T obj) {
        IInstance renderer = this.createRaw(obj);
        if (renderer != null) {
            renderer.updateLight();
            this.instances.put(obj, renderer);
            if (renderer instanceof IDynamicInstance) {
                this.dynamicInstances.put(obj, (Object)((IDynamicInstance)renderer));
            }
            if (renderer instanceof ITickableInstance) {
                this.tickableInstances.put(obj, (Object)((ITickableInstance)renderer));
            }
        }
        return renderer;
    }

    @Override
    public void onOriginShift() {
        ArrayList<T> instancedTiles = new ArrayList<T>(this.instances.keySet());
        this.invalidate();
        instancedTiles.forEach(this::add);
    }
}

