/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.instancing;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.gl.GlVertexArray;
import com.jozufozu.flywheel.backend.gl.attrib.VertexFormat;
import com.jozufozu.flywheel.backend.gl.buffer.GlBuffer;
import com.jozufozu.flywheel.backend.gl.buffer.GlBufferType;
import com.jozufozu.flywheel.backend.gl.buffer.MappedBuffer;
import com.jozufozu.flywheel.backend.instancing.IInstanceFactory;
import com.jozufozu.flywheel.backend.instancing.InstanceData;
import com.jozufozu.flywheel.backend.material.MaterialSpec;
import com.jozufozu.flywheel.backend.model.IBufferedModel;
import com.jozufozu.flywheel.backend.model.IndexedModel;
import com.jozufozu.flywheel.core.model.IModel;
import com.jozufozu.flywheel.util.AttribUtil;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.function.Supplier;

public class Instancer<D extends InstanceData> {
    protected final Supplier<IModel> gen;
    protected IBufferedModel model;
    protected final VertexFormat instanceFormat;
    protected final IInstanceFactory<D> factory;
    protected GlVertexArray vao;
    protected GlBuffer instanceVBO;
    protected int glBufferSize = -1;
    protected int glInstanceCount = 0;
    private boolean deleted;
    private boolean initialized;
    protected final ArrayList<D> data = new ArrayList();
    boolean anyToRemove;
    boolean anyToUpdate;

    public Instancer(Supplier<IModel> model, MaterialSpec<D> spec) {
        this.gen = model;
        this.factory = spec.getInstanceFactory();
        this.instanceFormat = spec.getInstanceFormat();
    }

    public D createInstance() {
        return this._add(this.factory.create(this));
    }

    public void stealInstance(D inOther) {
        if (((InstanceData)inOther).owner == this) {
            return;
        }
        ((InstanceData)inOther).owner.anyToRemove = true;
        this._add(inOther);
    }

    public void render() {
        if (!this.isInitialized()) {
            this.init();
        }
        if (this.deleted) {
            return;
        }
        this.vao.bind();
        this.renderSetup();
        if (this.glInstanceCount > 0) {
            this.model.drawInstances(this.glInstanceCount);
        }
        this.vao.unbind();
    }

    private void init() {
        this.model = new IndexedModel(this.gen.get());
        this.initialized = true;
        if (this.model.getVertexCount() <= 0) {
            throw new IllegalArgumentException("Refusing to instance a model with no vertices.");
        }
        this.vao = new GlVertexArray();
        this.instanceVBO = new GlBuffer(GlBufferType.ARRAY_BUFFER);
        this.vao.bind();
        this.model.setupState();
        AttribUtil.enableArrays(this.model.getAttributeCount() + this.instanceFormat.getAttributeCount());
        this.vao.unbind();
        this.model.clearState();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isEmpty() {
        return !this.anyToUpdate && !this.anyToRemove && this.glInstanceCount == 0;
    }

    public void clear() {
        this.data.clear();
        this.anyToRemove = true;
    }

    public void delete() {
        if (this.deleted) {
            return;
        }
        this.deleted = true;
        if (this.isInitialized()) {
            this.model.delete();
            this.instanceVBO.delete();
            this.vao.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private D _add(D instanceData) {
        ((InstanceData)instanceData).owner = this;
        ((InstanceData)instanceData).dirty = true;
        this.anyToUpdate = true;
        ArrayList<D> arrayList = this.data;
        synchronized (arrayList) {
            this.data.add(instanceData);
        }
        return instanceData;
    }

    protected void renderSetup() {
        if (this.anyToRemove) {
            this.removeDeletedInstances();
        }
        this.instanceVBO.bind();
        if (!this.realloc()) {
            if (this.anyToRemove) {
                this.clearBufferTail();
            }
            if (this.anyToUpdate) {
                this.updateBuffer();
            }
            this.glInstanceCount = this.data.size();
        }
        this.instanceVBO.unbind();
        this.anyToUpdate = false;
        this.anyToRemove = false;
    }

    private void clearBufferTail() {
        int size = this.data.size();
        int offset = size * this.instanceFormat.getStride();
        int length = this.glBufferSize - offset;
        if (length > 0) {
            this.instanceVBO.getBuffer(offset, length).putByteArray(new byte[length]).flush();
        }
    }

    private void updateBuffer() {
        int size = this.data.size();
        if (size <= 0) {
            return;
        }
        int stride = this.instanceFormat.getStride();
        BitSet dirtySet = this.getDirtyBitSet();
        if (dirtySet.isEmpty()) {
            return;
        }
        int firstDirty = dirtySet.nextSetBit(0);
        int lastDirty = dirtySet.previousSetBit(size);
        int offset = firstDirty * stride;
        int length = (1 + lastDirty - firstDirty) * stride;
        if (length > 0) {
            MappedBuffer mapped = this.instanceVBO.getBuffer(offset, length);
            dirtySet.stream().forEach(i -> {
                InstanceData d = (InstanceData)this.data.get(i);
                mapped.position(i * stride);
                d.write(mapped);
            });
            mapped.flush();
        }
    }

    private BitSet getDirtyBitSet() {
        int size = this.data.size();
        BitSet dirtySet = new BitSet(size);
        for (int i = 0; i < size; ++i) {
            InstanceData element = (InstanceData)this.data.get(i);
            if (!element.dirty) continue;
            dirtySet.set(i);
            element.dirty = false;
        }
        return dirtySet;
    }

    private boolean realloc() {
        int stride;
        int size = this.data.size();
        int requiredSize = size * (stride = this.instanceFormat.getStride());
        if (requiredSize > this.glBufferSize) {
            this.glBufferSize = requiredSize + stride * 16;
            this.instanceVBO.alloc(this.glBufferSize);
            MappedBuffer buffer = this.instanceVBO.getBuffer(0, this.glBufferSize);
            for (InstanceData datum : this.data) {
                datum.write(buffer);
            }
            buffer.flush();
            this.glInstanceCount = size;
            this.informAttribDivisors();
            return true;
        }
        return false;
    }

    private void removeDeletedInstances() {
        int oldSize = this.data.size();
        int removeCount = 0;
        BitSet removeSet = new BitSet(oldSize);
        for (int i = 0; i < oldSize; ++i) {
            InstanceData element = (InstanceData)this.data.get(i);
            if (!element.removed && element.owner == this) continue;
            removeSet.set(i);
            ++removeCount;
        }
        int newSize = oldSize - removeCount;
        int i = 0;
        for (int j = 0; i < oldSize && j < newSize; ++i, ++j) {
            if ((i = removeSet.nextClearBit(i)) == j) continue;
            InstanceData element = (InstanceData)this.data.get(i);
            this.data.set(j, element);
            element.dirty = true;
        }
        this.anyToUpdate = true;
        this.data.subList(newSize, oldSize).clear();
    }

    private void informAttribDivisors() {
        int staticAttributes = this.model.getAttributeCount();
        this.instanceFormat.vertexAttribPointers(staticAttributes);
        for (int i = 0; i < this.instanceFormat.getAttributeCount(); ++i) {
            Backend.getInstance().compat.instancedArrays.vertexAttribDivisor(i + staticAttributes, 1);
        }
    }
}

