/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.shader.spec;

import com.jozufozu.flywheel.core.shader.extension.IProgramExtension;
import com.jozufozu.flywheel.core.shader.spec.BooleanContextCondition;
import com.jozufozu.flywheel.core.shader.spec.IContextCondition;
import com.jozufozu.flywheel.core.shader.spec.SpecificValueCondition;
import com.jozufozu.flywheel.util.CodecUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ProgramState {
    private static final Codec<IContextCondition> WHEN = Codec.either(BooleanContextCondition.BOOLEAN_SUGAR, SpecificValueCondition.CODEC).flatXmap(either -> (DataResult)either.map(DataResult::success, DataResult::success), any -> {
        if (any instanceof BooleanContextCondition) {
            return DataResult.success((Object)Either.left((Object)((BooleanContextCondition)any)));
        }
        if (any instanceof SpecificValueCondition) {
            return DataResult.success((Object)Either.right((Object)((SpecificValueCondition)any)));
        }
        return DataResult.error((String)"unknown context condition");
    });
    public static final Codec<ProgramState> CODEC = RecordCodecBuilder.create(state -> state.group((App)WHEN.fieldOf("when").forGetter(ProgramState::getContext), (App)CodecUtil.oneOrMore(Codec.STRING).optionalFieldOf("define", Collections.emptyList()).forGetter(ProgramState::getDefines), (App)CodecUtil.oneOrMore(IProgramExtension.CODEC).optionalFieldOf("extend", Collections.emptyList()).forGetter(ProgramState::getExtensions)).apply((Applicative)state, ProgramState::new));
    private final IContextCondition context;
    private final List<String> defines;
    private final List<IProgramExtension> extensions;

    public ProgramState(IContextCondition context, List<String> defines, List<IProgramExtension> extensions) {
        this.context = context;
        this.defines = defines;
        this.extensions = extensions;
    }

    public IContextCondition getContext() {
        return this.context;
    }

    public List<String> getDefines() {
        return this.defines;
    }

    public List<IProgramExtension> getExtensions() {
        return this.extensions;
    }

    public String toString() {
        return "ProgramState{gameState=" + this.context.getID() + ", defines=" + this.defines + ", extensions=" + this.extensions.stream().map(IProgramExtension::getID).collect(Collectors.toList()) + '}';
    }
}

