/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.util;

import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3f;

public class BakedQuadWrapper {
    private final FormatCache formatCache = new FormatCache();
    private BakedQuad quad;
    private int[] vertexData;

    public BakedQuadWrapper() {
    }

    public BakedQuadWrapper(BakedQuad quad) {
        this.quad = quad;
        this.vertexData = quad.func_178209_a();
    }

    public void setQuad(BakedQuad quad) {
        this.quad = quad;
        this.vertexData = this.quad.func_178209_a();
    }

    public static BakedQuadWrapper of(BakedQuad quad) {
        return new BakedQuadWrapper(quad);
    }

    public void refreshFormat() {
        this.formatCache.refresh();
    }

    public BakedQuad getQuad() {
        return this.quad;
    }

    public void clear() {
        this.quad = null;
        this.vertexData = null;
    }

    public float getPosX(int vertexIndex) {
        return Float.intBitsToFloat(this.vertexData[vertexIndex * this.formatCache.vertexSize + this.formatCache.position]);
    }

    public float getPosY(int vertexIndex) {
        return Float.intBitsToFloat(this.vertexData[vertexIndex * this.formatCache.vertexSize + this.formatCache.position + 1]);
    }

    public float getPosZ(int vertexIndex) {
        return Float.intBitsToFloat(this.vertexData[vertexIndex * this.formatCache.vertexSize + this.formatCache.position + 2]);
    }

    public Vector3f getPos(int vertexIndex) {
        return new Vector3f(this.getPosX(vertexIndex), this.getPosY(vertexIndex), this.getPosZ(vertexIndex));
    }

    public void copyPos(int vertexIndex, Vector3f pos) {
        pos.func_195905_a(this.getPosX(vertexIndex), this.getPosY(vertexIndex), this.getPosZ(vertexIndex));
    }

    public int getColor(int vertexIndex) {
        return this.vertexData[vertexIndex * this.formatCache.vertexSize + this.formatCache.color];
    }

    public float getTexU(int vertexIndex) {
        return Float.intBitsToFloat(this.vertexData[vertexIndex * this.formatCache.vertexSize + this.formatCache.texture]);
    }

    public float getTexV(int vertexIndex) {
        return Float.intBitsToFloat(this.vertexData[vertexIndex * this.formatCache.vertexSize + this.formatCache.texture + 1]);
    }

    public Vector2f getTex(int vertexIndex) {
        return new Vector2f(this.getTexU(vertexIndex), this.getTexV(vertexIndex));
    }

    public int getLight(int vertexIndex) {
        return this.vertexData[vertexIndex * this.formatCache.vertexSize + this.formatCache.light];
    }

    public float getNormalX(int vertexIndex) {
        return Float.intBitsToFloat(this.vertexData[vertexIndex * this.formatCache.vertexSize + this.formatCache.normal]);
    }

    public float getNormalY(int vertexIndex) {
        return Float.intBitsToFloat(this.vertexData[vertexIndex * this.formatCache.vertexSize + this.formatCache.normal + 1]);
    }

    public float getNormalZ(int vertexIndex) {
        return Float.intBitsToFloat(this.vertexData[vertexIndex * this.formatCache.vertexSize + this.formatCache.normal + 2]);
    }

    public Vector3f getNormal(int vertexIndex) {
        return new Vector3f(this.getNormalX(vertexIndex), this.getNormalY(vertexIndex), this.getNormalZ(vertexIndex));
    }

    public void copyNormal(int vertexIndex, Vector3f normal) {
        normal.func_195905_a(this.getNormalX(vertexIndex), this.getNormalY(vertexIndex), this.getNormalZ(vertexIndex));
    }

    public void setPosX(int vertexIndex, float x) {
        this.vertexData[vertexIndex * this.formatCache.vertexSize + this.formatCache.position] = Float.floatToRawIntBits(x);
    }

    public void setPosY(int vertexIndex, float y) {
        this.vertexData[vertexIndex * this.formatCache.vertexSize + this.formatCache.position + 1] = Float.floatToRawIntBits(y);
    }

    public void setPosZ(int vertexIndex, float z) {
        this.vertexData[vertexIndex * this.formatCache.vertexSize + this.formatCache.position + 2] = Float.floatToRawIntBits(z);
    }

    public void setPos(int vertexIndex, float x, float y, float z) {
        this.setPosX(vertexIndex, x);
        this.setPosY(vertexIndex, y);
        this.setPosZ(vertexIndex, z);
    }

    public void setPos(int vertexIndex, Vector3f pos) {
        this.setPos(vertexIndex, pos.func_195899_a(), pos.func_195900_b(), pos.func_195902_c());
    }

    public void setColor(int vertexIndex, int color) {
        this.vertexData[vertexIndex * this.formatCache.vertexSize + this.formatCache.color] = color;
    }

    public void setTexU(int vertexIndex, float u) {
        this.vertexData[vertexIndex * this.formatCache.vertexSize + this.formatCache.texture] = Float.floatToRawIntBits(u);
    }

    public void setTexV(int vertexIndex, float v) {
        this.vertexData[vertexIndex * this.formatCache.vertexSize + this.formatCache.texture + 1] = Float.floatToRawIntBits(v);
    }

    public void setTex(int vertexIndex, float u, float v) {
        this.setTexU(vertexIndex, u);
        this.setTexV(vertexIndex, v);
    }

    public void setTex(int vertexIndex, Vector2f tex) {
        this.setTex(vertexIndex, tex.field_189982_i, tex.field_189983_j);
    }

    public void setLight(int vertexIndex, int light) {
        this.vertexData[vertexIndex * this.formatCache.vertexSize + this.formatCache.light] = light;
    }

    public void setNormalX(int vertexIndex, float normalX) {
        this.vertexData[vertexIndex * this.formatCache.vertexSize + this.formatCache.normal] = Float.floatToRawIntBits(normalX);
    }

    public void setNormalY(int vertexIndex, float normalY) {
        this.vertexData[vertexIndex * this.formatCache.vertexSize + this.formatCache.normal + 1] = Float.floatToRawIntBits(normalY);
    }

    public void setNormalZ(int vertexIndex, float normalZ) {
        this.vertexData[vertexIndex * this.formatCache.vertexSize + this.formatCache.normal + 2] = Float.floatToRawIntBits(normalZ);
    }

    public void setNormal(int vertexIndex, float normalX, float normalY, float normalZ) {
        this.setNormalX(vertexIndex, normalX);
        this.setNormalY(vertexIndex, normalY);
        this.setNormalZ(vertexIndex, normalZ);
    }

    public void setNormal(int vertexIndex, Vector3f normal) {
        this.setNormal(vertexIndex, normal.func_195899_a(), normal.func_195900_b(), normal.func_195902_c());
    }

    private static class FormatCache {
        private static final VertexFormat FORMAT = DefaultVertexFormats.field_176600_a;
        public int vertexSize;
        public int position;
        public int color;
        public int texture;
        public int light;
        public int normal;

        public FormatCache() {
            this.refresh();
        }

        public void refresh() {
            this.vertexSize = FORMAT.func_181719_f();
            for (int elementId = 0; elementId < FORMAT.func_227894_c_().size(); ++elementId) {
                VertexFormatElement element = (VertexFormatElement)FORMAT.func_227894_c_().get(elementId);
                int intOffset = FORMAT.getOffset(elementId) / 4;
                if (element.func_177375_c() == VertexFormatElement.Usage.POSITION) {
                    this.position = intOffset;
                    continue;
                }
                if (element.func_177375_c() == VertexFormatElement.Usage.COLOR) {
                    this.color = intOffset;
                    continue;
                }
                if (element.func_177375_c() == VertexFormatElement.Usage.UV) {
                    if (element.func_177369_e() == 0) {
                        this.texture = intOffset;
                        continue;
                    }
                    if (element.func_177369_e() != 2) continue;
                    this.light = intOffset;
                    continue;
                }
                if (element.func_177375_c() != VertexFormatElement.Usage.NORMAL) continue;
                this.normal = intOffset;
            }
        }
    }
}

