/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.vanilla;

import com.jozufozu.flywheel.backend.instancing.IDynamicInstance;
import com.jozufozu.flywheel.backend.instancing.tile.TileEntityInstance;
import com.jozufozu.flywheel.backend.material.MaterialManager;
import com.jozufozu.flywheel.backend.state.TextureRenderState;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.materials.ModelData;
import com.jozufozu.flywheel.core.materials.OrientedData;
import com.jozufozu.flywheel.core.model.ModelPart;
import com.jozufozu.flywheel.util.AnimationTickHolder;
import com.jozufozu.flywheel.util.transform.MatrixTransformStack;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.util.Calendar;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractChestBlock;
import net.minecraft.block.Block;
import net.minecraft.block.ChestBlock;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.state.Property;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.IChestLid;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMerger;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;

public class ChestInstance<T extends TileEntity>
extends TileEntityInstance<T>
implements IDynamicInstance {
    private final OrientedData body;
    private final ModelData lid;
    private final Float2FloatFunction lidProgress;
    private final RenderMaterial renderMaterial;
    @Nonnull
    private final ChestType chestType;
    private final Quaternion baseRotation;
    private float lastProgress = Float.NaN;

    public ChestInstance(MaterialManager<?> materialManager, T tile) {
        super(materialManager, tile);
        Block block = this.blockState.func_177230_c();
        this.chestType = this.blockState.func_235901_b_((Property)ChestBlock.field_196314_b) ? (ChestType)this.blockState.func_177229_b((Property)ChestBlock.field_196314_b) : ChestType.SINGLE;
        this.renderMaterial = Atlases.func_228771_a_(tile, (ChestType)this.chestType, (boolean)ChestInstance.isChristmas());
        this.body = this.baseInstance().setPosition(this.getInstancePosition());
        this.lid = this.lidInstance();
        if (block instanceof AbstractChestBlock) {
            float horizontalAngle = ((Direction)this.blockState.func_177229_b((Property)ChestBlock.field_176459_a)).func_185119_l();
            this.baseRotation = Vector3f.field_229181_d_.func_229187_a_(-horizontalAngle);
            this.body.setRotation(this.baseRotation);
            AbstractChestBlock chestBlock = (AbstractChestBlock)block;
            TileEntityMerger.ICallbackWrapper wrapper = chestBlock.func_225536_a_(this.blockState, this.world, this.getWorldPosition(), true);
            this.lidProgress = (Float2FloatFunction)wrapper.apply(ChestBlock.func_226917_a_((IChestLid)((IChestLid)tile)));
        } else {
            this.baseRotation = Quaternion.field_227060_a_;
            this.lidProgress = $ -> 0.0f;
        }
    }

    @Override
    public void beginFrame() {
        float progress = this.lidProgress.get(AnimationTickHolder.getPartialTicks());
        if (this.lastProgress == progress) {
            return;
        }
        this.lastProgress = progress;
        progress = 1.0f - progress;
        progress = 1.0f - progress * progress * progress;
        float angleX = -(progress * 1.5707964f);
        MatrixTransformStack stack = new MatrixTransformStack();
        stack.translate((Vector3i)this.getInstancePosition()).translate(0.0, 0.5625, 0.0).centre().multiply(this.baseRotation).unCentre().translate(0.0, 0.0, 0.0625).multiply(Vector3f.field_229179_b_.func_229193_c_(angleX)).translate(0.0, 0.0, -0.0625);
        this.lid.setTransform(stack.unwrap());
    }

    @Override
    public void updateLight() {
        this.relight(this.getWorldPosition(), this.body, this.lid);
    }

    @Override
    public void remove() {
        this.body.delete();
        this.lid.delete();
    }

    private OrientedData baseInstance() {
        return this.materialManager.solid(TextureRenderState.get(this.renderMaterial.func_229310_a_())).material(Materials.ORIENTED).model("base_" + this.renderMaterial.func_229313_b_(), this::getBaseModel).createInstance();
    }

    private ModelData lidInstance() {
        return this.materialManager.solid(TextureRenderState.get(this.renderMaterial.func_229310_a_())).material(Materials.TRANSFORMED).model("lid_" + this.renderMaterial.func_229313_b_(), this::getLidModel).createInstance();
    }

    private ModelPart getBaseModel() {
        switch (this.chestType) {
            case LEFT: {
                return ModelPart.builder(64, 64).sprite(this.renderMaterial.func_229314_c_()).cuboid().textureOffset(0, 19).start(0.0f, 0.0f, 1.0f).size(15.0f, 10.0f, 14.0f).endCuboid().build();
            }
            case RIGHT: {
                return ModelPart.builder(64, 64).sprite(this.renderMaterial.func_229314_c_()).cuboid().textureOffset(0, 19).start(1.0f, 0.0f, 1.0f).size(15.0f, 10.0f, 14.0f).endCuboid().build();
            }
        }
        return ModelPart.builder(64, 64).sprite(this.renderMaterial.func_229314_c_()).cuboid().textureOffset(0, 19).start(1.0f, 0.0f, 1.0f).end(15.0f, 10.0f, 15.0f).endCuboid().build();
    }

    private ModelPart getLidModel() {
        switch (this.chestType) {
            case LEFT: {
                return ModelPart.builder(64, 64).sprite(this.renderMaterial.func_229314_c_()).cuboid().textureOffset(0, 0).start(0.0f, 0.0f, 1.0f).size(15.0f, 5.0f, 14.0f).endCuboid().cuboid().start(0.0f, -2.0f, 15.0f).size(1.0f, 4.0f, 1.0f).endCuboid().build();
            }
            case RIGHT: {
                return ModelPart.builder(64, 64).sprite(this.renderMaterial.func_229314_c_()).cuboid().textureOffset(0, 0).start(1.0f, 0.0f, 1.0f).size(15.0f, 5.0f, 14.0f).endCuboid().cuboid().start(15.0f, -2.0f, 15.0f).size(1.0f, 4.0f, 1.0f).endCuboid().build();
            }
        }
        return ModelPart.builder(64, 64).sprite(this.renderMaterial.func_229314_c_()).cuboid().textureOffset(0, 0).start(1.0f, 0.0f, 1.0f).size(14.0f, 5.0f, 14.0f).endCuboid().cuboid().start(7.0f, -2.0f, 15.0f).size(2.0f, 4.0f, 1.0f).endCuboid().build();
    }

    public static boolean isChristmas() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26;
    }
}

