/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.render.pipeline;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import mods.betterfoliage.chunk.BasicBlockCtx;
import mods.betterfoliage.chunk.BlockCtx;
import mods.betterfoliage.model.HalfBakedQuad;
import mods.betterfoliage.model.SpecialRenderModel;
import mods.betterfoliage.render.lighting.ForgeVertexLighter;
import mods.betterfoliage.render.lighting.ForgeVertexLighterAccess;
import mods.betterfoliage.render.pipeline.RenderCtxBase;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.VertexLighterFlat;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\b\u0018\u0000 (2\u00020\u00012\u00020\u0002:\u0001(B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J@\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020\u0013H\u0016J0\u0010&\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006)"}, d2={"Lmods/betterfoliage/render/pipeline/RenderCtxForge;", "Lmods/betterfoliage/render/pipeline/RenderCtxBase;", "Lmods/betterfoliage/render/lighting/ForgeVertexLighter;", "blockCtx", "Lmods/betterfoliage/chunk/BlockCtx;", "lighter", "Lnet/minecraftforge/client/model/pipeline/VertexLighterFlat;", "matrixStack", "Lcom/mojang/blaze3d/matrix/MatrixStack;", "checkSides", "", "random", "Ljava/util/Random;", "modelData", "Lnet/minecraftforge/client/model/data/IModelData;", "(Lmods/betterfoliage/chunk/BlockCtx;Lnet/minecraftforge/client/model/pipeline/VertexLighterFlat;Lcom/mojang/blaze3d/matrix/MatrixStack;ZLjava/util/Random;Lnet/minecraftforge/client/model/data/IModelData;)V", "getLighter", "()Lnet/minecraftforge/client/model/pipeline/VertexLighterFlat;", "vIdx", "", "getVIdx", "()I", "setVIdx", "(I)V", "renderQuad", "", "quad", "Lmods/betterfoliage/model/HalfBakedQuad;", "updateVertexColor", "normal", "", "color", "x", "", "y", "z", "tint", "multiplier", "updateVertexLightmap", "lightmap", "Companion", "forge-1.16"})
public final class RenderCtxForge
extends RenderCtxBase
implements ForgeVertexLighter {
    private int vIdx;
    @NotNull
    private final VertexLighterFlat lighter;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void renderQuad(@NotNull HalfBakedQuad quad) {
        this.getVertexLighter().updateLightmapAndColor(quad, this.getLightingData());
        quad.getBaked().pipe((IVertexConsumer)this.lighter);
    }

    public final int getVIdx() {
        return this.vIdx;
    }

    public final void setVIdx(int n) {
        this.vIdx = n;
    }

    @Override
    public void updateVertexLightmap(@NotNull float[] normal, @NotNull float[] lightmap, float x, float y, float z) {
        int n = this.getLightingData().getPackedLight()[this.vIdx];
        boolean bl = false;
        boolean bl2 = false;
        int packedLight = n;
        boolean bl3 = false;
        lightmap[0] = (float)LightTexture.func_228450_a_((int)packedLight) / (float)15;
        lightmap[1] = (float)LightTexture.func_228454_b_((int)packedLight) / (float)15;
    }

    @Override
    public void updateVertexColor(@NotNull float[] normal, @NotNull float[] color, float x, float y, float z, float tint, int multiplier) {
        color[0] = this.getLightingData().getTint()[0] * this.getLightingData().getColorMultiplier()[this.vIdx];
        color[1] = this.getLightingData().getTint()[1] * this.getLightingData().getColorMultiplier()[this.vIdx];
        color[2] = this.getLightingData().getTint()[2] * this.getLightingData().getColorMultiplier()[this.vIdx];
        int n = this.vIdx;
        this.vIdx = n + 1;
    }

    @NotNull
    public final VertexLighterFlat getLighter() {
        return this.lighter;
    }

    public RenderCtxForge(@NotNull BlockCtx blockCtx, @NotNull VertexLighterFlat lighter, @NotNull MatrixStack matrixStack, boolean checkSides, @NotNull Random random, @NotNull IModelData modelData) {
        super(blockCtx, matrixStack, checkSides, random, modelData);
        this.lighter = lighter;
    }

    @JvmStatic
    public static final boolean render(@NotNull VertexLighterFlat lighter, @NotNull IBlockDisplayReader world, @NotNull SpecialRenderModel model, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull MatrixStack matrixStack, boolean checkSides, @NotNull Random random, long seed, @NotNull IModelData modelData) {
        return Companion.render(lighter, world, model, state, pos, matrixStack, checkSides, random, seed, modelData);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JX\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007\u00a8\u0006\u0018"}, d2={"Lmods/betterfoliage/render/pipeline/RenderCtxForge$Companion;", "", "()V", "render", "", "lighter", "Lnet/minecraftforge/client/model/pipeline/VertexLighterFlat;", "world", "Lnet/minecraft/world/IBlockDisplayReader;", "model", "Lmods/betterfoliage/model/SpecialRenderModel;", "state", "Lnet/minecraft/block/BlockState;", "pos", "Lnet/minecraft/util/math/BlockPos;", "matrixStack", "Lcom/mojang/blaze3d/matrix/MatrixStack;", "checkSides", "random", "Ljava/util/Random;", "seed", "", "modelData", "Lnet/minecraftforge/client/model/data/IModelData;", "forge-1.16"})
    public static final class Companion {
        @JvmStatic
        public final boolean render(@NotNull VertexLighterFlat lighter, @NotNull IBlockDisplayReader world, @NotNull SpecialRenderModel model, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull MatrixStack matrixStack, boolean checkSides, @NotNull Random random, long seed, @NotNull IModelData modelData) {
            RenderCtxForge ctx;
            BasicBlockCtx blockCtx = new BasicBlockCtx(world, pos);
            RenderCtxForge renderCtxForge = new RenderCtxForge(blockCtx, lighter, matrixStack, checkSides, random, modelData);
            boolean bl = false;
            boolean bl2 = false;
            RenderCtxForge $this$apply = renderCtxForge;
            boolean bl3 = false;
            lighter.setWorld(world);
            lighter.setState(state);
            lighter.setBlockPos(pos);
            lighter.updateBlockInfo();
            renderCtxForge = ctx = renderCtxForge;
            bl = false;
            bl2 = false;
            RenderCtxForge it = renderCtxForge;
            boolean bl4 = false;
            VertexLighterFlat vertexLighterFlat = lighter;
            if (vertexLighterFlat == null) {
                throw new NullPointerException("null cannot be cast to non-null type mods.betterfoliage.render.lighting.ForgeVertexLighterAccess");
            }
            ((ForgeVertexLighterAccess)vertexLighterFlat).setVertexLighter(it);
            model.renderLayer(it, RenderCtxBase.Companion.getSpecialRenderData().get(), MinecraftForgeClient.getRenderLayer());
            lighter.resetBlockInfo();
            return it.getHasRendered();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

