/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.resource.discovery;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mods.betterfoliage.BetterFoliage;
import mods.betterfoliage.resource.discovery.BlockTypeCache;
import mods.betterfoliage.resource.discovery.ModelBakingContext;
import mods.betterfoliage.resource.discovery.ModelBakingKey;
import mods.betterfoliage.resource.discovery.ModelDefinitionsLoadedEvent;
import mods.betterfoliage.resource.discovery.ModelDiscovery;
import mods.betterfoliage.util.Atlas;
import mods.betterfoliage.util.HasLogger;
import mods.betterfoliage.util.Invalidator;
import mods.betterfoliage.util.ResourcesKt;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.loading.progress.StartupMessageManager;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u001aH\u0007J<\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0\"2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0010R&\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lmods/betterfoliage/resource/discovery/BakeWrapperManager;", "Lmods/betterfoliage/util/Invalidator;", "Lmods/betterfoliage/util/HasLogger;", "()V", "callbacks", "", "Ljava/lang/ref/WeakReference;", "Lkotlin/Function0;", "", "getCallbacks", "()Ljava/util/List;", "discoverers", "Lmods/betterfoliage/resource/discovery/ModelDiscovery;", "getDiscoverers", "replacements", "", "Lnet/minecraft/util/ResourceLocation;", "Lmods/betterfoliage/resource/discovery/ModelBakingKey;", "sprites", "", "handleModelBake", "event", "Lnet/minecraftforge/client/event/ModelBakeEvent;", "handleModelLoad", "Lmods/betterfoliage/resource/discovery/ModelDefinitionsLoadedEvent;", "handleStitch", "Lnet/minecraftforge/client/event/TextureStitchEvent$Pre;", "onBake", "Lnet/minecraft/client/renderer/model/IBakedModel;", "unbaked", "Lnet/minecraft/client/renderer/model/IUnbakedModel;", "bakery", "Lnet/minecraft/client/renderer/model/ModelBakery;", "spriteGetter", "Ljava/util/function/Function;", "Lnet/minecraft/client/renderer/model/RenderMaterial;", "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "transform", "Lnet/minecraft/client/renderer/model/IModelTransform;", "location", "forge-1.16"})
public final class BakeWrapperManager
extends HasLogger
implements Invalidator {
    @NotNull
    private final List<ModelDiscovery> discoverers;
    @NotNull
    private final List<WeakReference<Function0<Unit>>> callbacks;
    private final Map<ResourceLocation, ModelBakingKey> replacements;
    private final Set<ResourceLocation> sprites;

    @NotNull
    public final List<ModelDiscovery> getDiscoverers() {
        return this.discoverers;
    }

    @Override
    @NotNull
    public List<WeakReference<Function0<Unit>>> getCallbacks() {
        return this.callbacks;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public final void handleModelLoad(@NotNull ModelDefinitionsLoadedEvent event) {
        long startTime = System.currentTimeMillis();
        this.invalidate();
        BetterFoliage.INSTANCE.getBlockConfig().readConfig((IResourceManager)ResourcesKt.getResourceManager());
        BetterFoliage.INSTANCE.setBlockTypes(new BlockTypeCache());
        StartupMessageManager.addModMessage((String)"BetterFoliage: discovering models");
        this.getLogger().log(Level.INFO, "starting model discovery (" + this.discoverers.size() + " listeners)");
        Iterable $this$forEach$iv = this.discoverers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModelDiscovery listener = (ModelDiscovery)element$iv;
            boolean bl = false;
            boolean bl2 = false;
            Map replacementsLocal = new LinkedHashMap();
            listener.onModelsLoaded(event.getBakery(), this.sprites, this.replacements);
        }
        long elapsed = System.currentTimeMillis() - startTime;
        this.getLogger().log(Level.INFO, "finished model discovery in " + elapsed + " ms, " + this.replacements.size() + " top-level replacements");
    }

    @SubscribeEvent
    public final void handleStitch(@NotNull TextureStitchEvent.Pre event) {
        if (Intrinsics.areEqual((Object)event.getMap().func_229223_g_(), (Object)Atlas.BLOCKS.getResourceId())) {
            this.getLogger().log(Level.INFO, "Adding " + this.sprites.size() + " sprites to block atlas");
            Iterable $this$forEach$iv = this.sprites;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ResourceLocation it = (ResourceLocation)element$iv;
                boolean bl = false;
                event.addSprite(it);
            }
            this.sprites.clear();
        }
    }

    @SubscribeEvent
    public final void handleModelBake(@NotNull ModelBakeEvent event) {
        this.replacements.clear();
    }

    @Nullable
    public final IBakedModel onBake(@NotNull IUnbakedModel unbaked, @NotNull ModelBakery bakery, @NotNull Function<RenderMaterial, TextureAtlasSprite> spriteGetter, @NotNull IModelTransform transform, @NotNull ResourceLocation location) {
        ModelBakingContext ctx = new ModelBakingContext(bakery, spriteGetter, location, transform, (Logger)this.getDetailLogger());
        ModelBakingKey modelBakingKey = this.replacements.get(location);
        if (modelBakingKey != null) {
            ModelBakingKey modelBakingKey2 = modelBakingKey;
            boolean bl = false;
            boolean bl2 = false;
            ModelBakingKey replacement = modelBakingKey2;
            boolean bl3 = false;
            this.getDetailLogger().log(Level.INFO, "Baking replacement for [" + unbaked.getClass().getSimpleName() + "] " + location + " -> " + replacement);
            try {
                return replacement.bake(ctx);
            }
            catch (Exception e) {
                this.getDetailLogger().log(Level.WARN, "Error while baking " + replacement, (Throwable)e);
                this.getLogger().log(Level.WARN, "Error while baking " + replacement, (Throwable)e);
            }
        }
        return unbaked.func_225613_a_(bakery, spriteGetter, transform, location);
    }

    public BakeWrapperManager() {
        super(null, 1, null);
        boolean bl = false;
        this.discoverers = new ArrayList();
        bl = false;
        this.callbacks = new ArrayList();
        bl = false;
        this.replacements = new LinkedHashMap();
        bl = false;
        this.sprites = new LinkedHashSet();
    }

    @Override
    public void invalidate() {
        Invalidator.DefaultImpls.invalidate(this);
    }

    @Override
    public void onInvalidate(@NotNull Function0<Unit> callback) {
        Invalidator.DefaultImpls.onInvalidate(this, callback);
    }
}

