/*
 * Decompiled with CFR 0.152.
 */
package blueduck.dustrial.dustrialdecor;

import blueduck.dustrial.dustrialdecor.config.ConfigHelper;
import blueduck.dustrial.dustrialdecor.config.DustrialDecorConfig;
import blueduck.dustrial.dustrialdecor.registry.DustrialBlocks;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="dustrial_decor")
public class DustrialDecorMod {
    private static final Logger LOGGER = LogManager.getLogger();
    public static String MODID = "dustrial_decor";
    public static DustrialDecorConfig CONFIG;

    public DustrialDecorMod() {
        CONFIG = ConfigHelper.register(ModConfig.Type.COMMON, DustrialDecorConfig::new);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
        DustrialBlocks.init();
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM PREINIT");
        LOGGER.info("DIRT BLOCK >> {}", (Object)Blocks.field_150346_d.getRegistryName());
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        LOGGER.info("Got game settings {}", (Object)((Minecraft)event.getMinecraftSupplier().get()).field_71474_y);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"examplemod", (String)"helloworld", () -> {
            LOGGER.info("Hello world from the MDK");
            return "Hello world";
        });
    }

    private void processIMC(InterModProcessEvent event) {
        LOGGER.info("Got IMC {}", event.getIMCStream().map(m -> m.getMessageSupplier().get()).collect(Collectors.toList()));
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @SubscribeEvent
    public void entitySpawn(LivingSpawnEvent.SpecialSpawn event) {
        EntityType type;
        if (DustrialDecorMod.CONFIG.MOBS_SPAWN_WITH_CARDBOARD_ARMOR.get().booleanValue() && !event.getWorld().func_201670_d() && event.getEntity().func_130014_f_().func_201674_k().nextDouble() < 0.05 && ((type = event.getEntityLiving().func_200600_R()) == EntityType.field_200725_aD || type == EntityType.field_200741_ag || type == EntityType.field_200750_ap || type == EntityType.field_200763_C || type == EntityType.field_204724_o) && event.getEntityLiving() instanceof MobEntity && event.getEntityLiving().func_184582_a(EquipmentSlotType.HEAD).func_190926_b() && event.getEntityLiving().func_184582_a(EquipmentSlotType.CHEST).func_190926_b() && event.getEntityLiving().func_184582_a(EquipmentSlotType.LEGS).func_190926_b() && event.getEntityLiving().func_184582_a(EquipmentSlotType.FEET).func_190926_b()) {
            MobEntity entity = (MobEntity)event.getEntityLiving();
            entity.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)DustrialBlocks.CARDBOARD_HELMET.get()));
            entity.func_184642_a(EquipmentSlotType.HEAD, 0.085f);
            entity.func_184201_a(EquipmentSlotType.CHEST, new ItemStack((IItemProvider)DustrialBlocks.CARDBOARD_CHESTPLATE.get()));
            entity.func_184642_a(EquipmentSlotType.CHEST, 0.085f);
            entity.func_184201_a(EquipmentSlotType.LEGS, new ItemStack((IItemProvider)DustrialBlocks.CARDBOARD_LEGGINGS.get()));
            entity.func_184642_a(EquipmentSlotType.LEGS, 0.085f);
            entity.func_184201_a(EquipmentSlotType.FEET, new ItemStack((IItemProvider)DustrialBlocks.CARDBOARD_BOOTS.get()));
            entity.func_184642_a(EquipmentSlotType.FEET, 0.085f);
        }
    }

    public static boolean isLoaded(String modid) {
        return ModList.get().isLoaded(modid);
    }

    @Mod.EventBusSubscriber(modid="dustrial_decor")
    public static class LootEvents {
        @SubscribeEvent
        public static void onLootLoad(LootTableLoadEvent event) {
            if (DustrialDecorMod.CONFIG.LOOT_TABLE_MODIFICATION.get().booleanValue()) {
                if (event.getName().equals((Object)new ResourceLocation("minecraft", "chests/simple_dungeon"))) {
                    event.getTable().addPool(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation(MODID, "chests/dungeon"))).name("dustrial_inject").func_216044_b());
                }
                if (event.getName().equals((Object)new ResourceLocation("minecraft", "chests/pillager_outpost"))) {
                    event.getTable().addPool(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation(MODID, "chests/dungeon"))).name("dustrial_inject").func_216044_b());
                }
                if (event.getName().equals((Object)new ResourceLocation("minecraft", "chests/woodland_mansion"))) {
                    event.getTable().addPool(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation(MODID, "chests/dungeon"))).name("dustrial_inject").func_216044_b());
                }
                if (event.getName().equals((Object)new ResourceLocation("minecraft", "chests/shipwreck_supply"))) {
                    event.getTable().addPool(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation(MODID, "chests/dungeon"))).name("dustrial_inject").func_216044_b());
                }
                if (event.getName().equals((Object)new ResourceLocation("minecraft", "chests/stronghold_corridor"))) {
                    event.getTable().addPool(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation(MODID, "chests/dungeon"))).name("dustrial_inject").func_216044_b());
                }
                if (event.getName().equals((Object)new ResourceLocation("minecraft", "chests/village/village_toolsmith"))) {
                    event.getTable().addPool(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation(MODID, "chests/dungeon"))).name("dustrial_inject").func_216044_b());
                }
                if (event.getName().equals((Object)new ResourceLocation("minecraft", "chests/village/village_weaponsmith"))) {
                    event.getTable().addPool(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation(MODID, "chests/dungeon"))).name("dustrial_inject").func_216044_b());
                }
                if (event.getName().equals((Object)new ResourceLocation("minecraft", "entities/zombie"))) {
                    event.getTable().addPool(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation(MODID, "entities/zombie"))).name("dustrial_inject").func_216044_b());
                }
            }
        }

        @SubscribeEvent
        public static void villagerTrades(VillagerTradesEvent event) {
            if (event.getType() == VillagerProfession.field_221161_k) {
                ((List)event.getTrades().get(3)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, 1), new ItemStack((IItemProvider)DustrialBlocks.CINDER_BRICKS_ITEM.get(), 16), 12, 10, 0.05f));
                ((List)event.getTrades().get(3)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, 1), new ItemStack((IItemProvider)DustrialBlocks.CINDER_BLOCK_ITEM.get(), 16), 12, 10, 0.05f));
                ((List)event.getTrades().get(3)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, 1), new ItemStack((IItemProvider)DustrialBlocks.POLISHED_CINDER_BLOCK_ITEM.get(), 16), 12, 10, 0.05f));
            }
        }
    }

    @Mod.EventBusSubscriber(modid="dustrial_decor", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientEventBusSubscriber {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            RenderTypeLookup.setRenderLayer((Block)((Block)DustrialBlocks.CHAIN_LINK_FENCE.get()), (RenderType)RenderType.func_228641_d_());
            RenderTypeLookup.setRenderLayer((Block)((Block)DustrialBlocks.BARBED_CHAIN_LINK_FENCE.get()), (RenderType)RenderType.func_228641_d_());
            RenderTypeLookup.setRenderLayer((Block)((Block)DustrialBlocks.BARBED_IRON_BARS.get()), (RenderType)RenderType.func_228641_d_());
            RenderTypeLookup.setRenderLayer((Block)((Block)DustrialBlocks.PADDED_TRAPDOOR.get()), (RenderType)RenderType.func_228641_d_());
            RenderTypeLookup.setRenderLayer((Block)((Block)DustrialBlocks.CAST_IRON_BALUSTRADE.get()), (RenderType)RenderType.func_228641_d_());
            RenderTypeLookup.setRenderLayer((Block)((Block)DustrialBlocks.INDUSTRIAL_IRON_DOOR.get()), (RenderType)RenderType.func_228641_d_());
            RenderTypeLookup.setRenderLayer((Block)((Block)DustrialBlocks.CHAIN_TRAPDOOR.get()), (RenderType)RenderType.func_228641_d_());
            RenderTypeLookup.setRenderLayer((Block)((Block)DustrialBlocks.PADDED_DOOR.get()), (RenderType)RenderType.func_228641_d_());
            RenderTypeLookup.setRenderLayer((Block)((Block)DustrialBlocks.CHAIN_DOOR.get()), (RenderType)RenderType.func_228641_d_());
            RenderTypeLookup.setRenderLayer((Block)((Block)DustrialBlocks.CARDBOARD_DOOR.get()), (RenderType)RenderType.func_228641_d_());
            RenderTypeLookup.setRenderLayer((Block)((Block)DustrialBlocks.RUSTY_IRON_TRAPDOOR.get()), (RenderType)RenderType.func_228641_d_());
            RenderTypeLookup.setRenderLayer((Block)((Block)DustrialBlocks.IRON_BAR_TRAPDOOR.get()), (RenderType)RenderType.func_228641_d_());
            RenderTypeLookup.setRenderLayer((Block)((Block)DustrialBlocks.RUSTY_IRON_DOOR.get()), (RenderType)RenderType.func_228641_d_());
            RenderTypeLookup.setRenderLayer((Block)((Block)DustrialBlocks.IRON_BAR_DOOR.get()), (RenderType)RenderType.func_228641_d_());
            RenderTypeLookup.setRenderLayer((Block)((Block)DustrialBlocks.GOLD_CHAIN.get()), (RenderType)RenderType.func_228641_d_());
            RenderTypeLookup.setRenderLayer((Block)((Block)DustrialBlocks.LARGE_CHAIN.get()), (RenderType)RenderType.func_228641_d_());
            RenderTypeLookup.setRenderLayer((Block)((Block)DustrialBlocks.LARGE_GOLD_CHAIN.get()), (RenderType)RenderType.func_228641_d_());
            RenderTypeLookup.setRenderLayer((Block)((Block)DustrialBlocks.ANCHOR.get()), (RenderType)RenderType.func_228641_d_());
            RenderTypeLookup.setRenderLayer((Block)((Block)DustrialBlocks.HOOK.get()), (RenderType)RenderType.func_228641_d_());
            RenderTypeLookup.setRenderLayer((Block)((Block)DustrialBlocks.REDSTONE_LANTERN.get()), (RenderType)RenderType.func_228641_d_());
            if (DustrialBlocks.LARGE_ICE_CHAIN != null) {
                RenderTypeLookup.setRenderLayer((Block)((Block)DustrialBlocks.LARGE_ICE_CHAIN.get()), (RenderType)RenderType.func_228641_d_());
            }
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
            LOGGER.info("HELLO from Register Block");
        }
    }
}

