/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.torohealth.display;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;

public class EntityDisplay {
    private static final float RENDER_HEIGHT = 30.0f;
    private static final float RENDER_WIDTH = 18.0f;
    private static final float WIDTH = 40.0f;
    private static final float HEIGHT = 40.0f;
    private LivingEntity entity;
    private int entityScale = 1;
    private float xOffset;
    private float yOffset;

    public void setEntity(LivingEntity entity) {
        this.entity = entity;
        this.updateScale();
    }

    public void draw(MatrixStack matrix) {
        if (this.entity != null) {
            EntityDisplay.drawEntity(matrix, (int)this.xOffset, (int)this.yOffset, this.entityScale, -40.0f, -20.0f, this.entity);
        }
    }

    private void updateScale() {
        if (this.entity == null) {
            return;
        }
        int scaleY = MathHelper.func_76123_f((float)(30.0f / this.entity.func_213302_cg()));
        int scaleX = MathHelper.func_76123_f((float)(18.0f / this.entity.func_213311_cf()));
        this.entityScale = Math.min(scaleX, scaleY);
        if (this.entity instanceof ChickenEntity) {
            this.entityScale = (int)((double)this.entityScale * 0.7);
        }
        this.xOffset = 20.0f;
        this.yOffset = 35.0f;
        if (this.entity instanceof GhastEntity) {
            this.yOffset -= 10.0f;
        }
    }

    public static void drawEntity(MatrixStack matrixStack, int x, int y, int scale, float yaw, float pitch, LivingEntity entity) {
        float h = (float)Math.atan(yaw / 40.0f);
        float l = (float)Math.atan(pitch / 40.0f);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)x, (double)y, 1050.0);
        matrixStack.func_227862_a_(1.0f, 1.0f, -1.0f);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, 1000.0);
        matrixStack.func_227862_a_((float)scale, (float)scale, (float)scale);
        Quaternion quaternion = Vector3f.field_229183_f_.func_229187_a_(180.0f);
        Quaternion quaternion2 = Vector3f.field_229179_b_.func_229187_a_(l * 20.0f);
        quaternion.func_195890_a(quaternion2);
        matrixStack.func_227863_a_(quaternion);
        float m = entity.field_70761_aq;
        float n = entity.field_70177_z;
        float o = entity.field_70125_A;
        float p = entity.field_70758_at;
        float q = entity.field_70759_as;
        entity.field_70761_aq = 180.0f + h * 20.0f;
        entity.field_70177_z = 180.0f + h * 40.0f;
        entity.field_70125_A = -l * 20.0f;
        entity.field_70759_as = entity.field_70177_z;
        entity.field_70758_at = entity.field_70177_z;
        EntityRendererManager entityRenderDispatcher = Minecraft.func_71410_x().func_175598_ae();
        quaternion2.func_195892_e();
        entityRenderDispatcher.func_229089_a_(quaternion2);
        entityRenderDispatcher.func_178633_a(false);
        IRenderTypeBuffer.Impl immediate = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        entityRenderDispatcher.func_229084_a_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixStack, (IRenderTypeBuffer)immediate, 0xF000F0);
        immediate.func_228461_a_();
        matrixStack.func_227865_b_();
        matrixStack.func_227865_b_();
        entityRenderDispatcher.func_178633_a(true);
        entity.field_70761_aq = m;
        entity.field_70177_z = n;
        entity.field_70125_A = o;
        entity.field_70758_at = p;
        entity.field_70759_as = q;
    }
}

