/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.blocks;

import javax.annotation.Nonnull;
import net.mehvahdjukaar.selene.blocks.WaterBlock;
import net.mehvahdjukaar.supplementaries.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.block.tiles.ClockBlockTile;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ClockBlock
extends WaterBlock {
    protected static final VoxelShape SHAPE_NORTH = VoxelShapes.func_197873_a((double)1.0, (double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)0.0625);
    protected static final VoxelShape SHAPE_SOUTH = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.9375);
    protected static final VoxelShape SHAPE_EAST = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)1.0, (double)0.9375, (double)1.0, (double)0.0);
    protected static final VoxelShape SHAPE_WEST = VoxelShapes.func_197873_a((double)1.0, (double)0.0, (double)0.0, (double)0.0625, (double)1.0, (double)1.0);
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final IntegerProperty HOUR = BlockProperties.HOUR;

    public ClockBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return super.func_149645_b(state);
    }

    public static void displayCurrentHour(World world, PlayerEntity player) {
        int time = (int)(world.func_72820_D() + 6000L) % 24000;
        int m = (int)((float)time % 1000.0f / 1000.0f * 60.0f);
        int h = time / 1000;
        String a = "";
        if (!ClientConfigs.cached.CLOCK_24H) {
            String string = a = time < 12000 ? " AM" : " PM";
            if ((h %= 12) == 0) {
                h = 12;
            }
        }
        player.func_146105_b((ITextComponent)new StringTextComponent(h + ":" + (m < 10 ? "0" : "") + m + a), true);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.func_201670_d()) {
            ClockBlock.displayCurrentHour(worldIn, player);
        }
        return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        boolean flag = context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a;
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            default: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: 
        }
        return SHAPE_WEST;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ClockBlockTile();
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = world.func_175625_s(pos);
            if (tileentity instanceof ClockBlockTile) {
                world.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{HOUR, FACING, WATERLOGGED});
    }

    public boolean func_149740_M(@Nonnull BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World world, BlockPos pos) {
        TileEntity te;
        if (world.func_230315_m_().func_236043_f_() && (te = world.func_175625_s(pos)) instanceof ClockBlockTile) {
            return ((ClockBlockTile)te).power;
        }
        return 0;
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.func_220082_b(state, worldIn, pos, oldState, isMoving);
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof ClockBlockTile) {
            ((ClockBlockTile)te).updateInitialTime();
        }
    }
}

