/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.compat.CompatHandler;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BreakableBlock;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import vazkii.quark.api.IConditionalSticky;

public class MagmaCreamBlock
extends BreakableBlock
implements IConditionalSticky {
    public static final DirectionProperty FACING = DirectionalBlock.field_176387_N;

    public MagmaCreamBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.UP));
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity2, float height) {
        if (entity2.func_226272_bl_()) {
            super.func_180658_a(world, pos, entity2, height);
        } else {
            entity2.func_225503_b_(height, 0.0f);
        }
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (CompatHandler.quark) {
            return;
        }
        if (!ClientConfigs.cached.TOOLTIP_HINTS || !Minecraft.func_71410_x().field_71474_y.field_82882_x) {
            return;
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("message.supplementaries.magma_cream_block").func_240699_a_(TextFormatting.ITALIC).func_240699_a_(TextFormatting.GRAY));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        if (context.func_195999_j().func_225608_bj_()) {
            return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_196000_l().func_176734_d());
        }
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_196010_d().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public boolean isSlimeBlock(BlockState state) {
        return true;
    }

    public boolean isStickyBlock(BlockState state) {
        return true;
    }

    public boolean canStickTo(BlockState state, BlockState other) {
        return true;
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        double d0;
        if (!entityIn.func_230279_az_() && entityIn instanceof LivingEntity && !EnchantmentHelper.func_189869_j((LivingEntity)((LivingEntity)entityIn))) {
            entityIn.func_70097_a(DamageSource.field_190095_e, 1.0f);
        }
        if ((d0 = Math.abs(entityIn.func_213322_ci().field_72448_b)) < 0.1 && !entityIn.func_226271_bk_()) {
            double d1 = 0.4 + d0 * 0.2;
            entityIn.func_213317_d(entityIn.func_213322_ci().func_216372_d(d1, 1.0, d1));
        }
        super.func_176199_a(worldIn, pos, entityIn);
    }

    @Override
    public boolean canStickToBlock(World world, BlockPos pistonPos, BlockPos fromPos, BlockPos toPos, BlockState fromState, BlockState toState, Direction moveDir) {
        if (fromState.func_177230_c() == this) {
            Direction stickDir = (Direction)fromState.func_177229_b((Property)FACING);
            if (fromPos.func_177972_a(stickDir).equals((Object)toPos)) {
                return true;
            }
            if (fromPos.func_177972_a(stickDir.func_176734_d()).equals((Object)toPos)) {
                return false;
            }
            if (toState.func_177230_c() == this) {
                Direction stickDir2 = (Direction)toState.func_177229_b((Property)FACING);
                return stickDir2 == stickDir || toPos.func_177972_a(stickDir2).equals((Object)fromPos) && stickDir != stickDir;
            }
            return toState.func_177230_c().isStickyBlock(toState);
        }
        return false;
    }
}

