/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.blocks;

import java.util.ArrayList;
import java.util.Random;
import net.mehvahdjukaar.supplementaries.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.GravelBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class RakedGravelBlock
extends GravelBlock {
    private static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    public static final EnumProperty<BlockProperties.RakeDirection> RAKE_DIRECTION = BlockProperties.RAKE_DIRECTION;

    public RakedGravelBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(RAKE_DIRECTION, (Comparable)((Object)BlockProperties.RakeDirection.NORTH_SOUTH)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{RAKE_DIRECTION});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockstate = super.func_176223_P();
        BlockPos pos = context.func_195995_a();
        World world = context.func_195991_k();
        if (!blockstate.func_196955_c((IWorldReader)world, pos)) {
            return Block.func_199601_a((BlockState)blockstate, (BlockState)Blocks.field_150351_n.func_176223_P(), (World)world, (BlockPos)pos);
        }
        Direction front = context.func_195992_f();
        return RakedGravelBlock.getConnectedState(blockstate, world, pos, front);
    }

    private static boolean canConnect(BlockState state, Direction dir) {
        if (state.func_177230_c() == ModRegistry.RAKED_GRAVEL.get()) {
            return ((BlockProperties.RakeDirection)((Object)state.func_177229_b(RAKE_DIRECTION))).getDirections().contains(dir.func_176734_d());
        }
        return false;
    }

    public static BlockState getConnectedState(BlockState blockstate, World world, BlockPos pos, Direction front) {
        ArrayList<Direction> directionList = new ArrayList<Direction>();
        Direction back = front.func_176734_d();
        if (RakedGravelBlock.canConnect(world.func_180495_p(pos.func_177972_a(back)), back)) {
            directionList.add(back);
        } else {
            directionList.add(front);
        }
        Direction side = front.func_176746_e();
        for (int i = 0; i < 2; ++i) {
            BlockState state = world.func_180495_p(pos.func_177972_a(side));
            if (RakedGravelBlock.canConnect(state, side)) {
                directionList.add(side);
                break;
            }
            side = side.func_176734_d();
        }
        return (BlockState)blockstate.func_206870_a(RAKE_DIRECTION, (Comparable)((Object)BlockProperties.RakeDirection.fromDirections(directionList)));
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        BlockProperties.RakeDirection shape = (BlockProperties.RakeDirection)((Object)state.func_177229_b(RAKE_DIRECTION));
        switch (rotation) {
            case CLOCKWISE_180: {
                switch (shape) {
                    case SOUTH_EAST: {
                        return (BlockState)state.func_206870_a(RAKE_DIRECTION, (Comparable)((Object)BlockProperties.RakeDirection.NORTH_WEST));
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.func_206870_a(RAKE_DIRECTION, (Comparable)((Object)BlockProperties.RakeDirection.NORTH_EAST));
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.func_206870_a(RAKE_DIRECTION, (Comparable)((Object)BlockProperties.RakeDirection.SOUTH_EAST));
                    }
                    case NORTH_EAST: {
                        return (BlockState)state.func_206870_a(RAKE_DIRECTION, (Comparable)((Object)BlockProperties.RakeDirection.SOUTH_WEST));
                    }
                }
                return state;
            }
            case COUNTERCLOCKWISE_90: {
                switch (shape) {
                    case SOUTH_EAST: {
                        return (BlockState)state.func_206870_a(RAKE_DIRECTION, (Comparable)((Object)BlockProperties.RakeDirection.NORTH_EAST));
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.func_206870_a(RAKE_DIRECTION, (Comparable)((Object)BlockProperties.RakeDirection.SOUTH_EAST));
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.func_206870_a(RAKE_DIRECTION, (Comparable)((Object)BlockProperties.RakeDirection.SOUTH_WEST));
                    }
                    case NORTH_EAST: {
                        return (BlockState)state.func_206870_a(RAKE_DIRECTION, (Comparable)((Object)BlockProperties.RakeDirection.NORTH_WEST));
                    }
                    case NORTH_SOUTH: {
                        return (BlockState)state.func_206870_a(RAKE_DIRECTION, (Comparable)((Object)BlockProperties.RakeDirection.EAST_WEST));
                    }
                    case EAST_WEST: {
                        return (BlockState)state.func_206870_a(RAKE_DIRECTION, (Comparable)((Object)BlockProperties.RakeDirection.NORTH_SOUTH));
                    }
                }
            }
            case CLOCKWISE_90: {
                switch (shape) {
                    case SOUTH_EAST: {
                        return (BlockState)state.func_206870_a(RAKE_DIRECTION, (Comparable)((Object)BlockProperties.RakeDirection.SOUTH_WEST));
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.func_206870_a(RAKE_DIRECTION, (Comparable)((Object)BlockProperties.RakeDirection.NORTH_WEST));
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.func_206870_a(RAKE_DIRECTION, (Comparable)((Object)BlockProperties.RakeDirection.NORTH_EAST));
                    }
                    case NORTH_EAST: {
                        return (BlockState)state.func_206870_a(RAKE_DIRECTION, (Comparable)((Object)BlockProperties.RakeDirection.SOUTH_EAST));
                    }
                    case NORTH_SOUTH: {
                        return (BlockState)state.func_206870_a(RAKE_DIRECTION, (Comparable)((Object)BlockProperties.RakeDirection.EAST_WEST));
                    }
                    case EAST_WEST: {
                        return (BlockState)state.func_206870_a(RAKE_DIRECTION, (Comparable)((Object)BlockProperties.RakeDirection.NORTH_SOUTH));
                    }
                }
            }
        }
        return state;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        BlockProperties.RakeDirection shape = (BlockProperties.RakeDirection)((Object)state.func_177229_b(RAKE_DIRECTION));
        block0 : switch (mirror) {
            case LEFT_RIGHT: {
                switch (shape) {
                    case SOUTH_EAST: {
                        return (BlockState)state.func_206870_a(RAKE_DIRECTION, (Comparable)((Object)BlockProperties.RakeDirection.NORTH_EAST));
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.func_206870_a(RAKE_DIRECTION, (Comparable)((Object)BlockProperties.RakeDirection.NORTH_WEST));
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.func_206870_a(RAKE_DIRECTION, (Comparable)((Object)BlockProperties.RakeDirection.SOUTH_WEST));
                    }
                    case NORTH_EAST: {
                        return (BlockState)state.func_206870_a(RAKE_DIRECTION, (Comparable)((Object)BlockProperties.RakeDirection.SOUTH_EAST));
                    }
                }
                return super.func_185471_a(state, mirror);
            }
            case FRONT_BACK: {
                switch (shape) {
                    default: {
                        break block0;
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.func_206870_a(RAKE_DIRECTION, (Comparable)((Object)BlockProperties.RakeDirection.SOUTH_WEST));
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.func_206870_a(RAKE_DIRECTION, (Comparable)((Object)BlockProperties.RakeDirection.SOUTH_EAST));
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.func_206870_a(RAKE_DIRECTION, (Comparable)((Object)BlockProperties.RakeDirection.NORTH_EAST));
                    }
                    case NORTH_EAST: 
                }
                return (BlockState)state.func_206870_a(RAKE_DIRECTION, (Comparable)((Object)BlockProperties.RakeDirection.NORTH_WEST));
            }
        }
        return super.func_185471_a(state, mirror);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public boolean func_196266_a(BlockState state, IBlockReader reader, BlockPos pos, PathType pathType) {
        return false;
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState fromState, IWorld world, BlockPos pos, BlockPos fromPos) {
        if (direction == Direction.UP && !state.func_196955_c((IWorldReader)world, pos)) {
            world.func_205220_G_().func_205360_a(pos, (Object)this, 1);
        }
        return super.func_196271_a(state, direction, fromState, world, pos, fromPos);
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (!state.func_196955_c((IWorldReader)world, pos)) {
            RakedGravelBlock.turnToGravel(state, (World)world, pos);
        }
        super.func_225534_a_(state, world, pos, random);
    }

    public static void turnToGravel(BlockState state, World world, BlockPos pos) {
        world.func_175656_a(pos, RakedGravelBlock.func_199601_a((BlockState)state, (BlockState)Blocks.field_150351_n.func_176223_P(), (World)world, (BlockPos)pos));
    }

    public boolean func_196260_a(BlockState p_196260_1_, IWorldReader p_196260_2_, BlockPos p_196260_3_) {
        BlockState blockstate = p_196260_2_.func_180495_p(p_196260_3_.func_177984_a());
        return !blockstate.func_185904_a().func_76220_a() || blockstate.func_177230_c() instanceof FenceGateBlock;
    }
}

