/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.tiles;

import java.util.Locale;
import net.mehvahdjukaar.supplementaries.block.blocks.GlobeBlock;
import net.mehvahdjukaar.supplementaries.common.SpecialPlayers;
import net.mehvahdjukaar.supplementaries.common.Textures;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.INameable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GlobeBlockTile
extends TileEntity
implements ITickableTileEntity,
INameable {
    public float yaw = 0.0f;
    public float prevYaw = 0.0f;
    public int face = 0;
    private ITextComponent customName;
    public boolean sheared = false;
    public ResourceLocation texture = null;
    public boolean isFlat = false;
    public boolean isSnow = false;

    public GlobeBlockTile() {
        super((TileEntityType)ModRegistry.GLOBE_TILE.get());
    }

    public void setCustomName(ITextComponent name) {
        this.customName = name;
        this.updateTexture();
    }

    private void updateTexture() {
        if (this.func_145818_k_()) {
            this.isFlat = false;
            this.texture = GlobeType.getGlobeTexture(this.func_200201_e().getString(), this);
        } else {
            this.texture = null;
        }
    }

    public ITextComponent func_200200_C_() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    public ITextComponent func_200201_e() {
        return this.customName;
    }

    public ITextComponent getDefaultName() {
        return new TranslationTextComponent("block.supplementaries.globe");
    }

    public double func_145833_n() {
        return 80.0;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        if (compound.func_150297_b("CustomName", 8)) {
            this.setCustomName((ITextComponent)ITextComponent.Serializer.func_240643_a_((String)compound.func_74779_i("CustomName")));
        }
        this.face = compound.func_74762_e("Face");
        this.yaw = compound.func_74760_g("Yaw");
        this.sheared = compound.func_74767_n("Sheared");
        super.func_230337_a_(state, compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (this.customName != null) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        compound.func_74768_a("Face", this.face);
        compound.func_74776_a("Yaw", this.yaw);
        compound.func_74757_a("Sheared", this.sheared);
        return compound;
    }

    public void spin() {
        int spin = 360;
        int inc = 90;
        this.face -= inc;
        this.face %= 360;
        this.yaw = this.yaw + (float)spin + (float)inc;
        this.prevYaw = this.prevYaw + (float)spin + (float)inc;
        this.func_70296_d();
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.spin();
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public void func_73660_a() {
        this.prevYaw = this.yaw;
        if (this.yaw != 0.0f) {
            if (this.yaw < 0.0f) {
                this.yaw = 0.0f;
                this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
            } else {
                this.yaw = this.yaw * 0.94f - 0.7f;
            }
        }
    }

    public Direction getDirection() {
        return (Direction)this.func_195044_w().func_177229_b((Property)GlobeBlock.FACING);
    }

    public static enum GlobeType {
        FLAT(new String[]{"flat", "flat earth"}, new TranslationTextComponent("globe.supplementaries.flat"), Textures.GLOBE_FLAT_TEXTURE),
        MOON(new String[]{"moon", "luna", "selene", "cynthia"}, new TranslationTextComponent("globe.supplementaries.moon"), Textures.GLOBE_MOON_TEXTURE),
        EARTH(new String[]{"earth", "terra", "gaia", "gaea", "tierra", "tellus", "terre"}, new TranslationTextComponent("globe.supplementaries.earth"), Textures.GLOBE_TEXTURE),
        SUN(new String[]{"sun", "sol", "helios"}, new TranslationTextComponent("globe.supplementaries.sun"), Textures.GLOBE_SUN_TEXTURE);

        public final String[] keyWords;
        public final TranslationTextComponent transKeyWord;
        public final ResourceLocation texture;

        private GlobeType(String[] key, TranslationTextComponent tr, ResourceLocation res) {
            this.keyWords = key;
            this.transKeyWord = tr;
            this.texture = res;
        }

        public static ResourceLocation getGlobeTexture(String text, GlobeBlockTile tile) {
            String name = text.toLowerCase(Locale.ROOT);
            ResourceLocation r = SpecialPlayers.GLOBES.get(name);
            boolean bl = tile.isSnow = r != null && r.func_110623_a().contains("globe_wais");
            if (r != null) {
                return r;
            }
            for (GlobeType n : GlobeType.values()) {
                if (n.keyWords == null) continue;
                if (n.transKeyWord != null && !n.transKeyWord.getString().equals("") && name.equals(n.transKeyWord.getString().toLowerCase(Locale.ROOT))) {
                    tile.isFlat = n == FLAT;
                    return n.texture;
                }
                for (String s : n.keyWords) {
                    if (s.equals("") || !name.equals(s)) continue;
                    tile.isFlat = n == FLAT;
                    return n.texture;
                }
            }
            return null;
        }
    }
}

