/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.tiles;

import java.util.List;
import java.util.Random;
import net.mehvahdjukaar.supplementaries.block.blocks.PistonLauncherArmBlock;
import net.mehvahdjukaar.supplementaries.block.blocks.SpringLauncherBlock;
import net.mehvahdjukaar.supplementaries.block.blocks.SpringLauncherHeadBlock;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public class PistonLauncherArmBlockTile
extends TileEntity
implements ITickableTileEntity {
    public int age = 0;
    private double increment = 0.0;
    public double offset = 0.0;
    public double prevOffset = 0.0;
    private int dx = 0;
    private int dy = 0;
    private int dz = 0;
    protected final Random rand = new Random();

    public PistonLauncherArmBlockTile() {
        super((TileEntityType)ModRegistry.PISTON_LAUNCHER_ARM_TILE.get());
    }

    public PistonLauncherArmBlockTile(boolean extending, Direction dir) {
        this();
        this.age = 0;
        if (extending) {
            this.increment = 0.5;
            this.offset = -1.0;
            this.prevOffset = -1.0;
        } else {
            this.increment = -0.5;
            this.offset = 0.0;
            this.prevOffset = 0.0;
        }
        Vector3i v = dir.func_176730_m();
        this.dx = v.func_177958_n();
        this.dy = v.func_177956_o();
        this.dz = v.func_177952_p();
    }

    public double func_145833_n() {
        return 96.0;
    }

    public AxisAlignedBB getAdjustedBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c).func_72317_d((double)this.dx * this.offset, (double)this.dy * this.offset, (double)this.dz * this.offset);
    }

    public void func_73660_a() {
        if (this.field_145850_b.func_201670_d() && this.getExtending()) {
            double x = (double)this.field_174879_c.func_177958_n() + 0.5 + (double)this.dx * this.offset;
            double y = (double)this.field_174879_c.func_177956_o() + (double)this.dy * this.offset;
            double z = (double)this.field_174879_c.func_177952_p() + 0.5 + (double)this.dz * this.offset;
            Random random = this.rand;
            for (int l = 0; l < 2; ++l) {
                double d0 = x + (double)random.nextFloat() - 0.5;
                double d1 = y + (double)random.nextFloat() + 0.5;
                double d2 = z + (double)random.nextFloat() - 0.5;
                double d3 = ((double)random.nextFloat() - 0.5) * 0.05;
                double d4 = ((double)random.nextFloat() - 0.5) * 0.05;
                double d5 = ((double)random.nextFloat() - 0.5) * 0.05;
                this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197613_f, d0, d1, d2, d3, d4, d5);
            }
        }
        if (this.age > 1) {
            this.prevOffset = this.offset;
            if (!this.field_145850_b.func_201670_d()) {
                if (this.getExtending()) {
                    BlockState _bs = ((Block)ModRegistry.SPRING_LAUNCHER_HEAD.get()).func_176223_P();
                    this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)_bs.func_206870_a((Property)SpringLauncherHeadBlock.FACING, (Comparable)this.getDirection()), 3);
                } else {
                    BlockState _bs = ((Block)ModRegistry.SPRING_LAUNCHER.get()).func_176223_P();
                    BlockPos _bp = this.field_174879_c.func_177972_a(this.getDirection().func_176734_d());
                    BlockState oldState = this.field_145850_b.func_180495_p(_bp);
                    if (((BlockState)_bs.func_206870_a((Property)SpringLauncherBlock.FACING, (Comparable)this.getDirection())).func_206870_a((Property)SpringLauncherBlock.EXTENDED, (Comparable)Boolean.valueOf(true)) == oldState) {
                        this.field_145850_b.func_180501_a(_bp, (BlockState)oldState.func_206870_a((Property)SpringLauncherBlock.EXTENDED, (Comparable)Boolean.valueOf(false)), 3);
                    }
                    this.field_145850_b.func_180501_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P(), 3);
                }
            }
        } else {
            AxisAlignedBB p_bb;
            List list1;
            ++this.age;
            this.prevOffset = this.offset;
            this.offset += this.increment;
            if (this.getExtending() && !(list1 = this.field_145850_b.func_72839_b(null, p_bb = this.getAdjustedBoundingBox())).isEmpty()) {
                for (Entity entity2 : list1) {
                    if (entity2.func_184192_z() == PushReaction.IGNORE) continue;
                    Vector3d vec3d = entity2.func_213322_ci();
                    double d1 = vec3d.field_72450_a;
                    double d2 = vec3d.field_72448_b;
                    double d3 = vec3d.field_72449_c;
                    double speed = ServerConfigs.cached.LAUNCHER_VEL;
                    if (this.dx != 0) {
                        d1 = (double)this.dx * speed;
                    }
                    if (this.dy != 0) {
                        d2 = (double)this.dy * speed;
                    }
                    if (this.dz != 0) {
                        d3 = (double)this.dz * speed;
                    }
                    entity2.func_213293_j(d1, d2, d3);
                    entity2.field_70133_I = true;
                    this.moveCollidedEntity(entity2, p_bb);
                }
            }
        }
    }

    private void moveCollidedEntity(Entity entity2, AxisAlignedBB p_bb) {
        AxisAlignedBB e_bb = entity2.func_174813_aQ();
        double dx = 0.0;
        double dy = 0.0;
        double dz = 0.0;
        switch (this.getDirection()) {
            default: {
                dy = 0.0;
                break;
            }
            case UP: {
                dy = p_bb.field_72337_e - e_bb.field_72338_b;
                break;
            }
            case DOWN: {
                dy = p_bb.field_72338_b - e_bb.field_72337_e;
                break;
            }
            case NORTH: {
                dz = p_bb.field_72339_c - e_bb.field_72334_f;
                break;
            }
            case SOUTH: {
                dz = p_bb.field_72334_f - e_bb.field_72339_c;
                break;
            }
            case WEST: {
                dx = p_bb.field_72340_a - e_bb.field_72336_d;
                break;
            }
            case EAST: {
                dx = p_bb.field_72336_d - e_bb.field_72340_a;
            }
        }
        entity2.func_213315_a(MoverType.PISTON, new Vector3d(dx, dy, dz));
    }

    public Direction getDirection() {
        return (Direction)this.func_195044_w().func_177229_b((Property)PistonLauncherArmBlock.FACING);
    }

    public boolean getExtending() {
        return (Boolean)this.func_195044_w().func_177229_b((Property)PistonLauncherArmBlock.EXTENDING);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.age = compound.func_74762_e("Age");
        this.offset = compound.func_74769_h("Offset");
        this.prevOffset = compound.func_74769_h("PrevOffset");
        this.increment = compound.func_74769_h("Increment");
        this.dx = compound.func_74762_e("Dx");
        this.dy = compound.func_74762_e("Dy");
        this.dz = compound.func_74762_e("Dz");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("Age", this.age);
        compound.func_74780_a("Offset", this.offset);
        compound.func_74780_a("PrevOffset", this.prevOffset);
        compound.func_74780_a("Increment", this.increment);
        compound.func_74768_a("Dx", this.dx);
        compound.func_74768_a("Dy", this.dy);
        compound.func_74768_a("Dz", this.dz);
        return compound;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }
}

