/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.mehvahdjukaar.supplementaries.block.blocks.BlackboardBlock;
import net.mehvahdjukaar.supplementaries.common.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;

public class BlackBoardButton
extends AbstractGui
implements IRenderable,
IGuiEventListener {
    public int u;
    public int v;
    public int x;
    public int y;
    public static final int WIDTH = 6;
    private boolean wasHovered;
    protected boolean isHovered;
    public byte color = 0;
    private boolean focused;
    private final IDraggable onDragged;
    protected final IPressable onPress;

    public BlackBoardButton(int center_x, int center_y, int u, int v, IPressable pressedAction, IDraggable dragAction) {
        this.x = center_x - (8 - u) * 6;
        this.y = center_y - -v * 6;
        this.u = u;
        this.v = v;
        this.onPress = pressedAction;
        this.onDragged = dragAction;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.isHovered = this.func_231047_b_(mouseX, mouseY);
        this.renderButton(matrixStack);
        this.wasHovered = this.isHovered();
    }

    public void renderButton(MatrixStack matrixStack) {
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.func_110434_K().func_110577_a(Textures.BLACKBOARD_GUI_TEXTURE);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int offset = this.color > 0 ? 16 : 0;
        int rgb = BlackboardBlock.colorFromByte(this.color);
        float b = (float)NativeImage.func_227791_b_((int)rgb) / 255.0f;
        float g = (float)NativeImage.func_227793_c_((int)rgb) / 255.0f;
        float r = (float)NativeImage.func_227795_d_((int)rgb) / 255.0f;
        RenderSystem.color4f((float)r, (float)g, (float)b, (float)1.0f);
        BlackBoardButton.func_238463_a_((MatrixStack)matrixStack, (int)this.x, (int)this.y, (float)((this.u + offset) * 6), (float)(this.v * 6), (int)6, (int)6, (int)192, (int)96);
    }

    public void renderTooltip(MatrixStack matrixStack) {
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.color4f((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        BlackBoardButton.func_238463_a_((MatrixStack)matrixStack, (int)(this.x - 1), (int)(this.y - 1), (float)96.0f, (float)0.0f, (int)8, (int)8, (int)192, (int)96);
        this.renderButton(matrixStack);
    }

    public void onClick(double mouseX, double mouseY) {
        this.color = (byte)(this.color == 0 ? 1 : 0);
        this.onPress.onPress(this.u, this.v, this.color != 0);
    }

    public void onRelease(double mouseX, double mouseY) {
    }

    protected void onDrag(double mouseX, double mouseY, boolean on) {
        this.color = (byte)(on ? 1 : 0);
        this.onPress.onPress(this.u, this.v, this.color != 0);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        boolean flag;
        if (this.isValidClickButton(button) && (flag = this.func_231047_b_(mouseX, mouseY))) {
            this.playDownSound(Minecraft.func_71410_x().func_147118_V());
            this.onClick(mouseX, mouseY);
            return true;
        }
        return false;
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        if (this.isValidClickButton(button)) {
            this.onRelease(mouseX, mouseY);
            return true;
        }
        return false;
    }

    protected boolean isValidClickButton(int button) {
        return button == 0;
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isValidClickButton(button)) {
            this.onDragged.onPress(mouseX, mouseY, this.color != 0);
            return true;
        }
        return false;
    }

    public boolean isHovered() {
        return this.isHovered || this.focused;
    }

    public boolean func_231049_c__(boolean focus) {
        this.focused = !this.focused;
        return this.focused;
    }

    public boolean func_231047_b_(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseY >= (double)this.y && mouseX < (double)(this.x + 6) && mouseY < (double)(this.y + 6);
    }

    public void playDownSound(SoundHandler handler) {
        handler.func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    public static interface IDraggable {
        public void onPress(double var1, double var3, boolean var5);
    }

    public static interface IPressable {
        public void onPress(int var1, int var2, boolean var3);
    }
}

