/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.mehvahdjukaar.supplementaries.block.tiles.SpeakerBlockTile;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.network.UpdateServerSpeakerBlockPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.widget.Slider;

public class SpeakerBlockGui
extends Screen {
    private static final ITextComponent NARRATOR_TEXT = new TranslationTextComponent("gui.supplementaries.speaker_block.chat_message");
    private static final ITextComponent CHAT_TEXT = new TranslationTextComponent("gui.supplementaries.speaker_block.narrator_message");
    private static final ITextComponent DISTANCE_BLOCKS = new TranslationTextComponent("gui.supplementaries.speaker_block.blocks");
    private static final ITextComponent VOLUME_TEXT = new TranslationTextComponent("gui.supplementaries.speaker_block.volume");
    private TextFieldWidget commandTextField;
    private final SpeakerBlockTile tileSpeaker;
    private boolean narrator;
    private final String message;
    private Button modeBtn;
    private Slider volume;

    public SpeakerBlockGui(SpeakerBlockTile te) {
        super((ITextComponent)new TranslationTextComponent("gui.supplementaries.speaker_block.edit"));
        this.tileSpeaker = te;
        this.narrator = this.tileSpeaker.narrator;
        this.message = this.tileSpeaker.message;
    }

    public static void open(SpeakerBlockTile te) {
        Minecraft.func_71410_x().func_147108_a((Screen)new SpeakerBlockGui(te));
    }

    public void func_231023_e_() {
        this.commandTextField.func_146178_a();
    }

    private void updateMode() {
        if (this.narrator) {
            this.modeBtn.func_238482_a_(NARRATOR_TEXT);
        } else {
            this.modeBtn.func_238482_a_(CHAT_TEXT);
        }
    }

    private void toggleMode() {
        this.narrator = !this.narrator;
    }

    public void func_231160_c_() {
        assert (this.field_230706_i_ != null);
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        int range = ServerConfigs.cached.SPEAKER_RANGE;
        double v = this.tileSpeaker.volume * (double)range;
        this.volume = new Slider(this.field_230708_k_ / 2 - 75, this.field_230709_l_ / 4 + 80, 150, 20, VOLUME_TEXT, DISTANCE_BLOCKS, 1.0, (double)range, v, false, true, null, null);
        this.func_230481_d_((IGuiEventListener)this.volume);
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 4 + 120, 200, 20, DialogTexts.field_240632_c_, p_214266_1_ -> this.close()));
        this.modeBtn = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 75, this.field_230709_l_ / 4 + 50, 150, 20, CHAT_TEXT, p_214186_1_ -> {
            this.toggleMode();
            this.updateMode();
        }));
        this.updateMode();
        this.commandTextField = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 4 + 10, 200, 20, this.field_230704_d_){

            protected IFormattableTextComponent func_230442_c_() {
                return super.func_230442_c_();
            }
        };
        this.commandTextField.func_146180_a(this.message);
        this.commandTextField.func_146203_f(32);
        this.field_230705_e_.add(this.commandTextField);
        this.func_212928_a((IGuiEventListener)this.commandTextField);
        this.commandTextField.func_146195_b(true);
    }

    public void func_231164_f_() {
        this.field_230706_i_.field_195559_v.func_197967_a(false);
        this.tileSpeaker.message = this.commandTextField.func_146179_b();
        this.tileSpeaker.narrator = this.narrator;
        this.tileSpeaker.volume = this.volume.getValue() / this.volume.maxValue;
        NetworkHandler.INSTANCE.sendToServer((Object)new UpdateServerSpeakerBlockPacket(this.tileSpeaker.func_174877_v(), this.tileSpeaker.message, this.tileSpeaker.narrator, this.tileSpeaker.volume));
    }

    private void close() {
        this.tileSpeaker.func_70296_d();
        this.field_230706_i_.func_147108_a(null);
    }

    public void func_231175_as__() {
        this.close();
    }

    public boolean func_231046_a_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (super.func_231046_a_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_)) {
            return true;
        }
        if (p_keyPressed_1_ != 257 && p_keyPressed_1_ != 335) {
            return false;
        }
        this.close();
        return true;
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.volume.func_231000_a__(mouseX, mouseY);
        }
        return false;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        SpeakerBlockGui.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)40, (int)0xFFFFFF);
        this.volume.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.commandTextField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }
}

