/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.compat.configured;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.configured.client.screen.ConfigScreen;
import com.mrcrayfish.configured.client.screen.ListMenuScreen;
import com.mrcrayfish.configured.client.util.ScreenUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.renderers.RendererUtil;
import net.mehvahdjukaar.supplementaries.compat.configured.CustomConfigSelectScreen;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.ConfigHandler;
import net.mehvahdjukaar.supplementaries.datagen.types.VanillaWoodTypes;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class CustomConfigScreen
extends ConfigScreen {
    private final ResourceLocation background;
    private static final Map<String, ItemStack> ICONS = new HashMap<String, ItemStack>();
    public static final ItemStack MAIN_ICON = new ItemStack((IItemProvider)ModRegistry.GLOBE_ITEM.get());
    @Nullable
    private static final Field FOLDER_LABEL;
    @Nullable
    private static final Field BUTTON_ON_PRESS;
    @Nullable
    private static final Field FOLDER_ENTRY;
    @Nullable
    private static final Method SAVE_CONFIG;
    @Nullable
    private static final Field CONFIG_VALUE_HOLDER;
    @Nullable
    private static final Field BOOLEAN_ITEM_BUTTON;
    private int ticks = 0;

    private ItemStack getIcon(String name) {
        String formatted;
        Item item2;
        if (!ICONS.containsKey(name) && (item2 = (Item)ForgeRegistries.ITEMS.getValue(Supplementaries.res(formatted = name.toLowerCase(Locale.ROOT).replace(" ", "_")))) != Items.field_190931_a) {
            CustomConfigScreen.addIcon(name, (IItemProvider)item2);
        }
        return ICONS.getOrDefault(name, MAIN_ICON);
    }

    @Nullable
    private static Method findMethodOrNull(Class<?> c, String methodName) {
        Method field = null;
        try {
            field = ObfuscationReflectionHelper.findMethod(c, (String)methodName, (Class[])new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return field;
    }

    @Nullable
    private static <T> Field findFieldOrNull(Class<T> c, String fieldName) {
        Field field = null;
        try {
            field = ObfuscationReflectionHelper.findField(c, (String)fieldName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return field;
    }

    private static void addIcon(String s, IItemProvider i) {
        ICONS.put(s, new ItemStack(i));
    }

    private CustomConfigScreen(Screen parent, ITextComponent title, ModConfig config, ResourceLocation background, ConfigScreen.FolderEntry folderEntry) {
        this(parent, title, config, background);
        try {
            FOLDER_ENTRY.set((Object)this, folderEntry);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public CustomConfigScreen(Screen parent, ITextComponent title, ModConfig config, ResourceLocation background) {
        super(parent, title, config, background);
        this.background = background;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        boolean reg2 = this.config == ConfigHandler.REGISTRY_CONFIG_OBJECT && !this.folderEntry.isRoot();
        this.list.func_230942_a_(this.replaceItems(this.list.func_231039_at__(), reg2));
        Collection<ListMenuScreen.Item> temp = this.replaceItems(this.entries, reg2);
        this.entries = new ArrayList<ListMenuScreen.Item>(temp);
        if (this.saveButton != null && SAVE_CONFIG != null && BUTTON_ON_PRESS != null) {
            try {
                Button.IPressable press = this::saveButtonAction;
                BUTTON_ON_PRESS.set(this.saveButton, press);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Collection<ListMenuScreen.Item> replaceItems(Collection<ListMenuScreen.Item> originals, boolean fancyBooleans) {
        ArrayList<ListMenuScreen.Item> newList = new ArrayList<ListMenuScreen.Item>();
        for (ListMenuScreen.Item c : originals) {
            ConfigScreen.BooleanItem b;
            Object wrapper;
            if (c instanceof ConfigScreen.FolderItem) {
                ConfigScreen.FolderItem f = (ConfigScreen.FolderItem)c;
                wrapper = this.wrapFolderItem(f);
                if (wrapper != null) {
                    newList.add((ListMenuScreen.Item)wrapper);
                    continue;
                }
            } else if (c instanceof ConfigScreen.BooleanItem && (wrapper = this.wrapBooleanItem(b = (ConfigScreen.BooleanItem)c, fancyBooleans)) != null) {
                newList.add((ListMenuScreen.Item)wrapper);
                continue;
            }
            newList.add(c);
        }
        return newList;
    }

    public void saveButtonAction(Button button) {
        if (this.config != null) {
            try {
                SAVE_CONFIG.invoke((Object)this, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.isChanged(this.folderEntry)) {
                if (this.config == ConfigHandler.SERVER_CONFIG_OBJECT) {
                    ConfigHandler.clientRequestServerConfigReload();
                } else if (this.config == ConfigHandler.CLIENT_CONFIG_OBJECT) {
                    ClientConfigs.cached.refresh();
                }
            }
        }
        this.field_230706_i_.func_147108_a(this.parent);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (ScreenUtil.isMouseWithin((int)(this.field_230708_k_ / 2 - 90), (int)2, (int)180, (int)16, (int)mouseX, (int)mouseY)) {
            this.func_238654_b_(matrixStack, this.field_230712_o_.func_238425_b_((ITextProperties)new TranslationTextComponent("supplementaries.gui.info"), 200), mouseX, mouseY);
        }
        int titleWidth = this.field_230712_o_.func_238414_a_((ITextProperties)this.field_230704_d_) + 35;
        this.field_230707_j_.func_239390_c_(MAIN_ICON, this.field_230708_k_ / 2 + titleWidth / 2 - 17, 2);
        this.field_230707_j_.func_239390_c_(MAIN_ICON, this.field_230708_k_ / 2 - titleWidth / 2, 2);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (ScreenUtil.isMouseWithin((int)(this.field_230708_k_ / 2 - 90), (int)2, (int)180, (int)16, (int)((int)mouseX), (int)((int)mouseY))) {
            Style style = Style.field_240709_b_.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/supplementaries"));
            this.func_230455_a_(style);
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        ++this.ticks;
    }

    @Nullable
    public FolderWrapper wrapFolderItem(ConfigScreen.FolderItem old) {
        ConfigScreen.FolderEntry folderEntry = this.folderEntry;
        try {
            String oldName = old.getLabel();
            ConfigScreen.FolderEntry found = null;
            for (ConfigScreen.IEntry e : folderEntry.getEntries()) {
                if (!(e instanceof ConfigScreen.FolderEntry)) continue;
                ConfigScreen.FolderEntry f = (ConfigScreen.FolderEntry)e;
                String n = new StringTextComponent(ConfigScreen.createLabel((String)((String)FOLDER_LABEL.get(e)))).func_150261_e();
                if (!n.equals(oldName)) continue;
                found = f;
            }
            if (found != null) {
                return new FolderWrapper(found, oldName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    public BooleanWrapper wrapBooleanItem(ConfigScreen.BooleanItem old, boolean displayItem) {
        ConfigScreen.FolderEntry folderEntry = this.folderEntry;
        try {
            ConfigScreen.ValueHolder holder = (ConfigScreen.ValueHolder)CONFIG_VALUE_HOLDER.get(old);
            ConfigScreen.ValueEntry found = null;
            for (ConfigScreen.IEntry e : folderEntry.getEntries()) {
                ConfigScreen.ValueEntry value;
                if (!(e instanceof ConfigScreen.ValueEntry) || holder != (value = (ConfigScreen.ValueEntry)e).getHolder()) continue;
                found = value;
            }
            if (found != null) {
                return displayItem ? new BooleanWrapperItem((ConfigScreen.ValueHolder<Boolean>)holder) : new BooleanWrapper((ConfigScreen.ValueHolder<Boolean>)holder);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static {
        CustomConfigScreen.addIcon("blocks", (IItemProvider)Items.field_221654_ao);
        CustomConfigScreen.addIcon("entities", (IItemProvider)Items.field_179555_bs);
        CustomConfigScreen.addIcon("general", (IItemProvider)Items.field_221651_bN);
        CustomConfigScreen.addIcon("particles", (IItemProvider)Items.field_151065_br);
        CustomConfigScreen.addIcon("items", (IItemProvider)Items.field_151166_bC);
        CustomConfigScreen.addIcon("spawns", (IItemProvider)Items.field_221943_hD);
        CustomConfigScreen.addIcon("tweaks", (IItemProvider)Items.field_151097_aZ);
        CustomConfigScreen.addIcon("turn particles", (IItemProvider)ModRegistry.TURN_TABLE.get());
        CustomConfigScreen.addIcon("captured mobs", (IItemProvider)ModRegistry.CAGE_ITEM.get());
        CustomConfigScreen.addIcon("flag", (IItemProvider)ModRegistry.FLAGS_ITEMS.get(DyeColor.WHITE).get());
        CustomConfigScreen.addIcon("way sign", (IItemProvider)ModRegistry.SIGN_POST_ITEMS.get(VanillaWoodTypes.OAK).get());
        CustomConfigScreen.addIcon("bells tweaks", (IItemProvider)Items.field_222109_pP);
        CustomConfigScreen.addIcon("cake tweaks", (IItemProvider)Items.field_222070_lD);
        CustomConfigScreen.addIcon("hanging flower pots", (IItemProvider)Items.field_222087_nH);
        CustomConfigScreen.addIcon("throwable bricks", (IItemProvider)Items.field_151118_aC);
        CustomConfigScreen.addIcon("wall lantern", (IItemProvider)Items.field_222111_pQ);
        CustomConfigScreen.addIcon("placeable sticks", (IItemProvider)Items.field_151055_y);
        CustomConfigScreen.addIcon("placeable sticks", (IItemProvider)Items.field_151055_y);
        CustomConfigScreen.addIcon("brewing stand colors", (IItemProvider)Items.field_222088_mr);
        CustomConfigScreen.addIcon("timber frame", (IItemProvider)ModRegistry.TIMBER_BRACE_ITEM.get());
        CustomConfigScreen.addIcon("bottle xp", (IItemProvider)Items.field_151062_by);
        CustomConfigScreen.addIcon("map tweaks", (IItemProvider)Items.field_151098_aY);
        CustomConfigScreen.addIcon("ceiling banners", (IItemProvider)Items.field_196205_eu);
        CustomConfigScreen.addIcon("initialization", (IItemProvider)ModRegistry.COG_BLOCK_ITEM.get());
        CustomConfigScreen.addIcon("zombie horse", (IItemProvider)Items.field_196178_dg);
        CustomConfigScreen.addIcon("placeable gunpowder", (IItemProvider)Items.field_151016_H);
        CustomConfigScreen.addIcon("mixins", (IItemProvider)Items.field_221862_eo);
        CustomConfigScreen.addIcon("server protection", (IItemProvider)Items.field_221747_dJ);
        CustomConfigScreen.addIcon("placeable books", (IItemProvider)Items.field_151134_bR);
        CustomConfigScreen.addIcon("sign post", (IItemProvider)ModRegistry.SIGN_POST_ITEMS.get(VanillaWoodTypes.OAK).get());
        CustomConfigScreen.addIcon("wattle and daub", (IItemProvider)ModRegistry.DAUB_BRACE_ITEM.get());
        CustomConfigScreen.addIcon("shulker shell", (IItemProvider)Items.field_190930_cZ);
        CustomConfigScreen.addIcon("jar tab", (IItemProvider)ModRegistry.JAR_ITEM.get());
        CustomConfigScreen.addIcon("dispensers", (IItemProvider)Items.field_221656_ap);
        CustomConfigScreen.addIcon("hanging sign", (IItemProvider)ModRegistry.HANGING_SIGNS_ITEMS.get(VanillaWoodTypes.OAK).get());
        CustomConfigScreen.addIcon("blue bomb", (IItemProvider)ModRegistry.BOMB_BLUE_ITEM_ON.get());
        CustomConfigScreen.addIcon("dispensers", (IItemProvider)Items.field_221656_ap);
        CustomConfigScreen.addIcon("structures", (IItemProvider)Items.field_221647_bL);
        CustomConfigScreen.addIcon("mob head tweaks", (IItemProvider)Items.field_196182_dv);
        CustomConfigScreen.addIcon("conditional sign registration", (IItemProvider)Items.field_221803_eL);
        FOLDER_LABEL = CustomConfigScreen.findFieldOrNull(ConfigScreen.FolderEntry.class, "label");
        BUTTON_ON_PRESS = CustomConfigScreen.findFieldOrNull(Button.class, "onPress");
        FOLDER_ENTRY = CustomConfigScreen.findFieldOrNull(ConfigScreen.class, "folderEntry");
        SAVE_CONFIG = CustomConfigScreen.findMethodOrNull(ConfigScreen.class, "saveConfig");
        CONFIG_VALUE_HOLDER = CustomConfigScreen.findFieldOrNull(ConfigScreen.ConfigItem.class, "holder");
        BOOLEAN_ITEM_BUTTON = CustomConfigScreen.findFieldOrNull(ConfigScreen.BooleanItem.class, "button");
    }

    private class BooleanWrapper
    extends ConfigScreen.BooleanItem {
        private static final int ICON_WIDTH = 12;
        protected Button button;
        protected boolean active;
        protected int iconOffset;

        public BooleanWrapper(ConfigScreen.ValueHolder<Boolean> holder) {
            super((ConfigScreen)CustomConfigScreen.this, holder);
            this.active = false;
            this.iconOffset = 0;
            try {
                this.button = (Button)BOOLEAN_ITEM_BUTTON.get((Object)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.button.func_238482_a_((ITextComponent)new StringTextComponent(""));
        }

        public void func_230432_a_(MatrixStack poseStack, int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            this.button.func_238482_a_((ITextComponent)new StringTextComponent(""));
            super.func_230432_a_(poseStack, index, top, left, width, p_230432_6_, mouseX, mouseY, hovered, partialTicks);
            Minecraft minecraft = Minecraft.func_71410_x();
            minecraft.func_110434_K().func_110577_a(CustomConfigSelectScreen.ICONS_TEXTURES);
            RenderSystem.enableDepthTest();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            int iconX = this.iconOffset + (int)((double)this.button.field_230690_l_ + Math.ceil((float)(this.button.func_230998_h_() - 12) / 2.0f));
            int iconY = (int)((double)this.button.field_230691_m_ + Math.ceil((float)(this.button.func_238483_d_() - 12) / 2.0f));
            int u = (Boolean)this.holder.getValue() != false ? 12 : 0;
            AbstractGui.func_238464_a_((MatrixStack)poseStack, (int)iconX, (int)iconY, (int)this.button.func_230927_p_(), (float)u, (float)0.0f, (int)12, (int)12, (int)64, (int)64);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        public void onResetValue() {
            this.button.func_238482_a_((ITextComponent)new StringTextComponent(""));
        }
    }

    private class BooleanWrapperItem
    extends BooleanWrapper {
        private final ItemStack item;

        public BooleanWrapperItem(ConfigScreen.ValueHolder<Boolean> holder) {
            super(holder);
            this.item = CustomConfigScreen.this.getIcon(this.label.func_150261_e().toLowerCase(Locale.ROOT));
            this.iconOffset = 7;
        }

        @Override
        public void func_230432_a_(MatrixStack poseStack, int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            boolean on = (Boolean)this.holder.getValue();
            super.func_230432_a_(poseStack, index, top, left, width, p_230432_6_, mouseX, mouseY, hovered, partialTicks);
            int light = on ? 0xF000F0 : 0;
            int center = (int)((float)this.button.field_230690_l_ + (float)this.button.func_230998_h_() / 2.0f);
            ItemRenderer renderer = CustomConfigScreen.this.field_230707_j_;
            RendererUtil.renderGuiItemRelative(this.item, center - 8 - this.iconOffset, top + 2, renderer, (a, b) -> {}, light, OverlayTexture.field_229196_a_);
        }

        @Override
        public void onResetValue() {
            this.button.func_238482_a_((ITextComponent)new StringTextComponent(""));
        }
    }

    private class FolderWrapper
    extends ConfigScreen.FolderItem {
        private final ItemStack icon;
        protected final Button button;
        private int ticks;
        private int lastTick;

        private FolderWrapper(ConfigScreen.FolderEntry folderEntry, String label) {
            super((ConfigScreen)CustomConfigScreen.this, folderEntry);
            this.ticks = 0;
            this.lastTick = 1;
            this.button = new Button(10, 5, 44, 20, (ITextComponent)new StringTextComponent(label).func_240699_a_(TextFormatting.BOLD).func_240699_a_(TextFormatting.WHITE), onPress -> {
                IFormattableTextComponent newTitle = CustomConfigScreen.this.field_230704_d_.func_230531_f_().func_240702_b_(" > " + label);
                CustomConfigScreen.this.field_230706_i_.func_147108_a((Screen)new CustomConfigScreen((Screen)CustomConfigScreen.this, (ITextComponent)newTitle, CustomConfigScreen.this.config, CustomConfigScreen.this.background, folderEntry));
            });
            this.icon = CustomConfigScreen.this.getIcon(label.toLowerCase(Locale.ROOT));
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return ImmutableList.of((Object)this.button);
        }

        public void func_230432_a_(MatrixStack matrixStack, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            if (this.lastTick < CustomConfigScreen.this.ticks) {
                this.ticks = Math.max(0, this.ticks + (selected ? 1 : -2)) % 36;
            }
            this.lastTick = CustomConfigScreen.this.ticks;
            this.button.field_230690_l_ = left - 1;
            this.button.field_230691_m_ = top;
            this.button.func_230991_b_(width);
            this.button.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            int center = this.button.field_230690_l_ + width / 2;
            ItemRenderer renderer = CustomConfigScreen.this.field_230707_j_;
            float p = (float)Math.PI / 180;
            RendererUtil.renderGuiItemRelative(this.icon, center + 90 - 17, top + 2, renderer, (s, r) -> {
                if (this.ticks != 0) {
                    if (r.booleanValue()) {
                        s.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(((float)this.ticks + partialTicks) * p * 10.0f));
                    } else {
                        float scale = 1.0f + 0.1f * MathHelper.func_76126_a((float)(((float)this.ticks + partialTicks) * p * 20.0f));
                        s.func_227862_a_(scale, scale, scale);
                    }
                }
            });
            RendererUtil.renderGuiItemRelative(this.icon, center - 90, top + 2, renderer, (s, r) -> {
                if (this.ticks != 0) {
                    if (r.booleanValue()) {
                        s.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(((float)this.ticks + partialTicks) * p * 10.0f));
                    } else {
                        float scale = 1.0f + 0.1f * MathHelper.func_76126_a((float)(((float)this.ticks + partialTicks) * p * 20.0f));
                        s.func_227862_a_(scale, scale, scale);
                    }
                }
            });
        }
    }
}

