/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.compat.configured;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.configured.client.screen.ConfigScreen;
import com.mrcrayfish.configured.client.screen.ListMenuScreen;
import com.mrcrayfish.configured.client.screen.ModConfigSelectionScreen;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import com.mrcrayfish.configured.client.util.ScreenUtil;
import com.mrcrayfish.configured.util.ConfigHelper;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.mehvahdjukaar.supplementaries.common.Textures;
import net.mehvahdjukaar.supplementaries.compat.configured.CustomConfigScreen;
import net.mehvahdjukaar.supplementaries.configs.ConfigHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ModConfig;

public class CustomConfigSelectScreen
extends ModConfigSelectionScreen {
    public static final ResourceLocation ICONS_TEXTURES = Textures.MISC_ICONS_TEXTURE;
    private static final Field FILE_ITEM_BUTTON;

    public CustomConfigSelectScreen(Screen parent, String displayName, ResourceLocation background, Map<ModConfig.Type, Set<ModConfig>> configMap) {
        super(parent, displayName, background, configMap);
    }

    public static void registerScreen() {
        ModContainer container = (ModContainer)ModList.get().getModContainerById("supplementaries").get();
        Map<ModConfig.Type, Set<ModConfig>> modConfigMap = CustomConfigSelectScreen.createConfigMap();
        container.registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> (mc, screen) -> new CustomConfigSelectScreen((Screen)screen, "\u00a76Supplementaries Configured", Textures.CONFIG_BACKGROUND, modConfigMap));
    }

    private static Map<ModConfig.Type, Set<ModConfig>> createConfigMap() {
        HashMap<ModConfig.Type, Set<ModConfig>> modConfigMap = new HashMap<ModConfig.Type, Set<ModConfig>>();
        HashSet<ModConfig> s = new HashSet<ModConfig>();
        s.add(ConfigHandler.CLIENT_CONFIG_OBJECT);
        modConfigMap.put(ModConfig.Type.CLIENT, s);
        HashSet<ModConfig> s1 = new HashSet<ModConfig>();
        s1.add(ConfigHandler.REGISTRY_CONFIG_OBJECT);
        s1.add(ConfigHandler.SERVER_CONFIG_OBJECT);
        modConfigMap.put(ModConfig.Type.COMMON, s1);
        return modConfigMap;
    }

    protected void constructEntries(List<ListMenuScreen.Item> entries) {
        super.constructEntries(entries);
        for (ListMenuScreen.Item i : entries) {
            if (!(i instanceof ModConfigSelectionScreen.FileItem)) continue;
            ModConfigSelectionScreen.FileItem item2 = (ModConfigSelectionScreen.FileItem)i;
            try {
                FILE_ITEM_BUTTON.setAccessible(true);
                FILE_ITEM_BUTTON.set(i, this.createModifyButton(this.getConfigFromLabel(item2.getLabel())));
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
    }

    private ModConfig getConfigFromLabel(String label) {
        if (label.contains("Common")) {
            return ConfigHandler.SERVER_CONFIG_OBJECT;
        }
        if (label.contains("Client")) {
            return ConfigHandler.CLIENT_CONFIG_OBJECT;
        }
        return ConfigHandler.REGISTRY_CONFIG_OBJECT;
    }

    private Button createModifyButton(ModConfig config) {
        String langKey = "configured.gui.modify";
        return new IconButton(0, 0, 33, 0, 60, (ITextComponent)new TranslationTextComponent(langKey), onPress -> Minecraft.func_71410_x().func_147108_a((Screen)new CustomConfigScreen((Screen)this, (ITextComponent)new StringTextComponent("\u00a76Supplementaries Configured"), config, this.background)), (button, matrixStack, mouseX, mouseY) -> {
            if (button.func_230449_g_() && ConfigScreen.isPlayingGame() && !ConfigHelper.isConfiguredInstalledOnServer()) {
                this.func_238654_b_(matrixStack, this.field_230712_o_.func_238425_b_((ITextProperties)new TranslationTextComponent("configured.gui.not_installed"), Math.max(this.field_230708_k_ / 2 - 43, 170)), mouseX, mouseY);
            }
        });
    }

    public void func_230430_a_(MatrixStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
        if (ScreenUtil.isMouseWithin((int)(this.field_230708_k_ / 2 - 90), (int)2, (int)180, (int)16, (int)mouseX, (int)mouseY)) {
            this.func_238654_b_(poseStack, this.field_230712_o_.func_238425_b_((ITextProperties)new TranslationTextComponent("supplementaries.gui.info"), 200), mouseX, mouseY);
        }
        int titleWidth = this.field_230712_o_.func_238414_a_((ITextProperties)this.field_230704_d_) + 35;
        this.field_230707_j_.func_239390_c_(CustomConfigScreen.MAIN_ICON, this.field_230708_k_ / 2 + titleWidth / 2 - 17, 2);
        this.field_230707_j_.func_239390_c_(CustomConfigScreen.MAIN_ICON, this.field_230708_k_ / 2 - titleWidth / 2, 2);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (ScreenUtil.isMouseWithin((int)(this.field_230708_k_ / 2 - 90), (int)2, (int)180, (int)16, (int)((int)mouseX), (int)((int)mouseY))) {
            Style style = Style.field_240709_b_.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/supplementaries"));
            this.func_230455_a_(style);
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        Button found = null;
        for (IGuiEventListener c : this.func_231039_at__()) {
            Button button2;
            if (!(c instanceof Button) || (button2 = (Button)c).func_230998_h_() != 150) continue;
            found = button2;
        }
        if (found != null) {
            this.field_230705_e_.remove(found);
            this.field_230710_m_.remove(found);
        }
        int y = this.field_230709_l_ - 29;
        int centerX = this.field_230708_k_ / 2;
        this.func_230480_a_((Widget)new Button(centerX - 45, y, 90, 20, DialogTexts.field_240637_h_, button -> this.field_230706_i_.func_147108_a(this.parent)));
        ButtonIcon patreon = ButtonIcon.linkButton((Screen)this, centerX - 45 - 22, y, 3, 1, "https://www.patreon.com/user?u=53696377", "Support me on Patreon :D");
        ButtonIcon kofi = ButtonIcon.linkButton((Screen)this, centerX - 45 - 44, y, 2, 2, "https://ko-fi.com/mehvahdjukaar", "Donate a Coffe");
        ButtonIcon curseforge = ButtonIcon.linkButton((Screen)this, centerX - 45 - 66, y, 1, 2, "https://www.curseforge.com/minecraft/mc-mods/supplementaries", "CurseForge Page");
        ButtonIcon github = ButtonIcon.linkButton((Screen)this, centerX - 45 - 88, y, 0, 2, "https://github.com/MehVahdJukaar/Supplementaries/wiki", "Mod Wiki");
        ButtonIcon discord = ButtonIcon.linkButton((Screen)this, centerX + 45 + 2, y, 1, 1, "https://discord.com/invite/qdKRTDf8Cv", "Mod Discord");
        ButtonIcon youtube = ButtonIcon.linkButton((Screen)this, centerX + 45 + 2 + 22, y, 0, 1, "https://www.youtube.com/watch?v=LSPNAtAEn28&t=1s", "Youtube Channel");
        ButtonIcon twitter = ButtonIcon.linkButton((Screen)this, centerX + 45 + 2 + 44, y, 2, 1, "https://twitter.com/Supplementariez?s=09", "Twitter Page");
        ButtonIcon akliz = ButtonIcon.linkButton((Screen)this, centerX + 45 + 2 + 66, y, 3, 2, "https://www.akliz.net/supplementaries", "Need a server? Get one with Akliz");
        this.func_230480_a_((Widget)kofi);
        this.func_230480_a_((Widget)akliz);
        this.func_230480_a_((Widget)patreon);
        this.func_230480_a_((Widget)curseforge);
        this.func_230480_a_((Widget)discord);
        this.func_230480_a_((Widget)youtube);
        this.func_230480_a_((Widget)github);
        this.func_230480_a_((Widget)twitter);
    }

    static {
        Field temp = null;
        try {
            temp = ObfuscationReflectionHelper.findField(ModConfigSelectionScreen.FileItem.class, (String)"modifyButton");
        }
        catch (Exception exception) {
        }
        finally {
            FILE_ITEM_BUTTON = temp;
        }
    }

    public static class ButtonIcon
    extends Button {
        private static final int ICON_WIDTH = 14;
        private final ITextComponent label;
        private final int u;
        private final int v;

        public static ButtonIcon linkButton(Screen parent, int x, int y, int uInd, int vInd, String url, String tooltip) {
            Button.IPressable onPress = op -> {
                Style style = Style.field_240709_b_.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
                parent.func_230455_a_(style);
            };
            Button.ITooltip onTooltip = (button, poseStack, mouseX, mouseY) -> {
                if (button.func_230449_g_()) {
                    parent.func_238654_b_(poseStack, parent.getMinecraft().field_71466_p.func_238425_b_((ITextProperties)new StringTextComponent(tooltip), Math.max(parent.field_230708_k_ / 2 - 43, 170)), mouseX, mouseY);
                }
            };
            return new ButtonIcon(x, y, uInd * 14, vInd * 14, 20, StringTextComponent.field_240750_d_, onPress, onTooltip);
        }

        public ButtonIcon(int x, int y, int u, int v, int width, ITextComponent label, Button.IPressable onPress, Button.ITooltip onTooltip) {
            super(x, y, width, 20, StringTextComponent.field_240750_d_, onPress, onTooltip);
            this.label = label;
            this.u = u;
            this.v = v;
        }

        public void func_230431_b_(MatrixStack poseStack, int mouseX, int mouseY, float partialTicks) {
            super.func_230431_b_(poseStack, mouseX, mouseY, partialTicks);
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_110434_K().func_110577_a(ICONS_TEXTURES);
            RenderSystem.enableDepthTest();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            int contentWidth = 14 + mc.field_71466_p.func_238414_a_((ITextProperties)this.label);
            int iconX = (int)((double)this.field_230690_l_ + Math.ceil((float)(this.field_230688_j_ - contentWidth) / 2.0f));
            int iconY = (int)((double)this.field_230691_m_ + Math.ceil((float)(this.field_230688_j_ - 14) / 2.0f));
            float brightness = this.field_230693_o_ ? 1.0f : 0.5f;
            RenderSystem.color4f((float)brightness, (float)brightness, (float)brightness, (float)this.field_230695_q_);
            ButtonIcon.func_238464_a_((MatrixStack)poseStack, (int)iconX, (int)iconY, (int)this.func_230927_p_(), (float)this.u, (float)this.v, (int)14, (int)14, (int)64, (int)64);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_230695_q_);
            int textColor = this.getFGColor() | MathHelper.func_76123_f((float)(this.field_230695_q_ * 255.0f)) << 24;
            ButtonIcon.func_238475_b_((MatrixStack)poseStack, (FontRenderer)mc.field_71466_p, (ITextComponent)this.label, (int)(iconX + 14), (int)(iconY + 1), (int)textColor);
        }
    }
}

