/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.lang.reflect.Method;
import java.util.Optional;
import net.mehvahdjukaar.supplementaries.block.util.BlockUtils;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class WrenchItem
extends Item {
    private final float attackDamage;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;
    private static Method SET_DIRECTION = null;

    public WrenchItem(Item.Properties pProperties) {
        super(pProperties);
        this.attackDamage = 2.5f;
        float pAttackSpeedModifier = -2.0f;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)pAttackSpeedModifier, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public float getDamage() {
        return this.attackDamage;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || ImmutableSet.of((Object)Enchantments.field_180313_o).contains((Object)enchantment);
    }

    public boolean func_82789_a(ItemStack pStack, ItemStack pRepairCandidate) {
        return pRepairCandidate.func_77973_b() == Items.field_151042_j;
    }

    public boolean func_77644_a(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        pAttacker.field_70170_p.func_217384_a(null, (Entity)pTarget, SoundEvents.field_187692_g, SoundCategory.NEUTRAL, 0.5f, 1.8f);
        pStack.func_222118_a(1, pAttacker, entity2 -> entity2.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType pEquipmentSlot) {
        return pEquipmentSlot == EquipmentSlotType.MAINHAND ? this.defaultModifiers : super.func_111205_h(pEquipmentSlot);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player != null) {
            boolean shiftDown;
            World level = context.func_195991_k();
            BlockPos pos = context.func_195995_a();
            ItemStack itemstack = context.func_195996_i();
            Direction dir = context.func_196000_l();
            Optional<Direction> success = BlockUtils.tryRotatingBlockAndConnected(dir, shiftDown = player.func_225608_bj_(), pos, level, context.func_221532_j());
            if (success.isPresent()) {
                dir = success.get();
                if (player instanceof ServerPlayerEntity) {
                    CriteriaTriggers.field_232607_M_.func_226695_a_((ServerPlayerEntity)player, pos, itemstack);
                } else {
                    this.playTurningEffects(pos, shiftDown, dir, level, player);
                }
                itemstack.func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(context.func_221531_n()));
                return ActionResultType.func_233537_a_((boolean)level.field_72995_K);
            }
            if (level.field_72995_K) {
                // empty if block
            }
        }
        return ActionResultType.FAIL;
    }

    private void playTurningEffects(BlockPos pos, boolean shiftDown, Direction dir, World level, PlayerEntity player) {
        if (dir == Direction.DOWN) {
            shiftDown = !shiftDown;
        }
        level.func_195594_a((IParticleData)ModRegistry.ROTATION_TRAIL_EMITTER.get(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (double)dir.func_176745_a(), 0.71, shiftDown ? 1.0 : -1.0);
        level.func_184133_a(player, pos, SoundEvents.field_187632_cP, SoundCategory.BLOCKS, 1.0f, 0.6f);
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity entity2, Hand pUsedHand) {
        if (entity2 instanceof ArmorStandEntity || entity2.func_200600_R().getRegistryName().func_110624_b().equals("dummmmmmy")) {
            boolean shiftDown = player.func_225608_bj_();
            float inc = 22.5f * (float)(shiftDown ? -1 : 1);
            entity2.field_70177_z += inc;
            if (player.field_70170_p.field_72995_K) {
                this.playTurningEffects(entity2.func_233580_cy_().func_177984_a(), shiftDown, Direction.UP, player.field_70170_p, player);
            }
            stack.func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(pUsedHand));
            return ActionResultType.func_233537_a_((boolean)player.field_70170_p.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity2) {
        boolean shiftDown = player.func_225608_bj_();
        if (entity2 instanceof HangingEntity) {
            HangingEntity hangingEntity = (HangingEntity)entity2;
            if (hangingEntity.func_174811_aO().func_176740_k().func_176722_c()) {
                Direction dir = hangingEntity.func_174811_aO();
                dir = shiftDown ? dir.func_176735_f() : dir.func_176746_e();
                try {
                    if (SET_DIRECTION == null) {
                        SET_DIRECTION = ObfuscationReflectionHelper.findMethod(HangingEntity.class, (String)"setDirection", (Class[])new Class[]{Direction.class});
                    }
                    SET_DIRECTION.setAccessible(true);
                    SET_DIRECTION.invoke((Object)hangingEntity, dir);
                    if (player.field_70170_p.field_72995_K) {
                        this.playTurningEffects(hangingEntity.func_174857_n(), shiftDown, Direction.UP, player.field_70170_p, player);
                    }
                    stack.func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(player.func_184600_cs()));
                    return true;
                }
                catch (Exception exception) {}
            }
        } else if (entity2 instanceof ArmorStandEntity) {
            this.func_111207_a(stack, player, (LivingEntity)entity2, Hand.MAIN_HAND);
            return true;
        }
        return super.onLeftClickEntity(stack, player, entity2);
    }
}

