/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.mixins;

import java.lang.reflect.Method;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.block.util.ICustomDataHolder;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.SkeletonHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SkeletonHorseEntity.class})
public abstract class SkeletonHorseMixin
extends AbstractHorseEntity
implements ICustomDataHolder {
    private int fleshCount = 0;
    private int conversionTime = -1;

    @Override
    public boolean getVariable() {
        return this.isConverting();
    }

    @Override
    public void setVariable(boolean val) {
    }

    protected SkeletonHorseMixin(EntityType<? extends AbstractHorseEntity> p_i48563_1_, World p_i48563_2_) {
        super(p_i48563_1_, p_i48563_2_);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    public void addAdditionalSaveData(CompoundNBT compoundNBT, CallbackInfo ci) {
        compoundNBT.func_74768_a("FleshCount", this.fleshCount);
        compoundNBT.func_74768_a("ConversionTile", this.conversionTime);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void readAdditionalSaveData(CompoundNBT compoundNBT, CallbackInfo ci) {
        this.fleshCount = compoundNBT.func_74762_e("FleshCount");
        this.conversionTime = compoundNBT.func_74762_e("ConversionTile");
    }

    @Inject(method={"mobInteract"}, at={@At(value="HEAD")}, cancellable=true)
    public void mobInteract(PlayerEntity player, Hand hand, CallbackInfoReturnable<ActionResultType> cir) {
        ItemStack stack;
        if (ServerConfigs.cached.ZOMBIE_HORSE && this.func_110248_bS() && !this.func_70631_g_() && (stack = player.func_184586_b(hand)).func_77973_b() == Items.field_151078_bh && this.fleshCount < ServerConfigs.cached.ZOMBIE_HORSE_COST) {
            this.feedRottenFlesh(player, hand, stack);
            cir.setReturnValue((Object)ActionResultType.func_233537_a_((boolean)player.field_70170_p.field_72995_K));
        }
    }

    @Nullable
    protected SoundEvent func_230274_fe_() {
        return SoundEvents.field_187711_cp;
    }

    public void setEating() {
        try {
            Method m = ObfuscationReflectionHelper.findMethod(AbstractHorseEntity.class, (String)"func_110266_cB", (Class[])new Class[0]);
            m.setAccessible(true);
            m.invoke((Object)this, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void feedRottenFlesh(PlayerEntity player, Hand hand, ItemStack stack) {
        float heal = 0.5f;
        if (this.func_110143_aJ() < this.func_110138_aP()) {
            this.func_70691_i(heal);
        }
        this.setEating();
        ++this.fleshCount;
        if (this.fleshCount >= ServerConfigs.cached.ZOMBIE_HORSE_COST) {
            this.conversionTime = 200;
            this.field_70170_p.func_72960_a((Entity)this, (byte)16);
        }
        if (!player.func_184812_l_()) {
            stack.func_190918_g(1);
        }
    }

    private boolean isConverting() {
        return this.conversionTime > 0;
    }

    private void doZombieConversion() {
        float yBodyRot = this.field_70761_aq;
        float yHeadRot = this.field_70759_as;
        float yHeadRotO = this.field_70758_at;
        AbstractHorseEntity newHorse = (AbstractHorseEntity)this.func_233656_b_(EntityType.field_200726_aE, true);
        if (newHorse != null) {
            newHorse.field_70761_aq = yBodyRot;
            newHorse.field_70759_as = yHeadRot;
            newHorse.field_70758_at = yHeadRotO;
            newHorse.func_184779_b(this.func_184780_dh());
            newHorse.func_110234_j(this.func_110248_bS());
            newHorse.func_195064_c(new EffectInstance(Effects.field_76431_k, 200, 0));
            if (this.func_110257_ck()) {
                newHorse.func_230266_a_(null);
            }
            for (EquipmentSlotType equipmentslottype : EquipmentSlotType.values()) {
                ItemStack itemstack = this.func_184582_a(equipmentslottype);
                if (itemstack.func_190926_b()) continue;
                if (EnchantmentHelper.func_190938_b((ItemStack)itemstack)) {
                    newHorse.func_174820_d(equipmentslottype.func_188454_b() + 300, itemstack);
                    continue;
                }
                double d0 = this.func_205712_c(equipmentslottype);
                if (!(d0 > 1.0)) continue;
                this.func_199701_a_(itemstack);
            }
            ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)newHorse);
        }
        if (!this.func_174814_R()) {
            this.field_70170_p.func_217378_a(null, 1027, this.func_233580_cy_(), 0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte p_70103_1_) {
        if (p_70103_1_ == 16) {
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_(), SoundEvents.field_187942_hp, this.func_184176_by(), 1.0f + this.field_70146_Z.nextFloat(), this.field_70146_Z.nextFloat() * 0.7f + 0.3f, false);
            }
        } else {
            super.func_70103_a(p_70103_1_);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && !this.func_175446_cd() && this.isConverting()) {
            --this.conversionTime;
            if (this.conversionTime == 0) {
                this.doZombieConversion();
            }
        }
    }
}

