/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.world.data.map.markers;

import java.util.Objects;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.map.markers.NamedMapWorldMarker;
import net.mehvahdjukaar.supplementaries.block.tiles.FlagBlockTile;
import net.mehvahdjukaar.supplementaries.world.data.map.CMDreg;
import net.mehvahdjukaar.supplementaries.world.data.map.FlagDecoration;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;

public class FlagMarker
extends NamedMapWorldMarker<FlagDecoration> {
    private DyeColor color;

    public FlagMarker() {
        super(CMDreg.FLAG_DECORATION_TYPE);
    }

    public FlagMarker(BlockPos pos, DyeColor color, @Nullable ITextComponent name) {
        this();
        this.pos = pos;
        this.color = color;
        this.name = name;
    }

    public CompoundNBT saveToNBT(CompoundNBT compoundnbt) {
        super.saveToNBT(compoundnbt);
        compoundnbt.func_74778_a("Color", this.color.func_176762_d());
        return compoundnbt;
    }

    public void loadFromNBT(CompoundNBT compound) {
        super.loadFromNBT(compound);
        this.color = DyeColor.func_204271_a((String)compound.func_74779_i("Color"), (DyeColor)DyeColor.WHITE);
    }

    @Nullable
    public static FlagMarker getFromWorld(IBlockReader world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof FlagBlockTile) {
            FlagBlockTile flag = (FlagBlockTile)tileentity;
            DyeColor dyecolor = flag.getBaseColor(() -> ((FlagBlockTile)flag).func_195044_w());
            ITextComponent name = flag.func_145818_k_() ? flag.func_200201_e() : null;
            return new FlagMarker(pos, dyecolor, name);
        }
        return null;
    }

    @Nullable
    public FlagDecoration doCreateDecoration(byte mapX, byte mapY, byte rot) {
        return new FlagDecoration(this.getType(), mapX, mapY, rot, this.name, this.color);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other != null && ((Object)((Object)this)).getClass() == other.getClass()) {
            FlagMarker marker = (FlagMarker)((Object)other);
            return Objects.equals(this.getPos(), marker.getPos()) && this.color == marker.color;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getPos(), this.color);
    }
}

