/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.additionallanterns;

import com.supermartijn642.additionallanterns.AdditionalLanterns;
import com.supermartijn642.additionallanterns.ChainBlock;
import com.supermartijn642.additionallanterns.LanternBlock;
import com.supermartijn642.additionallanterns.LanternColor;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public enum LanternMaterial {
    NORMAL(true, false, "", null, null, null, null, 0),
    OBSIDIAN(true, true, "Obsidian", () -> Items.field_221655_bP, null, () -> Items.field_221655_bP, () -> Items.field_221655_bP, 8),
    BASALT(true, true, "Basalt", () -> Items.field_234735_dn_, null, () -> Items.field_234735_dn_, () -> Items.field_234735_dn_, 8),
    ANDESITE(true, true, "Andesite", () -> Items.field_221579_g, null, () -> Items.field_221579_g, () -> Items.field_221579_g, 8),
    DIORITE(true, true, "Diorite", () -> Items.field_221577_e, null, () -> Items.field_221577_e, () -> Items.field_221577_e, 8),
    GRANITE(true, true, "Granite", () -> Items.field_221575_c, null, () -> Items.field_221575_c, () -> Items.field_221575_c, 8),
    NORMAL_SANDSTONE(true, true, "Sandstone", () -> Items.field_221658_aq, null, () -> Items.field_221658_aq, () -> Items.field_221658_aq, 8),
    RED_SANDSTONE(true, true, "Red Sandstone", () -> Items.field_221946_ge, null, () -> Items.field_221946_ge, () -> Items.field_221946_ge, 8),
    SMOOTH_STONE(true, true, "Smooth Stone", () -> Items.field_221645_bK, null, () -> Items.field_221645_bK, () -> Items.field_221645_bK, 8),
    END_STONE(true, true, "End Stone", () -> Items.field_221828_dx, null, () -> Items.field_221828_dx, () -> Items.field_221828_dx, 8),
    QUARTZ(true, true, "Quartz", () -> Items.field_151128_bU, () -> Items.field_151128_bU, () -> Items.field_221866_eq, () -> Items.field_151128_bU, 4),
    PRISMARINE(true, true, "Prismarine", () -> Items.field_179562_cC, () -> Items.field_179562_cC, () -> Items.field_221881_fY, () -> Items.field_179562_cC, 6),
    DARK_PRISMARINE(true, true, "Dark Prismarine", () -> Items.field_221883_fZ, null, () -> Items.field_221883_fZ, () -> Items.field_179562_cC, 6),
    BLACKSTONE(true, true, "Blackstone", () -> Items.field_234777_rA_, null, () -> Items.field_234777_rA_, () -> Items.field_234777_rA_, 4),
    NORMAL_NETHER_BRICKS(true, true, "Nether Brick", () -> Items.field_196154_dH, null, () -> Items.field_221818_ds, () -> Items.field_196154_dH, 4),
    RED_NETHER_BRICKS(true, true, "Red Nether Brick", () -> Items.field_221962_gm, null, () -> Items.field_221962_gm, () -> Items.field_196154_dH, 4),
    CRIMSON(true, true, "Crimson", () -> Items.field_234798_v_, null, () -> Items.field_234798_v_, () -> Items.field_234798_v_, 6),
    WARPED(true, true, "Warped", () -> Items.field_234799_w_, null, () -> Items.field_234799_w_, () -> Items.field_234799_w_, 6),
    PURPUR(true, true, "Purpur", () -> Items.field_185162_cT, () -> Items.field_185162_cT, () -> Items.field_221665_bU, () -> Items.field_185162_cT, 4),
    BRICKS(true, true, "Brick", () -> Items.field_151118_aC, () -> Items.field_151118_aC, () -> Items.field_221647_bL, () -> Items.field_151118_aC, 4);

    public final boolean canBeColored;
    public final boolean hasChains;
    private LanternBlock lanternBlock;
    private final Map<LanternColor, LanternBlock> coloredLanternBlocks = new EnumMap<LanternColor, LanternBlock>(LanternColor.class);
    private ChainBlock chainBlock;
    private Item lanternItem;
    private final Map<LanternColor, Item> coloredLanternItems = new EnumMap<LanternColor, Item>(LanternColor.class);
    private Item chainItem;
    public final String englishTranslation;
    public final IItemProvider primaryLanternIngredient;
    public final IItemProvider secondaryLanternIngredient;
    public final IItemProvider primaryChainIngredient;
    public final IItemProvider secondaryChainIngredient;
    public final int chainRecipeCount;

    private LanternMaterial(boolean canBeColored, boolean hasChains, String englishTranslation, IItemProvider primaryLanternIngredient, IItemProvider secondaryLanternIngredient, IItemProvider primaryChainIngredient, IItemProvider secondaryChainIngredient, int chainRecipeCount) {
        this.canBeColored = canBeColored;
        this.hasChains = hasChains;
        this.englishTranslation = englishTranslation;
        this.primaryLanternIngredient = primaryLanternIngredient;
        this.secondaryLanternIngredient = secondaryLanternIngredient;
        this.primaryChainIngredient = primaryChainIngredient;
        this.secondaryChainIngredient = secondaryChainIngredient;
        this.chainRecipeCount = chainRecipeCount;
    }

    public Block getLanternBlock() {
        return this.lanternBlock;
    }

    public Block getLanternBlock(LanternColor color) {
        if (color == null) {
            return this.getLanternBlock();
        }
        return (Block)this.coloredLanternBlocks.get((Object)color);
    }

    public ChainBlock getChainBlock() {
        return this.chainBlock;
    }

    public String getSuffix() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public AbstractBlock.Properties getLanternBlockProperties() {
        return AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_222432_lU).func_235838_a_(state -> LanternBlock.emitsLight(state) ? 15 : 0);
    }

    public AbstractBlock.Properties getChainBlockProperties() {
        return AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_235341_dI_);
    }

    public void registerBlocks(IForgeRegistry<Block> registry) {
        if (this.lanternBlock != null) {
            throw new IllegalStateException("Blocks have already been registered!");
        }
        this.lanternBlock = new LanternBlock(this, null);
        if (this.canBeColored) {
            for (LanternColor color : LanternColor.values()) {
                this.coloredLanternBlocks.put(color, new LanternBlock(this, color));
            }
        }
        registry.register((IForgeRegistryEntry)this.lanternBlock);
        this.coloredLanternBlocks.values().forEach(arg_0 -> registry.register(arg_0));
        if (this.hasChains) {
            this.chainBlock = new ChainBlock(this);
            registry.register((IForgeRegistryEntry)this.chainBlock);
        }
    }

    public void registerItems(IForgeRegistry<Item> registry) {
        if (this.lanternItem != null) {
            throw new IllegalStateException("Items have already been registered!");
        }
        if (this.lanternBlock == null) {
            throw new IllegalStateException("Blocks must be registered before registering items!");
        }
        this.lanternItem = this == NORMAL ? (Item)new BlockItem((Block)this.lanternBlock, new Item.Properties().func_200916_a(AdditionalLanterns.GROUP)).setRegistryName(new ResourceLocation("minecraft", "lantern")) : (Item)new BlockItem((Block)this.lanternBlock, new Item.Properties().func_200916_a(AdditionalLanterns.GROUP)).setRegistryName(this.lanternBlock.getRegistryName());
        if (this.canBeColored) {
            for (LanternColor color : LanternColor.values()) {
                LanternBlock block = this.coloredLanternBlocks.get((Object)color);
                this.coloredLanternItems.put(color, (Item)new BlockItem((Block)block, new Item.Properties().func_200916_a(AdditionalLanterns.GROUP)).setRegistryName(block.getRegistryName()));
            }
        }
        registry.register((IForgeRegistryEntry)this.lanternItem);
        this.coloredLanternItems.values().forEach(arg_0 -> registry.register(arg_0));
        if (this.hasChains) {
            this.chainItem = (Item)new BlockItem((Block)this.chainBlock, new Item.Properties().func_200916_a(AdditionalLanterns.GROUP)).setRegistryName(this.chainBlock.getRegistryName());
            registry.register((IForgeRegistryEntry)this.chainItem);
        }
    }
}

