/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.additionallanterns.data;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.supermartijn642.additionallanterns.LanternColor;
import com.supermartijn642.additionallanterns.LanternMaterial;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.item.Items;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class LanternLootTableProvider
extends LootTableProvider {
    public LanternLootTableProvider(GatherDataEvent e) {
        super(e.getGenerator());
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        BlockLootTables lootTables = new BlockLootTables(){

            protected Iterable<Block> getKnownBlocks() {
                return ForgeRegistries.BLOCKS.getValues().stream().filter(block -> block.getRegistryName().func_110624_b().equals("additionallanterns")).collect(Collectors.toList());
            }

            protected void addTables() {
                for (LanternMaterial material : LanternMaterial.values()) {
                    if (material == LanternMaterial.NORMAL) {
                        this.func_218493_a(material.getLanternBlock(), () -> Items.field_222111_pQ);
                    } else {
                        this.func_218492_c(material.getLanternBlock());
                    }
                    if (material.canBeColored) {
                        for (LanternColor color : LanternColor.values()) {
                            this.func_218492_c(material.getLanternBlock(color));
                        }
                    }
                    if (!material.hasChains) continue;
                    this.func_218492_c((Block)material.getChainBlock());
                }
            }
        };
        return ImmutableList.of((Object)Pair.of(() -> lootTables, (Object)LootParameterSets.field_216267_h));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationtracker) {
        map.forEach((a, b) -> LootTableManager.func_227508_a_((ValidationTracker)validationtracker, (ResourceLocation)a, (LootTable)b));
    }
}

