/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei.category;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedItemDrain;
import com.simibubi.create.content.contraptions.fluids.potion.PotionFluidHandler;
import com.simibubi.create.content.contraptions.processing.EmptyingRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.PotionItem;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class ItemDrainCategory
extends CreateRecipeCategory<EmptyingRecipe> {
    AnimatedItemDrain drain = new AnimatedItemDrain();

    public ItemDrainCategory() {
        super(ItemDrainCategory.doubleItemIcon((IItemProvider)AllBlocks.ITEM_DRAIN.get(), (IItemProvider)Items.field_151131_as), ItemDrainCategory.emptyBackground(177, 50));
    }

    public static List<EmptyingRecipe> getRecipes(IIngredientManager ingredientManager) {
        ArrayList<EmptyingRecipe> recipes = new ArrayList<EmptyingRecipe>();
        ingredientManager.getAllIngredients(VanillaTypes.ITEM).stream().forEach(stack -> {
            if (stack.func_77973_b() instanceof PotionItem) {
                FluidStack fluidFromPotionItem = PotionFluidHandler.getFluidFromPotionItem(stack);
                Ingredient potion = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack});
                recipes.add(new ProcessingRecipeBuilder<EmptyingRecipe>(EmptyingRecipe::new, Create.asResource("potions")).withItemIngredients(potion).withFluidOutputs(fluidFromPotionItem).withSingleItemOutput(new ItemStack((IItemProvider)Items.field_151069_bo)).build());
                return;
            }
            LazyOptional capability = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
            if (!capability.isPresent()) {
                return;
            }
            ItemStack copy = stack.func_77946_l();
            capability = copy.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
            IFluidHandlerItem handler = (IFluidHandlerItem)capability.orElse(null);
            FluidStack extracted = handler.drain(1000, IFluidHandler.FluidAction.EXECUTE);
            ItemStack result = handler.getContainer();
            if (extracted.isEmpty()) {
                return;
            }
            if (result.func_190926_b()) {
                return;
            }
            Ingredient ingredient = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack});
            ResourceLocation itemName = stack.func_77973_b().getRegistryName();
            ResourceLocation fluidName = extracted.getFluid().getRegistryName();
            recipes.add(new ProcessingRecipeBuilder<EmptyingRecipe>(EmptyingRecipe::new, Create.asResource("empty_" + itemName.func_110624_b() + "_" + itemName.func_110623_a() + "_of_" + fluidName.func_110624_b() + "_" + fluidName.func_110623_a())).withItemIngredients(ingredient).withFluidOutputs(extracted).withSingleItemOutput(result).build());
        });
        return recipes;
    }

    public Class<? extends EmptyingRecipe> getRecipeClass() {
        return EmptyingRecipe.class;
    }

    public void setIngredients(EmptyingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.func_192400_c());
        if (!recipe.getRollableResults().isEmpty()) {
            ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
        }
        if (!recipe.getFluidResults().isEmpty()) {
            ingredients.setOutputs(VanillaTypes.FLUID, recipe.getFluidResults());
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, EmptyingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        FluidStack fluidOutput = recipe.getResultingFluid();
        List<ItemStack> matchingIngredients = Arrays.asList(((Ingredient)recipe.func_192400_c().get(0)).func_193365_a());
        fluidStacks.init(0, true, 132, 8);
        fluidStacks.set(0, ItemDrainCategory.withImprovedVisibility(fluidOutput));
        itemStacks.init(0, true, 26, 7);
        itemStacks.set(0, matchingIngredients);
        itemStacks.init(1, false, 131, 26);
        itemStacks.set(1, recipe.func_77571_b());
        ItemDrainCategory.addFluidTooltip(fluidStacks, Collections.emptyList(), (List<FluidStack>)ImmutableList.of((Object)fluidOutput));
    }

    public void draw(EmptyingRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        AllGuiTextures.JEI_SLOT.draw(matrixStack, 131, 7);
        AllGuiTextures.JEI_SLOT.draw(matrixStack, 26, 7);
        ItemDrainCategory.getRenderedSlot(recipe, 0).draw(matrixStack, 131, 26);
        AllGuiTextures.JEI_SHADOW.draw(matrixStack, 62, 37);
        AllGuiTextures.JEI_DOWN_ARROW.draw(matrixStack, 73, 4);
        this.drain.withFluid(recipe.getResultingFluid()).draw(matrixStack, this.getBackground().getWidth() / 2 - 13, 40);
    }
}

