/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.bearing;

import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.components.structureMovement.AssemblyException;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionLighter;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionType;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.AnchoredLighter;
import com.simibubi.create.foundation.config.AllConfigs;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;

public class BearingContraption
extends Contraption {
    protected int sailBlocks;
    protected Direction facing;
    private boolean isWindmill;

    public BearingContraption() {
    }

    public BearingContraption(boolean isWindmill, Direction facing) {
        this.isWindmill = isWindmill;
        this.facing = facing;
    }

    @Override
    public boolean assemble(World world, BlockPos pos) throws AssemblyException {
        BlockPos offset = pos.func_177972_a(this.facing);
        if (!this.searchMovedStructure(world, offset, null)) {
            return false;
        }
        this.startMoving(world);
        this.expandBoundsAroundAxis(this.facing.func_176740_k());
        if (this.isWindmill && this.sailBlocks < (Integer)AllConfigs.SERVER.kinetics.minimumWindmillSails.get()) {
            throw AssemblyException.notEnoughSails(this.sailBlocks);
        }
        return !this.blocks.isEmpty();
    }

    @Override
    protected ContraptionType getType() {
        return ContraptionType.BEARING;
    }

    @Override
    protected boolean isAnchoringBlockAt(BlockPos pos) {
        return pos.equals((Object)this.anchor.func_177972_a(this.facing.func_176734_d()));
    }

    @Override
    public void addBlock(BlockPos pos, Pair<Template.BlockInfo, TileEntity> capture) {
        BlockPos localPos = pos.func_177973_b((Vector3i)this.anchor);
        if (!this.getBlocks().containsKey(localPos) && AllTags.AllBlockTags.WINDMILL_SAILS.matches(((Template.BlockInfo)capture.getKey()).field_186243_b)) {
            ++this.sailBlocks;
        }
        super.addBlock(pos, capture);
    }

    @Override
    public CompoundNBT writeNBT(boolean spawnPacket) {
        CompoundNBT tag = super.writeNBT(spawnPacket);
        tag.func_74768_a("Sails", this.sailBlocks);
        tag.func_74768_a("Facing", this.facing.func_176745_a());
        return tag;
    }

    @Override
    public void readNBT(World world, CompoundNBT tag, boolean spawnData) {
        this.sailBlocks = tag.func_74762_e("Sails");
        this.facing = Direction.func_82600_a((int)tag.func_74762_e("Facing"));
        super.readNBT(world, tag, spawnData);
    }

    public int getSailBlocks() {
        return this.sailBlocks;
    }

    public Direction getFacing() {
        return this.facing;
    }

    @Override
    public boolean canBeStabilized(Direction facing, BlockPos localPos) {
        if (facing.func_176734_d() == this.facing && BlockPos.field_177992_a.equals((Object)localPos)) {
            return false;
        }
        return facing.func_176740_k() == this.facing.func_176740_k();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ContraptionLighter<?> makeLighter() {
        return new AnchoredLighter(this);
    }
}

