/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.gantry;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.components.structureMovement.AssemblyException;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionLighter;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionType;
import com.simibubi.create.content.contraptions.components.structureMovement.NonStationaryLighter;
import com.simibubi.create.content.contraptions.components.structureMovement.TranslatingContraption;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.Template;

public class GantryContraption
extends TranslatingContraption {
    protected Direction facing;

    public GantryContraption() {
    }

    public GantryContraption(Direction facing) {
        this.facing = facing;
    }

    @Override
    public boolean assemble(World world, BlockPos pos) throws AssemblyException {
        if (!this.searchMovedStructure(world, pos, null)) {
            return false;
        }
        this.startMoving(world);
        return true;
    }

    @Override
    public CompoundNBT writeNBT(boolean spawnPacket) {
        CompoundNBT tag = super.writeNBT(spawnPacket);
        tag.func_74768_a("Facing", this.facing.func_176745_a());
        return tag;
    }

    @Override
    public void readNBT(World world, CompoundNBT tag, boolean spawnData) {
        this.facing = Direction.func_82600_a((int)tag.func_74762_e("Facing"));
        super.readNBT(world, tag, spawnData);
    }

    @Override
    protected boolean isAnchoringBlockAt(BlockPos pos) {
        return super.isAnchoringBlockAt(pos.func_177972_a(this.facing));
    }

    @Override
    protected ContraptionType getType() {
        return ContraptionType.GANTRY;
    }

    public Direction getFacing() {
        return this.facing;
    }

    @Override
    protected boolean shouldUpdateAfterMovement(Template.BlockInfo info) {
        return super.shouldUpdateAfterMovement(info) && !AllBlocks.GANTRY_CARRIAGE.has(info.field_186243_b);
    }

    @Override
    public ContraptionLighter<?> makeLighter() {
        return new NonStationaryLighter<GantryContraption>(this);
    }
}

