/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.elementary;

import com.simibubi.create.AllShapes;
import com.simibubi.create.content.contraptions.base.DirectionalKineticBlock;
import com.simibubi.create.content.contraptions.base.HorizontalKineticBlock;
import com.simibubi.create.content.contraptions.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.contraptions.relays.elementary.CogWheelBlock;
import com.simibubi.create.content.contraptions.relays.elementary.ICogWheel;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.placement.IPlacementHelper;
import com.simibubi.create.foundation.utility.placement.PlacementHelpers;
import com.simibubi.create.foundation.utility.placement.PlacementOffset;
import java.util.List;
import java.util.function.Predicate;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class CogwheelBlockItem
extends BlockItem {
    boolean large;
    private final int placementHelperId;
    private final int integratedCogHelperId;

    public CogwheelBlockItem(CogWheelBlock block, Item.Properties builder) {
        super((Block)block, builder);
        this.large = block.isLarge;
        this.placementHelperId = PlacementHelpers.register(this.large ? new LargeCogHelper() : new SmallCogHelper());
        this.integratedCogHelperId = PlacementHelpers.register(this.large ? new IntegratedLargeCogHelper() : new IntegratedSmallCogHelper());
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState state = world.func_180495_p(pos);
        IPlacementHelper helper = PlacementHelpers.get(this.placementHelperId);
        PlayerEntity player = context.func_195999_j();
        BlockRayTraceResult ray = new BlockRayTraceResult(context.func_221532_j(), context.func_196000_l(), pos, true);
        if (helper.matchesState(state) && player != null && !player.func_225608_bj_()) {
            return helper.getOffset(player, world, state, pos, ray).placeInWorld(world, this, player, context.func_221531_n(), ray);
        }
        if (this.integratedCogHelperId != -1 && (helper = PlacementHelpers.get(this.integratedCogHelperId)).matchesState(state) && player != null && !player.func_225608_bj_()) {
            return helper.getOffset(player, world, state, pos, ray).placeInWorld(world, this, player, context.func_221531_n(), ray);
        }
        return super.onItemUseFirst(stack, context);
    }

    protected boolean func_195941_b(BlockItemUseContext context, BlockState state) {
        this.triggerShiftingGearsAdvancement(context.func_195991_k(), context.func_195995_a(), state, context.func_195999_j());
        return super.func_195941_b(context, state);
    }

    protected void triggerShiftingGearsAdvancement(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        if (world.field_72995_K || player == null) {
            return;
        }
        Direction.Axis axis = (Direction.Axis)state.func_177229_b((Property)CogWheelBlock.AXIS);
        for (Direction.Axis perpendicular1 : Iterate.axes) {
            if (perpendicular1 == axis) continue;
            Direction d1 = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)perpendicular1);
            for (Direction.Axis perpendicular2 : Iterate.axes) {
                if (perpendicular1 == perpendicular2 || axis == perpendicular2) continue;
                Direction d2 = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)perpendicular2);
                for (int offset1 : Iterate.positiveAndNegative) {
                    for (int offset2 : Iterate.positiveAndNegative) {
                        BlockPos connectedPos = pos.func_177967_a(d1, offset1).func_177967_a(d2, offset2);
                        BlockState blockState = world.func_180495_p(connectedPos);
                        if (!(blockState.func_177230_c() instanceof CogWheelBlock) || blockState.func_177229_b((Property)CogWheelBlock.AXIS) != axis || ICogWheel.isLargeCog(blockState) == this.large) continue;
                        AllTriggers.triggerFor(AllTriggers.SHIFTING_GEARS, player);
                    }
                }
            }
        }
    }

    @MethodsReturnNonnullByDefault
    public static class IntegratedSmallCogHelper
    implements IPlacementHelper {
        @Override
        public Predicate<ItemStack> getItemPredicate() {
            return ((Predicate<ItemStack>)ICogWheel::isSmallCogItem).and(ICogWheel::isDedicatedCogItem);
        }

        @Override
        public Predicate<BlockState> getStatePredicate() {
            return s -> !ICogWheel.isDedicatedCogWheel(s.func_177230_c()) && ICogWheel.isSmallCog(s);
        }

        @Override
        public PlacementOffset getOffset(PlayerEntity player, World world, BlockState state, BlockPos pos, BlockRayTraceResult ray) {
            Direction face = ray.func_216354_b();
            Direction.Axis newAxis = state.func_235901_b_(HorizontalKineticBlock.HORIZONTAL_FACING) ? ((Direction)state.func_177229_b(HorizontalKineticBlock.HORIZONTAL_FACING)).func_176740_k() : (state.func_235901_b_((Property)DirectionalKineticBlock.FACING) ? ((Direction)state.func_177229_b((Property)DirectionalKineticBlock.FACING)).func_176740_k() : Direction.Axis.Y);
            if (face.func_176740_k() == newAxis) {
                return PlacementOffset.fail();
            }
            List<Direction> directions = IPlacementHelper.orderedByDistanceExceptAxis(pos, ray.func_216347_e(), newAxis);
            for (Direction d : directions) {
                BlockPos newPos = pos.func_177972_a(d);
                if (!world.func_180495_p(newPos).func_185904_a().func_76222_j()) continue;
                if (!CogWheelBlock.isValidCogwheelPosition(false, (IWorldReader)world, newPos, newAxis)) {
                    return PlacementOffset.fail();
                }
                return PlacementOffset.success().at((Vector3i)newPos).withTransform(s -> (BlockState)s.func_206870_a((Property)CogWheelBlock.AXIS, (Comparable)newAxis));
            }
            return PlacementOffset.fail();
        }
    }

    @MethodsReturnNonnullByDefault
    public static class IntegratedLargeCogHelper
    implements IPlacementHelper {
        @Override
        public Predicate<ItemStack> getItemPredicate() {
            return ((Predicate<ItemStack>)ICogWheel::isLargeCogItem).and(ICogWheel::isDedicatedCogItem);
        }

        @Override
        public Predicate<BlockState> getStatePredicate() {
            return s -> !ICogWheel.isDedicatedCogWheel(s.func_177230_c()) && ICogWheel.isSmallCog(s);
        }

        @Override
        public PlacementOffset getOffset(PlayerEntity player, World world, BlockState state, BlockPos pos, BlockRayTraceResult ray) {
            Direction face = ray.func_216354_b();
            Direction.Axis newAxis = state.func_235901_b_(HorizontalKineticBlock.HORIZONTAL_FACING) ? ((Direction)state.func_177229_b(HorizontalKineticBlock.HORIZONTAL_FACING)).func_176740_k() : (state.func_235901_b_((Property)DirectionalKineticBlock.FACING) ? ((Direction)state.func_177229_b((Property)DirectionalKineticBlock.FACING)).func_176740_k() : Direction.Axis.Y);
            if (face.func_176740_k() == newAxis) {
                return PlacementOffset.fail();
            }
            List<Direction> directions = IPlacementHelper.orderedByDistanceExceptAxis(pos, ray.func_216347_e(), face.func_176740_k(), newAxis);
            for (Direction d : directions) {
                BlockPos newPos = pos.func_177972_a(face).func_177972_a(d);
                if (!world.func_180495_p(newPos).func_185904_a().func_76222_j()) continue;
                if (!CogWheelBlock.isValidCogwheelPosition(false, (IWorldReader)world, newPos, newAxis)) {
                    return PlacementOffset.fail();
                }
                return PlacementOffset.success((Vector3i)newPos, s -> (BlockState)s.func_206870_a((Property)CogWheelBlock.AXIS, (Comparable)newAxis));
            }
            return PlacementOffset.fail();
        }
    }

    @MethodsReturnNonnullByDefault
    public static abstract class DiagonalCogHelper
    implements IPlacementHelper {
        @Override
        public Predicate<BlockState> getStatePredicate() {
            return s -> s.func_177230_c() instanceof CogWheelBlock;
        }

        @Override
        public PlacementOffset getOffset(PlayerEntity player, World world, BlockState state, BlockPos pos, BlockRayTraceResult ray) {
            Direction closest = IPlacementHelper.orderedByDistanceExceptAxis(pos, ray.func_216347_e(), (Direction.Axis)state.func_177229_b(RotatedPillarKineticBlock.AXIS)).get(0);
            List<Direction> directions = IPlacementHelper.orderedByDistanceExceptAxis(pos, ray.func_216347_e(), (Direction.Axis)state.func_177229_b(RotatedPillarKineticBlock.AXIS), (Direction d) -> d.func_176740_k() != closest.func_176740_k());
            for (Direction dir : directions) {
                BlockPos newPos = pos.func_177972_a(dir).func_177972_a(closest);
                if (!world.func_180495_p(newPos).func_185904_a().func_76222_j() || !CogWheelBlock.isValidCogwheelPosition(ICogWheel.isLargeCog(state), (IWorldReader)world, newPos, (Direction.Axis)state.func_177229_b(RotatedPillarKineticBlock.AXIS))) continue;
                return PlacementOffset.success((Vector3i)newPos, s -> (BlockState)s.func_206870_a(RotatedPillarKineticBlock.AXIS, state.func_177229_b(RotatedPillarKineticBlock.AXIS)));
            }
            return PlacementOffset.fail();
        }

        protected boolean hitOnShaft(BlockState state, BlockRayTraceResult ray) {
            return AllShapes.SIX_VOXEL_POLE.get((Direction.Axis)state.func_177229_b(RotatedPillarKineticBlock.AXIS)).func_197752_a().func_186662_g(0.001).func_72318_a(ray.func_216347_e().func_178788_d(ray.func_216347_e().func_197746_a(Iterate.axisSet)));
        }
    }

    @MethodsReturnNonnullByDefault
    private static class LargeCogHelper
    extends DiagonalCogHelper {
        private LargeCogHelper() {
        }

        @Override
        public Predicate<ItemStack> getItemPredicate() {
            return ((Predicate<ItemStack>)ICogWheel::isLargeCogItem).and(ICogWheel::isDedicatedCogItem);
        }

        @Override
        public PlacementOffset getOffset(PlayerEntity player, World world, BlockState state, BlockPos pos, BlockRayTraceResult ray) {
            if (this.hitOnShaft(state, ray)) {
                return PlacementOffset.fail();
            }
            if (((CogWheelBlock)state.func_177230_c()).isLarge) {
                Direction side = IPlacementHelper.orderedByDistanceOnlyAxis(pos, ray.func_216347_e(), (Direction.Axis)state.func_177229_b(RotatedPillarKineticBlock.AXIS)).get(0);
                List<Direction> directions = IPlacementHelper.orderedByDistanceExceptAxis(pos, ray.func_216347_e(), (Direction.Axis)state.func_177229_b(RotatedPillarKineticBlock.AXIS));
                for (Direction dir : directions) {
                    BlockPos newPos = pos.func_177972_a(dir).func_177972_a(side);
                    if (!CogWheelBlock.isValidCogwheelPosition(true, (IWorldReader)world, newPos, dir.func_176740_k()) || !world.func_180495_p(newPos).func_185904_a().func_76222_j()) continue;
                    return PlacementOffset.success((Vector3i)newPos, s -> (BlockState)s.func_206870_a(RotatedPillarKineticBlock.AXIS, (Comparable)dir.func_176740_k()));
                }
                return PlacementOffset.fail();
            }
            return super.getOffset(player, world, state, pos, ray);
        }
    }

    @MethodsReturnNonnullByDefault
    private static class SmallCogHelper
    extends DiagonalCogHelper {
        private SmallCogHelper() {
        }

        @Override
        public Predicate<ItemStack> getItemPredicate() {
            return ((Predicate<ItemStack>)ICogWheel::isSmallCogItem).and(ICogWheel::isDedicatedCogItem);
        }

        @Override
        public PlacementOffset getOffset(PlayerEntity player, World world, BlockState state, BlockPos pos, BlockRayTraceResult ray) {
            if (this.hitOnShaft(state, ray)) {
                return PlacementOffset.fail();
            }
            if (!((CogWheelBlock)state.func_177230_c()).isLarge) {
                List<Direction> directions = IPlacementHelper.orderedByDistanceExceptAxis(pos, ray.func_216347_e(), (Direction.Axis)state.func_177229_b(RotatedPillarKineticBlock.AXIS));
                for (Direction dir : directions) {
                    BlockPos newPos = pos.func_177972_a(dir);
                    if (!CogWheelBlock.isValidCogwheelPosition(false, (IWorldReader)world, newPos, (Direction.Axis)state.func_177229_b(RotatedPillarKineticBlock.AXIS)) || !world.func_180495_p(newPos).func_185904_a().func_76222_j()) continue;
                    return PlacementOffset.success((Vector3i)newPos, s -> (BlockState)s.func_206870_a(RotatedPillarKineticBlock.AXIS, state.func_177229_b(RotatedPillarKineticBlock.AXIS)));
                }
                return PlacementOffset.fail();
            }
            return super.getOffset(player, world, state, pos, ray);
        }
    }
}

