/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.wrench;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.base.DirectionalAxisKineticBlock;
import com.simibubi.create.content.contraptions.base.DirectionalKineticBlock;
import com.simibubi.create.content.contraptions.base.GeneratingKineticTileEntity;
import com.simibubi.create.content.contraptions.base.HorizontalAxisKineticBlock;
import com.simibubi.create.content.contraptions.base.HorizontalKineticBlock;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.RotatedPillarKineticBlock;
import com.simibubi.create.foundation.utility.DirectionHelper;
import com.simibubi.create.foundation.utility.VoxelShaper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public interface IWrenchable {
    default public ActionResultType onWrenched(BlockState state, ItemUseContext context) {
        World world = context.func_195991_k();
        BlockState rotated = this.getRotatedBlockState(state, context.func_196000_l());
        if (!rotated.func_196955_c((IWorldReader)world, context.func_195995_a())) {
            return ActionResultType.PASS;
        }
        KineticTileEntity.switchToBlockState(world, context.func_195995_a(), this.updateAfterWrenched(rotated, context));
        TileEntity te = context.func_195991_k().func_175625_s(context.func_195995_a());
        if (te != null) {
            te.func_145836_u();
        }
        if (te instanceof GeneratingKineticTileEntity) {
            ((GeneratingKineticTileEntity)te).reActivateSource = true;
        }
        if (world.func_180495_p(context.func_195995_a()) != state) {
            this.playRotateSound(world, context.func_195995_a());
        }
        return ActionResultType.SUCCESS;
    }

    default public BlockState updateAfterWrenched(BlockState newState, ItemUseContext context) {
        return Block.func_199770_b((BlockState)newState, (IWorld)context.func_195991_k(), (BlockPos)context.func_195995_a());
    }

    default public ActionResultType onSneakWrenched(BlockState state, ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        if (world instanceof ServerWorld) {
            if (player != null && !player.func_184812_l_()) {
                Block.func_220077_a((BlockState)state, (ServerWorld)((ServerWorld)world), (BlockPos)pos, (TileEntity)world.func_175625_s(pos), (Entity)player, (ItemStack)context.func_195996_i()).forEach(itemStack -> player.field_71071_by.func_191975_a(world, itemStack));
            }
            state.func_215706_a((ServerWorld)world, pos, ItemStack.field_190927_a);
            world.func_175655_b(pos, false);
            this.playRemoveSound(world, pos);
        }
        return ActionResultType.SUCCESS;
    }

    default public void playRemoveSound(World world, BlockPos pos) {
        AllSoundEvents.WRENCH_REMOVE.playOnServer(world, pos, 1.0f, Create.RANDOM.nextFloat() * 0.5f + 0.5f);
    }

    default public void playRotateSound(World world, BlockPos pos) {
        AllSoundEvents.WRENCH_ROTATE.playOnServer(world, pos, 1.0f, Create.RANDOM.nextFloat() + 0.5f);
    }

    default public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        BlockState newState = originalState;
        if (targetedFace.func_176740_k() == Direction.Axis.Y) {
            if (originalState.func_235901_b_(HorizontalAxisKineticBlock.HORIZONTAL_AXIS)) {
                return (BlockState)originalState.func_206870_a(HorizontalAxisKineticBlock.HORIZONTAL_AXIS, (Comparable)DirectionHelper.rotateAround(VoxelShaper.axisAsFace((Direction.Axis)originalState.func_177229_b(HorizontalAxisKineticBlock.HORIZONTAL_AXIS)), targetedFace.func_176740_k()).func_176740_k());
            }
            if (originalState.func_235901_b_(HorizontalKineticBlock.HORIZONTAL_FACING)) {
                return (BlockState)originalState.func_206870_a(HorizontalKineticBlock.HORIZONTAL_FACING, (Comparable)DirectionHelper.rotateAround((Direction)originalState.func_177229_b(HorizontalKineticBlock.HORIZONTAL_FACING), targetedFace.func_176740_k()));
            }
        }
        if (originalState.func_235901_b_(RotatedPillarKineticBlock.AXIS)) {
            return (BlockState)originalState.func_206870_a(RotatedPillarKineticBlock.AXIS, (Comparable)DirectionHelper.rotateAround(VoxelShaper.axisAsFace((Direction.Axis)originalState.func_177229_b(RotatedPillarKineticBlock.AXIS)), targetedFace.func_176740_k()).func_176740_k());
        }
        if (!originalState.func_235901_b_((Property)DirectionalKineticBlock.FACING)) {
            return originalState;
        }
        Direction stateFacing = (Direction)originalState.func_177229_b((Property)DirectionalKineticBlock.FACING);
        if (stateFacing.func_176740_k().equals((Object)targetedFace.func_176740_k())) {
            if (originalState.func_235901_b_((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE)) {
                return (BlockState)originalState.func_235896_a_((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE);
            }
            return originalState;
        }
        do {
            newState = (BlockState)newState.func_206870_a((Property)DirectionalKineticBlock.FACING, (Comparable)DirectionHelper.rotateAround((Direction)newState.func_177229_b((Property)DirectionalKineticBlock.FACING), targetedFace.func_176740_k()));
            if (targetedFace.func_176740_k() != Direction.Axis.Y || !newState.func_235901_b_((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE)) continue;
            newState = (BlockState)newState.func_235896_a_((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE);
        } while (((Direction)newState.func_177229_b((Property)DirectionalKineticBlock.FACING)).func_176740_k().equals((Object)targetedFace.func_176740_k()));
        return newState;
    }
}

