/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.zapper;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.curiosities.zapper.ShootableGadgetRenderHandler;
import com.simibubi.create.content.curiosities.zapper.ZapperItem;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public class ZapperRenderHandler
extends ShootableGadgetRenderHandler {
    public List<LaserBeam> cachedBeams;

    @Override
    protected boolean appliesTo(ItemStack stack) {
        return stack.func_77973_b() instanceof ZapperItem;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.cachedBeams == null) {
            this.cachedBeams = new LinkedList<LaserBeam>();
        }
        this.cachedBeams.removeIf(b -> b.itensity < 0.1f);
        if (this.cachedBeams.isEmpty()) {
            return;
        }
        this.cachedBeams.forEach(beam -> CreateClient.OUTLINER.endChasingLine(beam, beam.start, beam.end, 1.0f - beam.itensity).disableNormals().colored(0xFFFFFF).lineWidth(beam.itensity * 1.0f / 8.0f));
        this.cachedBeams.forEach(b -> b.itensity *= 0.6f);
    }

    @Override
    protected void transformTool(MatrixStack ms, float flip, float equipProgress, float recoil, float pt) {
        ms.func_227861_a_((double)(flip * -0.1f), (double)0.1f, (double)-0.4f);
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(flip * 5.0f));
    }

    @Override
    protected void transformHand(MatrixStack ms, float flip, float equipProgress, float recoil, float pt) {
    }

    @Override
    protected void playSound(Hand hand, Vector3d position) {
        float pitch = hand == Hand.MAIN_HAND ? 0.1f : 0.9f;
        Minecraft mc = Minecraft.func_71410_x();
        AllSoundEvents.WORLDSHAPER_PLACE.play((World)mc.field_71441_e, (PlayerEntity)mc.field_71439_g, position, 0.1f, pitch);
    }

    public void addBeam(LaserBeam beam) {
        Random r = new Random();
        double x = beam.end.field_72450_a;
        double y = beam.end.field_72448_b;
        double z = beam.end.field_72449_c;
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        Supplier<Double> randomSpeed = () -> (r.nextDouble() - 0.5) * (double)0.2f;
        Supplier<Double> randomOffset = () -> (r.nextDouble() - 0.5) * (double)0.2f;
        for (int i = 0; i < 10; ++i) {
            world.func_195594_a((IParticleData)ParticleTypes.field_197624_q, x, y, z, randomSpeed.get().doubleValue(), randomSpeed.get().doubleValue(), randomSpeed.get().doubleValue());
            world.func_195594_a((IParticleData)ParticleTypes.field_197629_v, x + randomOffset.get(), y + randomOffset.get(), z + randomOffset.get(), 0.0, 0.0, 0.0);
        }
        this.cachedBeams.add(beam);
    }

    public static class LaserBeam {
        float itensity;
        Vector3d start;
        Vector3d end;

        public LaserBeam(Vector3d start, Vector3d end) {
            this.start = start;
            this.end = end;
            this.itensity = 1.0f;
        }
    }
}

