/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.zapper.terrainzapper;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.content.curiosities.zapper.ConfigureZapperPacket;
import com.simibubi.create.content.curiosities.zapper.ZapperScreen;
import com.simibubi.create.content.curiosities.zapper.terrainzapper.Brush;
import com.simibubi.create.content.curiosities.zapper.terrainzapper.ConfigureWorldshaperPacket;
import com.simibubi.create.content.curiosities.zapper.terrainzapper.PlacementOptions;
import com.simibubi.create.content.curiosities.zapper.terrainzapper.TerrainBrushes;
import com.simibubi.create.content.curiosities.zapper.terrainzapper.TerrainTools;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widgets.IconButton;
import com.simibubi.create.foundation.gui.widgets.Indicator;
import com.simibubi.create.foundation.gui.widgets.Label;
import com.simibubi.create.foundation.gui.widgets.ScrollInput;
import com.simibubi.create.foundation.gui.widgets.SelectionScrollInput;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.List;
import java.util.Vector;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;

public class WorldshaperScreen
extends ZapperScreen {
    protected final ITextComponent placementSection = Lang.translate("gui.terrainzapper.placement", new Object[0]);
    protected final ITextComponent toolSection = Lang.translate("gui.terrainzapper.tool", new Object[0]);
    protected final List<ITextComponent> brushOptions = Lang.translatedOptions("gui.terrainzapper.brush", "cuboid", "sphere", "cylinder", "surface", "cluster");
    protected Vector<IconButton> toolButtons;
    protected Vector<IconButton> placementButtons;
    protected ScrollInput brushInput;
    protected Label brushLabel;
    protected Vector<ScrollInput> brushParams = new Vector(3);
    protected Vector<Label> brushParamLabels = new Vector(3);
    protected IconButton followDiagonals;
    protected IconButton acrossMaterials;
    protected Indicator followDiagonalsIndicator;
    protected Indicator acrossMaterialsIndicator;
    protected TerrainBrushes currentBrush;
    protected int[] currentBrushParams = new int[]{1, 1, 1};
    protected boolean currentFollowDiagonals;
    protected boolean currentAcrossMaterials;
    protected TerrainTools currentTool;
    protected PlacementOptions currentPlacement;

    public WorldshaperScreen(ItemStack zapper, Hand hand) {
        super(AllGuiTextures.TERRAINZAPPER, zapper, hand);
        this.fontColor = 0x767676;
        this.field_230704_d_ = zapper.func_200301_q();
        CompoundNBT nbt = zapper.func_196082_o();
        this.currentBrush = NBTHelper.readEnum(nbt, "Brush", TerrainBrushes.class);
        if (nbt.func_150297_b("BrushParams", 10)) {
            BlockPos paramsData = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("BrushParams"));
            this.currentBrushParams[0] = paramsData.func_177958_n();
            this.currentBrushParams[1] = paramsData.func_177956_o();
            this.currentBrushParams[2] = paramsData.func_177952_p();
            if (this.currentBrushParams[1] == 0) {
                this.currentFollowDiagonals = true;
            }
            if (this.currentBrushParams[2] == 0) {
                this.currentAcrossMaterials = true;
            }
        }
        this.currentTool = NBTHelper.readEnum(nbt, "Tool", TerrainTools.class);
        this.currentPlacement = NBTHelper.readEnum(nbt, "Placement", PlacementOptions.class);
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        int x = this.guiLeft;
        int y = this.guiTop;
        this.brushLabel = new Label(x + 61, y + 25, StringTextComponent.field_240750_d_).withShadow();
        this.brushInput = new SelectionScrollInput(x + 56, y + 20, 77, 18).forOptions(this.brushOptions).titled((IFormattableTextComponent)Lang.translate("gui.terrainzapper.brush", new Object[0])).writingTo(this.brushLabel).calling(brushIndex -> {
            this.currentBrush = TerrainBrushes.values()[brushIndex];
            this.initBrushParams(x, y);
        });
        this.brushInput.setState(this.currentBrush.ordinal());
        this.widgets.add(this.brushLabel);
        this.widgets.add(this.brushInput);
        this.initBrushParams(x, y);
    }

    protected void initBrushParams(int x, int y) {
        Brush currentBrush = this.currentBrush.get();
        this.widgets.removeAll(this.brushParamLabels);
        this.widgets.removeAll(this.brushParams);
        this.brushParamLabels.clear();
        this.brushParams.clear();
        for (int index = 0; index < 3; ++index) {
            Label label = new Label(x + 65 + 20 * index, y + 45, StringTextComponent.field_240750_d_).withShadow();
            int finalIndex = index;
            ScrollInput input = new ScrollInput(x + 56 + 20 * index, y + 40, 18, 18).withRange(currentBrush.getMin(index), currentBrush.getMax(index) + 1).writingTo(label).titled(currentBrush.getParamLabel(index).func_230531_f_()).calling(state -> {
                this.currentBrushParams[finalIndex] = state;
                label.field_230690_l_ = x + 65 + 20 * finalIndex - this.field_230712_o_.func_238414_a_((ITextProperties)label.text) / 2;
            });
            input.setState(this.currentBrushParams[index]);
            input.onChanged();
            if (index >= currentBrush.amtParams) {
                input.field_230694_p_ = false;
                label.field_230694_p_ = false;
                input.field_230693_o_ = false;
            }
            this.brushParamLabels.add(label);
            this.brushParams.add(input);
        }
        this.widgets.addAll(this.brushParamLabels);
        this.widgets.addAll(this.brushParams);
        if (this.followDiagonals != null) {
            this.widgets.remove((Object)this.followDiagonals);
            this.widgets.remove((Object)this.followDiagonalsIndicator);
            this.widgets.remove((Object)this.acrossMaterials);
            this.widgets.remove((Object)this.acrossMaterialsIndicator);
            this.followDiagonals = null;
            this.followDiagonalsIndicator = null;
            this.acrossMaterials = null;
            this.acrossMaterialsIndicator = null;
        }
        if (currentBrush.hasConnectivityOptions()) {
            int x1 = x + 7 + 72;
            int y1 = y + 79;
            this.followDiagonalsIndicator = new Indicator(x1, y1 - 6, StringTextComponent.field_240750_d_);
            this.followDiagonals = new IconButton(x1, y1, AllIcons.I_FOLLOW_DIAGONAL);
            this.acrossMaterialsIndicator = new Indicator(x1 += 18, y1 - 6, StringTextComponent.field_240750_d_);
            this.acrossMaterials = new IconButton(x1, y1, AllIcons.I_FOLLOW_MATERIAL);
            this.followDiagonals.setToolTip((ITextComponent)Lang.translate("gui.terrainzapper.searchDiagonal", new Object[0]));
            this.acrossMaterials.setToolTip((ITextComponent)Lang.translate("gui.terrainzapper.searchFuzzy", new Object[0]));
            this.widgets.add(this.followDiagonals);
            this.widgets.add(this.followDiagonalsIndicator);
            this.widgets.add(this.acrossMaterials);
            this.widgets.add(this.acrossMaterialsIndicator);
            if (this.currentFollowDiagonals) {
                this.followDiagonalsIndicator.state = Indicator.State.ON;
            }
            if (this.currentAcrossMaterials) {
                this.acrossMaterialsIndicator.state = Indicator.State.ON;
            }
        }
        if (this.toolButtons != null) {
            this.widgets.removeAll(this.toolButtons);
        }
        TerrainTools[] toolValues = currentBrush.getSupportedTools();
        this.toolButtons = new Vector(toolValues.length);
        for (int id = 0; id < toolValues.length; ++id) {
            TerrainTools tool = toolValues[id];
            this.toolButtons.add(new IconButton(x + 7 + id * 18, y + 79, tool.icon));
            this.toolButtons.get(id).setToolTip((ITextComponent)Lang.translate("gui.terrainzapper.tool." + tool.translationKey, new Object[0]));
        }
        int toolIndex = -1;
        for (int i = 0; i < toolValues.length; ++i) {
            if (this.currentTool != toolValues[i]) continue;
            toolIndex = i;
        }
        if (toolIndex == -1) {
            this.currentTool = toolValues[0];
            toolIndex = 0;
        }
        this.toolButtons.get((int)toolIndex).field_230693_o_ = false;
        this.widgets.addAll(this.toolButtons);
        if (this.placementButtons != null) {
            this.widgets.removeAll(this.placementButtons);
        }
        if (currentBrush.hasPlacementOptions()) {
            PlacementOptions[] placementValues = PlacementOptions.values();
            this.placementButtons = new Vector(placementValues.length);
            for (int id = 0; id < placementValues.length; ++id) {
                PlacementOptions option = placementValues[id];
                this.placementButtons.add(new IconButton(x + 136 + id * 18, y + 79, option.icon));
                this.placementButtons.get(id).setToolTip((ITextComponent)Lang.translate("gui.terrainzapper.placement." + option.translationKey, new Object[0]));
            }
            this.placementButtons.get((int)this.currentPlacement.ordinal()).field_230693_o_ = false;
            this.widgets.addAll(this.placementButtons);
        }
    }

    @Override
    public boolean func_231044_a_(double x, double y, int button) {
        TerrainTools[] supportedTools = this.currentBrush.get().getSupportedTools();
        for (IconButton toolButton : this.toolButtons) {
            if (!toolButton.func_230449_g_()) continue;
            this.toolButtons.forEach(b -> {
                b.field_230693_o_ = true;
            });
            toolButton.field_230693_o_ = false;
            toolButton.func_230988_a_(this.field_230706_i_.func_147118_V());
            this.currentTool = supportedTools[this.toolButtons.indexOf((Object)toolButton)];
        }
        if (this.placementButtons != null) {
            for (IconButton placementButton : this.placementButtons) {
                if (!placementButton.func_230449_g_()) continue;
                this.placementButtons.forEach(b -> {
                    b.field_230693_o_ = true;
                });
                placementButton.field_230693_o_ = false;
                placementButton.func_230988_a_(this.field_230706_i_.func_147118_V());
                this.currentPlacement = PlacementOptions.values()[this.placementButtons.indexOf((Object)placementButton)];
            }
        }
        if (this.followDiagonals != null && this.followDiagonals.func_230449_g_()) {
            this.followDiagonalsIndicator.state = this.followDiagonalsIndicator.state == Indicator.State.OFF ? Indicator.State.ON : Indicator.State.OFF;
            boolean bl = this.currentFollowDiagonals = !this.currentFollowDiagonals;
        }
        if (this.acrossMaterials != null && this.acrossMaterials.func_230449_g_()) {
            this.acrossMaterialsIndicator.state = this.acrossMaterialsIndicator.state == Indicator.State.OFF ? Indicator.State.ON : Indicator.State.OFF;
            this.currentAcrossMaterials = !this.currentAcrossMaterials;
        }
        return super.func_231044_a_(x, y, button);
    }

    @Override
    protected void drawOnBackground(MatrixStack matrixStack, int x, int y) {
        super.drawOnBackground(matrixStack, x, y);
        Brush currentBrush = this.currentBrush.get();
        for (int index = 2; index >= currentBrush.amtParams; --index) {
            AllGuiTextures.TERRAINZAPPER_INACTIVE_PARAM.draw(matrixStack, x + 56 + 20 * index, y + 40);
        }
        this.field_230712_o_.func_243248_b(matrixStack, this.toolSection, (float)(x + 7), (float)(y + 69), this.fontColor);
        if (currentBrush.hasPlacementOptions()) {
            this.field_230712_o_.func_243248_b(matrixStack, this.placementSection, (float)(x + 136), (float)(y + 69), this.fontColor);
        }
    }

    @Override
    protected ConfigureZapperPacket getConfigurationPacket() {
        int brushParamY;
        int brushParamX = this.currentBrushParams[0];
        int n = this.followDiagonalsIndicator != null ? (this.followDiagonalsIndicator.state == Indicator.State.ON ? 0 : 1) : (brushParamY = this.currentBrushParams[1]);
        int brushParamZ = this.acrossMaterialsIndicator != null ? (this.acrossMaterialsIndicator.state == Indicator.State.ON ? 0 : 1) : this.currentBrushParams[2];
        return new ConfigureWorldshaperPacket(this.hand, this.currentPattern, this.currentBrush, brushParamX, brushParamY, brushParamZ, this.currentTool, this.currentPlacement);
    }
}

