/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.command;

import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.goggles.GoggleConfigScreen;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.config.ui.BaseConfigScreen;
import com.simibubi.create.foundation.config.ui.ConfigHelper;
import com.simibubi.create.foundation.config.ui.SubMenuConfigScreen;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.PonderUI;
import com.simibubi.create.foundation.ponder.content.PonderIndexScreen;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;

public class SConfigureConfigPacket
extends SimplePacketBase {
    private final String option;
    private final String value;

    public SConfigureConfigPacket(String option, String value) {
        this.option = option;
        this.value = value;
    }

    public SConfigureConfigPacket(PacketBuffer buffer) {
        this.option = buffer.func_150789_c(Short.MAX_VALUE);
        this.value = buffer.func_150789_c(Short.MAX_VALUE);
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_180714_a(this.option);
        buffer.func_180714_a(this.value);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (this.option.startsWith("SET")) {
                SConfigureConfigPacket.trySetConfig(this.option.substring(3), this.value);
                return;
            }
            try {
                Actions.valueOf(this.option).performAction(this.value);
            }
            catch (IllegalArgumentException e) {
                LogManager.getLogger().warn("Received ConfigureConfigPacket with invalid Option: " + this.option);
            }
        }));
        ctx.get().setPacketHandled(true);
    }

    private static void trySetConfig(String option, String value) {
        ConfigHelper.ConfigPath configPath;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        try {
            configPath = ConfigHelper.ConfigPath.parse(option);
        }
        catch (IllegalArgumentException e) {
            player.func_146105_b((ITextComponent)new StringTextComponent(e.getMessage()), false);
            return;
        }
        if (configPath.getType() != ModConfig.Type.CLIENT) {
            Create.LOGGER.warn("Received type-mismatched config packet on client");
            return;
        }
        try {
            ConfigHelper.setConfigValue(configPath, value);
            player.func_146105_b((ITextComponent)new StringTextComponent("Great Success!"), false);
        }
        catch (ConfigHelper.InvalidValueException e) {
            player.func_146105_b((ITextComponent)new StringTextComponent("Config could not be set the the specified value!"), false);
        }
        catch (Exception e) {
            player.func_146105_b((ITextComponent)new StringTextComponent("Something went wrong while trying to set config value. Check the client logs for more information"), false);
            Create.LOGGER.warn("Exception during client-side config value set:", (Throwable)e);
        }
    }

    public static enum Actions {
        configScreen(() -> Actions::configScreen),
        rainbowDebug(() -> Actions::rainbowDebug),
        overlayScreen(() -> Actions::overlayScreen),
        fixLighting(() -> Actions::experimentalLighting),
        overlayReset(() -> Actions::overlayReset),
        openPonder(() -> Actions::openPonder),
        fabulousWarning(() -> Actions::fabulousWarning);

        private final Supplier<Consumer<String>> consumer;

        private Actions(Supplier<Consumer<String>> action) {
            this.consumer = action;
        }

        void performAction(String value) {
            this.consumer.get().accept(value);
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void configScreen(String value) {
            ConfigHelper.ConfigPath configPath;
            if (value.equals("")) {
                ScreenOpener.open(BaseConfigScreen.forCreate(null));
                return;
            }
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            try {
                configPath = ConfigHelper.ConfigPath.parse(value);
            }
            catch (IllegalArgumentException e) {
                player.func_146105_b((ITextComponent)new StringTextComponent(e.getMessage()), false);
                return;
            }
            try {
                ScreenOpener.open(SubMenuConfigScreen.find(configPath));
            }
            catch (Exception e) {
                player.func_146105_b((ITextComponent)new StringTextComponent("Unable to find the specified config"), false);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void rainbowDebug(String value) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player == null || "".equals(value)) {
                return;
            }
            if (value.equals("info")) {
                IFormattableTextComponent text = new StringTextComponent("Rainbow Debug Utility is currently: ").func_230529_a_((ITextComponent)Actions.boolToText((Boolean)AllConfigs.CLIENT.rainbowDebug.get()));
                player.func_146105_b((ITextComponent)text, false);
                return;
            }
            AllConfigs.CLIENT.rainbowDebug.set(Boolean.parseBoolean(value));
            IFormattableTextComponent text = Actions.boolToText((Boolean)AllConfigs.CLIENT.rainbowDebug.get()).func_230529_a_((ITextComponent)new StringTextComponent(" Rainbow Debug Utility").func_240699_a_(TextFormatting.WHITE));
            player.func_146105_b((ITextComponent)text, false);
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void overlayReset(String value) {
            AllConfigs.CLIENT.overlayOffsetX.set(0);
            AllConfigs.CLIENT.overlayOffsetY.set(0);
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void overlayScreen(String value) {
            ScreenOpener.open(new GoggleConfigScreen());
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void experimentalLighting(String value) {
            ForgeConfig.CLIENT.experimentalForgeLightPipelineEnabled.set((Object)true);
            Minecraft.func_71410_x().field_71438_f.func_72712_a();
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void openPonder(String value) {
            if (value.equals("index")) {
                ScreenOpener.transitionTo(new PonderIndexScreen());
                return;
            }
            ResourceLocation id = new ResourceLocation(value);
            if (!PonderRegistry.ALL.containsKey(id)) {
                Create.LOGGER.error("Could not find ponder scenes for item: " + id);
                return;
            }
            ScreenOpener.transitionTo(PonderUI.of(id));
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void fabulousWarning(String value) {
            AllConfigs.CLIENT.ignoreFabulousWarning.set(true);
            Minecraft.func_71410_x().field_71456_v.func_238450_a_(ChatType.CHAT, (ITextComponent)new StringTextComponent("Disabled Fabulous graphics warning"), Minecraft.func_71410_x().field_71439_g.func_110124_au());
        }

        private static IFormattableTextComponent boolToText(boolean b) {
            return b ? new StringTextComponent("enabled").func_240699_a_(TextFormatting.DARK_GREEN) : new StringTextComponent("disabled").func_240699_a_(TextFormatting.RED);
        }
    }
}

