/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.content.fluid;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.fluids.PumpBlock;
import com.simibubi.create.content.contraptions.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.contraptions.fluids.pipes.GlassFluidPipeBlock;
import com.simibubi.create.content.contraptions.fluids.tank.FluidTankTileEntity;
import com.simibubi.create.content.contraptions.relays.elementary.CogWheelBlock;
import com.simibubi.create.foundation.ponder.ElementLink;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.SceneBuildingUtil;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.content.PonderPalette;
import com.simibubi.create.foundation.ponder.elements.InputWindowElement;
import com.simibubi.create.foundation.ponder.elements.WorldSectionElement;
import com.simibubi.create.foundation.utility.Pointing;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class PumpScenes {
    public static void flow(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("mechanical_pump_flow", "Fluid Transportation using Mechanical Pumps");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.world.multiplyKineticSpeed(util.select.everywhere(), -1.0f);
        scene.idle(5);
        BlockPos pumpPos = util.grid.at(2, 1, 1);
        Selection tank1 = util.select.fromTo(0, 2, 3, 0, 1, 3);
        Selection tank2 = util.select.fromTo(4, 2, 3, 4, 1, 3);
        Selection pipes = util.select.fromTo(3, 1, 3, 1, 1, 1);
        Selection largeCog = util.select.position(5, 0, 1);
        Selection kinetics = util.select.fromTo(5, 1, 0, 2, 1, 0);
        BlockPos leverPos = util.grid.at(4, 2, 0);
        Selection pump = util.select.position(pumpPos);
        scene.world.setBlock(pumpPos, ((FluidPipeBlock)AllBlocks.FLUID_PIPE.get()).getAxisState(Direction.Axis.X), false);
        scene.world.showSection(tank1, Direction.DOWN);
        scene.idle(5);
        scene.world.showSection(tank2, Direction.DOWN);
        scene.idle(5);
        scene.world.showSection(pipes, Direction.NORTH);
        scene.idle(15);
        scene.world.destroyBlock(pumpPos);
        scene.world.restoreBlocks(pump);
        scene.world.setKineticSpeed(pump, 0.0f);
        scene.idle(15);
        scene.overlay.showText(60).text("Mechanical Pumps govern the flow of their attached pipe networks").attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(pumpPos));
        scene.idle(70);
        scene.world.showSection(largeCog, Direction.UP);
        scene.idle(5);
        scene.world.showSection(kinetics, Direction.SOUTH);
        scene.world.showSection(util.select.position(leverPos), Direction.SOUTH);
        scene.idle(10);
        scene.world.setKineticSpeed(pump, 64.0f);
        scene.world.propagatePipeChange(pumpPos);
        scene.effects.rotationDirectionIndicator(pumpPos.func_177978_c());
        scene.idle(15);
        scene.overlay.showText(60).text("When powered, their arrow indicates the direction of flow").attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(pumpPos).func_178786_a(0.5, 0.125, 0.0));
        AxisAlignedBB bb1 = new AxisAlignedBB(Vector3d.field_186680_a, Vector3d.field_186680_a).func_72314_b(0.25, 0.25, 0.0).func_72317_d(0.0, 0.0, 0.25);
        AxisAlignedBB bb2 = new AxisAlignedBB(Vector3d.field_186680_a, Vector3d.field_186680_a).func_72314_b(0.25, 0.25, 1.25);
        scene.idle(65);
        Object in = new Object();
        Object out = new Object();
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.INPUT, in, bb1.func_191194_a(util.vector.centerOf(3, 1, 3)), 3);
        scene.idle(2);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.INPUT, in, bb2.func_191194_a(util.vector.centerOf(3, 1, 2)), 50);
        scene.idle(10);
        scene.overlay.showText(50).text("The network behind is now pulling fluids...").attachKeyFrame().placeNearTarget().colored(PonderPalette.INPUT).pointAt(util.vector.centerOf(3, 1, 2));
        scene.idle(60);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.OUTPUT, out, bb1.func_191194_a(util.vector.centerOf(1, 1, 1).func_72441_c(0.0, 0.0, -0.5)), 3);
        scene.idle(2);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.OUTPUT, out, bb2.func_191194_a(util.vector.centerOf(1, 1, 2)), 50);
        scene.idle(10);
        scene.overlay.showText(50).text("...while the network in front is transferring it outward").placeNearTarget().colored(PonderPalette.OUTPUT).pointAt(util.vector.centerOf(1, 1, 2));
        scene.idle(70);
        scene.world.toggleRedstonePower(util.select.fromTo(4, 2, 0, 4, 1, 0));
        scene.effects.indicateRedstone(leverPos);
        scene.world.multiplyKineticSpeed(util.select.fromTo(3, 1, 0, 2, 1, 1), -1.0f);
        scene.effects.rotationDirectionIndicator(pumpPos.func_177978_c());
        scene.world.propagatePipeChange(pumpPos);
        scene.idle(15);
        scene.overlay.showText(70).text("Reversing the input rotation reverses the direction of flow").placeNearTarget().attachKeyFrame().pointAt(util.vector.topOf(pumpPos).func_178786_a(0.5, 0.125, 0.0));
        scene.idle(25);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.INPUT, in, bb1.func_191194_a(util.vector.centerOf(1, 1, 3)), 3);
        scene.idle(2);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.INPUT, in, bb2.func_191194_a(util.vector.centerOf(1, 1, 2)), 30);
        scene.idle(15);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.OUTPUT, out, bb1.func_191194_a(util.vector.centerOf(3, 1, 1).func_72441_c(0.0, 0.0, -0.5)), 3);
        scene.idle(2);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.OUTPUT, out, bb2.func_191194_a(util.vector.centerOf(3, 1, 2)), 30);
        scene.idle(55);
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(pumpPos), Pointing.DOWN).rightClick().withWrench(), 40);
        scene.idle(7);
        scene.world.modifyBlock(pumpPos, s -> (BlockState)s.func_206870_a((Property)PumpBlock.FACING, (Comparable)Direction.EAST), true);
        scene.overlay.showText(70).attachKeyFrame().pointAt(util.vector.centerOf(2, 1, 1)).placeNearTarget().text("Use a Wrench to reverse the orientation of pumps manually");
        scene.world.propagatePipeChange(pumpPos);
        scene.idle(40);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.INPUT, in, bb1.func_191194_a(util.vector.centerOf(3, 1, 3)), 3);
        scene.idle(2);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.INPUT, in, bb2.func_191194_a(util.vector.centerOf(3, 1, 2)), 30);
        scene.idle(15);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.OUTPUT, out, bb1.func_191194_a(util.vector.centerOf(1, 1, 1).func_72441_c(0.0, 0.0, -0.5)), 3);
        scene.idle(2);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.OUTPUT, out, bb2.func_191194_a(util.vector.centerOf(1, 1, 2)), 30);
        scene.idle(25);
    }

    public static void speed(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("mechanical_pump_speed", "Throughput of Mechanical Pumps");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.idle(5);
        Selection largeCog = util.select.position(5, 0, 3);
        Selection cogs = util.select.fromTo(5, 1, 4, 2, 1, 4).add(util.select.position(2, 1, 3));
        BlockPos pumpPos = util.grid.at(2, 1, 2);
        Selection pump = util.select.position(pumpPos);
        Selection tank1 = util.select.fromTo(4, 1, 2, 4, 2, 2);
        Selection tank2 = util.select.fromTo(0, 1, 2, 0, 2, 2);
        Selection megapipe1 = util.select.fromTo(0, 3, 5, 1, 4, 2);
        Selection megapipe2 = util.select.fromTo(3, 3, 1, 5, 6, 2);
        scene.world.modifyTileEntity(util.grid.at(0, 1, 2), FluidTankTileEntity.class, te -> te.getTankInventory().drain(3000, IFluidHandler.FluidAction.EXECUTE));
        BlockPos east = pumpPos.func_177974_f();
        scene.world.setBlock(east, Blocks.field_150350_a.func_176223_P(), false);
        scene.world.setBlock(east, (BlockState)AllBlocks.GLASS_FLUID_PIPE.getDefaultState().func_206870_a((Property)GlassFluidPipeBlock.field_176298_M, (Comparable)Direction.Axis.X), false);
        scene.world.setBlock(pumpPos.func_177968_d(), (BlockState)AllBlocks.COGWHEEL.getDefaultState().func_206870_a((Property)CogWheelBlock.AXIS, (Comparable)Direction.Axis.X), false);
        Selection southPump = util.select.position(pumpPos.func_177968_d());
        scene.world.setKineticSpeed(southPump, 32.0f);
        scene.world.setKineticSpeed(pump, 0.0f);
        scene.world.showSection(pump, Direction.DOWN);
        scene.idle(10);
        ElementLink<WorldSectionElement> mp1 = scene.world.showIndependentSection(megapipe1, Direction.EAST);
        scene.world.moveSection(mp1, util.vector.of(0.0, -3.0, 0.0), 0);
        scene.idle(5);
        ElementLink<WorldSectionElement> mp2 = scene.world.showIndependentSection(megapipe2, Direction.WEST);
        scene.world.moveSection(mp2, util.vector.of(0.0, -3.0, 0.0), 0);
        scene.idle(15);
        scene.overlay.showText(70).attachKeyFrame().pointAt(util.vector.topOf(pumpPos)).placeNearTarget().text("Regardless of speed, Mechanical Pumps affect pipes connected up to 16 blocks away");
        scene.idle(75);
        scene.world.hideIndependentSection(mp1, Direction.WEST);
        scene.idle(5);
        scene.world.hideIndependentSection(mp2, Direction.EAST);
        scene.idle(15);
        scene.world.showSection(tank1, Direction.DOWN);
        scene.idle(2);
        scene.world.showSection(util.select.position(east), Direction.DOWN);
        scene.idle(5);
        BlockPos west = pumpPos.func_177976_e();
        scene.world.showSection(util.select.position(west), Direction.DOWN);
        scene.idle(2);
        scene.world.showSection(tank2, Direction.DOWN);
        scene.idle(5);
        scene.world.showSection(largeCog, Direction.UP);
        scene.world.showSection(cogs, Direction.SOUTH);
        scene.idle(10);
        scene.world.setKineticSpeed(util.select.position(pumpPos), -32.0f);
        scene.effects.rotationSpeedIndicator(pumpPos);
        scene.world.propagatePipeChange(pumpPos);
        scene.idle(40);
        scene.world.multiplyKineticSpeed(util.select.everywhere(), 4.0f);
        scene.effects.rotationSpeedIndicator(pumpPos);
        scene.world.propagatePipeChange(pumpPos);
        scene.idle(20);
        scene.overlay.showText(60).attachKeyFrame().pointAt(util.vector.topOf(pumpPos)).placeNearTarget().text("Speeding up the input rotation changes the speed of flow propagation...");
        scene.idle(70);
        scene.overlay.showText(50).pointAt(util.vector.blockSurface(util.grid.at(0, 1, 2), Direction.WEST)).placeNearTarget().text("...aswell as how quickly fluids are transferred");
        scene.idle(60);
        BlockState pipeState = (BlockState)((BlockState)AllBlocks.FLUID_PIPE.getDefaultState().func_206870_a((Property)FluidPipeBlock.field_196489_A, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FluidPipeBlock.field_196496_z, (Comparable)Boolean.valueOf(false));
        scene.world.setKineticSpeed(util.select.everywhere(), 0.0f);
        scene.idle(10);
        scene.world.setBlock(east, pipeState, true);
        scene.world.setBlock(west, pipeState, true);
        scene.world.setBlock(east.func_177978_c(), (BlockState)((BlockState)pipeState.func_206870_a((Property)FluidPipeBlock.field_196488_a, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FluidPipeBlock.field_196490_b, (Comparable)Boolean.valueOf(false)), false);
        scene.world.setBlock(east.func_177968_d(), (BlockState)((BlockState)pipeState.func_206870_a((Property)FluidPipeBlock.field_196492_c, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FluidPipeBlock.field_196490_b, (Comparable)Boolean.valueOf(false)), false);
        scene.world.showSection(util.select.position(east.func_177978_c()), Direction.DOWN);
        scene.world.showSection(util.select.position(east.func_177968_d()), Direction.DOWN);
        Selection northPump = util.select.position(pumpPos.func_177978_c());
        scene.world.setBlock(west.func_177978_c(), (BlockState)((BlockState)pipeState.func_206870_a((Property)FluidPipeBlock.field_196488_a, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FluidPipeBlock.field_196495_y, (Comparable)Boolean.valueOf(false)), false);
        scene.world.setBlock(west.func_177968_d(), (BlockState)((BlockState)pipeState.func_206870_a((Property)FluidPipeBlock.field_196492_c, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FluidPipeBlock.field_196495_y, (Comparable)Boolean.valueOf(false)), false);
        scene.world.showSection(util.select.position(west.func_177978_c()), Direction.DOWN);
        scene.world.showSection(util.select.position(west.func_177968_d()), Direction.DOWN);
        scene.world.restoreBlocks(southPump);
        scene.world.modifyBlock(pumpPos.func_177968_d(), s -> (BlockState)s.func_206870_a((Property)PumpBlock.FACING, (Comparable)Direction.EAST), false);
        scene.world.setKineticSpeed(util.select.everywhere(), 0.0f);
        scene.world.showSection(northPump, Direction.DOWN);
        scene.world.modifyBlock(pumpPos.func_177978_c(), s -> (BlockState)s.func_206870_a((Property)PumpBlock.FACING, (Comparable)Direction.EAST), false);
        scene.idle(4);
        scene.world.setKineticSpeed(util.select.everywhere(), -16.0f);
        scene.world.setKineticSpeed(northPump, 16.0f);
        scene.world.setKineticSpeed(southPump, 16.0f);
        scene.world.setKineticSpeed(largeCog, 8.0f);
        scene.idle(20);
        scene.overlay.showSelectionWithText(util.select.fromTo(2, 1, 1, 2, 1, 3), 60).attachKeyFrame().colored(PonderPalette.GREEN).pointAt(util.vector.topOf(pumpPos)).placeNearTarget().text("Pumps can combine their throughputs within shared pipe networks");
        scene.idle(70);
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(pumpPos.func_177968_d()), Pointing.DOWN).rightClick().withWrench(), 30);
        scene.idle(7);
        scene.world.modifyBlock(pumpPos.func_177968_d(), s -> (BlockState)s.func_206870_a((Property)PumpBlock.FACING, (Comparable)Direction.WEST), true);
        scene.idle(30);
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(pumpPos.func_177978_c()), Pointing.DOWN).rightClick().withWrench(), 30);
        scene.idle(7);
        scene.world.modifyBlock(pumpPos.func_177978_c(), s -> (BlockState)s.func_206870_a((Property)PumpBlock.FACING, (Comparable)Direction.WEST), true);
        scene.idle(30);
        scene.overlay.showText(70).attachKeyFrame().pointAt(util.vector.topOf(pumpPos.func_177978_c()).func_178786_a(0.5, 0.125, 0.0)).placeNearTarget().text("Alternating their orientation can help align their flow directions");
        scene.idle(40);
        scene.world.multiplyKineticSpeed(util.select.everywhere(), 8.0f);
        scene.effects.rotationSpeedIndicator(pumpPos);
        scene.effects.rotationSpeedIndicator(pumpPos.func_177978_c());
        scene.effects.rotationSpeedIndicator(pumpPos.func_177968_d());
        scene.world.propagatePipeChange(pumpPos);
        scene.world.propagatePipeChange(pumpPos.func_177978_c());
        scene.world.propagatePipeChange(pumpPos.func_177968_d());
        scene.idle(100);
        scene.world.multiplyKineticSpeed(util.select.everywhere(), -1.0f);
        scene.effects.rotationSpeedIndicator(pumpPos);
        scene.effects.rotationSpeedIndicator(pumpPos.func_177978_c());
        scene.effects.rotationSpeedIndicator(pumpPos.func_177968_d());
        scene.world.propagatePipeChange(pumpPos);
        scene.world.propagatePipeChange(pumpPos.func_177978_c());
        scene.world.propagatePipeChange(pumpPos.func_177968_d());
    }
}

