/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.elements;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllItems;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.GuiGameElement;
import com.simibubi.create.foundation.ponder.PonderLocalization;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.PonderUI;
import com.simibubi.create.foundation.ponder.content.PonderPalette;
import com.simibubi.create.foundation.ponder.elements.AnimatedOverlayElement;
import com.simibubi.create.foundation.utility.Pointing;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;

public class InputWindowElement
extends AnimatedOverlayElement {
    private Pointing direction;
    ResourceLocation key;
    AllIcons icon;
    ItemStack item = ItemStack.field_190927_a;
    private Vector3d sceneSpace;

    public InputWindowElement clone() {
        InputWindowElement inputWindowElement = new InputWindowElement(this.sceneSpace, this.direction);
        inputWindowElement.key = this.key;
        inputWindowElement.icon = this.icon;
        inputWindowElement.item = this.item.func_77946_l();
        return inputWindowElement;
    }

    public InputWindowElement(Vector3d sceneSpace, Pointing direction) {
        this.sceneSpace = sceneSpace;
        this.direction = direction;
    }

    public InputWindowElement withItem(ItemStack stack) {
        this.item = stack;
        return this;
    }

    public InputWindowElement withWrench() {
        this.item = AllItems.WRENCH.asStack();
        return this;
    }

    public InputWindowElement scroll() {
        this.icon = AllIcons.I_SCROLL;
        return this;
    }

    public InputWindowElement rightClick() {
        this.icon = AllIcons.I_RMB;
        return this;
    }

    public InputWindowElement showing(AllIcons icon) {
        this.icon = icon;
        return this;
    }

    public InputWindowElement leftClick() {
        this.icon = AllIcons.I_LMB;
        return this;
    }

    public InputWindowElement whileSneaking() {
        this.key = Create.asResource("sneak_and");
        return this;
    }

    public InputWindowElement whileCTRL() {
        this.key = Create.asResource("ctrl_and");
        return this;
    }

    @Override
    protected void render(PonderScene scene, PonderUI screen, MatrixStack ms, float partialTicks, float fade) {
        String text;
        float xFade;
        FontRenderer font = screen.getFontRenderer();
        int width = 0;
        int height = 0;
        float f = this.direction == Pointing.RIGHT ? -1.0f : (xFade = this.direction == Pointing.LEFT ? 1.0f : 0.0f);
        float yFade = this.direction == Pointing.DOWN ? -1.0f : (this.direction == Pointing.UP ? 1.0f : 0.0f);
        xFade *= 10.0f * (1.0f - fade);
        yFade *= 10.0f * (1.0f - fade);
        boolean hasItem = !this.item.func_190926_b();
        boolean hasText = this.key != null;
        boolean hasIcon = this.icon != null;
        int keyWidth = 0;
        String string = text = hasText ? PonderLocalization.getShared(this.key) : "";
        if (fade < 0.0625f) {
            return;
        }
        Vector2f sceneToScreen = scene.getTransform().sceneToScreen(this.sceneSpace, partialTicks);
        if (hasIcon) {
            width += 24;
            height = 24;
        }
        if (hasText) {
            keyWidth = font.func_78256_a(text);
            width += keyWidth;
        }
        if (hasItem) {
            width += 24;
            height = 24;
        }
        ms.func_227860_a_();
        ms.func_227861_a_((double)(sceneToScreen.field_189982_i + xFade), (double)(sceneToScreen.field_189983_j + yFade), 400.0);
        PonderUI.renderSpeechBox(ms, 0, 0, width, height, false, this.direction, true);
        ms.func_227861_a_(0.0, 0.0, 100.0);
        if (hasText) {
            font.getClass();
            font.func_238421_b_(ms, text, 2.0f, (float)(height - 9) / 2.0f + 2.0f, PonderPalette.WHITE.getColorObject().scaleAlpha(fade).getRGB());
        }
        if (hasIcon) {
            ms.func_227860_a_();
            ms.func_227861_a_((double)keyWidth, 0.0, 0.0);
            ms.func_227862_a_(1.5f, 1.5f, 1.5f);
            this.icon.draw(ms, (AbstractGui)screen, 0, 0);
            ms.func_227865_b_();
        }
        if (hasItem) {
            ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of(this.item).at(keyWidth + (hasIcon ? 24 : 0), 0.0f)).scale(1.5).render(ms);
            RenderSystem.disableDepthTest();
        }
        ms.func_227865_b_();
    }
}

