/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.inventory;

import com.google.common.base.Predicates;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.inventory.CapManipulationBehaviourBase;
import java.util.function.Predicate;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TankManipulationBehaviour
extends CapManipulationBehaviourBase<IFluidHandler, TankManipulationBehaviour> {
    public static BehaviourType<TankManipulationBehaviour> OBSERVE = new BehaviourType();
    private BehaviourType<TankManipulationBehaviour> behaviourType;

    public TankManipulationBehaviour(SmartTileEntity te, CapManipulationBehaviourBase.InterfaceProvider target) {
        this(OBSERVE, te, target);
    }

    private TankManipulationBehaviour(BehaviourType<TankManipulationBehaviour> type, SmartTileEntity te, CapManipulationBehaviourBase.InterfaceProvider target) {
        super(te, target);
        this.behaviourType = type;
    }

    public FluidStack extractAny() {
        if (!this.hasInventory()) {
            return FluidStack.EMPTY;
        }
        IFluidHandler inventory = (IFluidHandler)this.getInventory();
        Predicate<FluidStack> filterTest = this.getFilterTest((Predicate<FluidStack>)Predicates.alwaysTrue());
        for (int i = 0; i < inventory.getTanks(); ++i) {
            FluidStack drained;
            FluidStack fluidInTank = inventory.getFluidInTank(i);
            if (fluidInTank.isEmpty() || !filterTest.test(fluidInTank) || (drained = inventory.drain(fluidInTank, this.simulateNext ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE)).isEmpty()) continue;
            return drained;
        }
        return FluidStack.EMPTY;
    }

    protected Predicate<FluidStack> getFilterTest(Predicate<FluidStack> customFilter) {
        Predicate<FluidStack> test = customFilter;
        FilteringBehaviour filter = this.tileEntity.getBehaviour(FilteringBehaviour.TYPE);
        if (filter != null) {
            test = customFilter.and(filter::test);
        }
        return test;
    }

    @Override
    protected Capability<IFluidHandler> capability() {
        return CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public BehaviourType<?> getType() {
        return this.behaviourType;
    }
}

