/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.linked;

import com.simibubi.create.AllItems;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.linked.LinkBehaviour;
import com.simibubi.create.foundation.utility.RaycastHelper;
import java.util.Arrays;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class LinkHandler {
    @SubscribeEvent
    public static void onBlockActivated(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        PlayerEntity player = event.getPlayer();
        Hand hand = event.getHand();
        if (player.func_225608_bj_() || player.func_175149_v()) {
            return;
        }
        LinkBehaviour behaviour = TileEntityBehaviour.get((IBlockReader)world, pos, LinkBehaviour.TYPE);
        if (behaviour == null) {
            return;
        }
        ItemStack heldItem = player.func_184586_b(hand);
        BlockRayTraceResult ray = RaycastHelper.rayTraceRange(world, player, 10.0);
        if (ray == null) {
            return;
        }
        if (AllItems.LINKED_CONTROLLER.isIn(heldItem)) {
            return;
        }
        if (AllItems.WRENCH.isIn(heldItem)) {
            return;
        }
        for (boolean first : Arrays.asList(false, true)) {
            if (!behaviour.testHit(first, ray.func_216347_e())) continue;
            if (event.getSide() != LogicalSide.CLIENT) {
                behaviour.setFrequency(first, heldItem);
            }
            event.setCanceled(true);
            event.setCancellationResult(ActionResultType.SUCCESS);
            world.func_184133_a(null, pos, SoundEvents.field_187620_cL, SoundCategory.BLOCKS, 0.25f, 0.1f);
        }
    }
}

