/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility.animation;

import com.simibubi.create.foundation.utility.AngleHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;

public class LerpedFloat {
    Interpolater interpolater;
    float previousValue;
    float value;
    Chaser chaseFunction;
    float chaseTarget;
    float chaseSpeed;
    boolean forcedSync;

    public LerpedFloat(Interpolater interpolater) {
        this.interpolater = interpolater;
        this.startWithValue(0.0);
        this.forcedSync = true;
    }

    public static LerpedFloat linear() {
        return new LerpedFloat((p, c, t) -> (float)MathHelper.func_219803_d((double)p, (double)c, (double)t));
    }

    public static LerpedFloat angular() {
        return new LerpedFloat(AngleHelper::angleLerp);
    }

    public LerpedFloat startWithValue(double value) {
        float f;
        this.previousValue = f = (float)value;
        this.chaseTarget = f;
        this.value = f;
        return this;
    }

    public LerpedFloat chase(double value, double speed, Chaser chaseFunction) {
        this.chaseTarget = (float)value;
        this.chaseSpeed = (float)speed;
        this.chaseFunction = chaseFunction;
        return this;
    }

    public void updateChaseTarget(float target) {
        this.chaseTarget = target;
    }

    public boolean updateChaseSpeed(double speed) {
        float prevSpeed = this.chaseSpeed;
        this.chaseSpeed = (float)speed;
        return !MathHelper.func_219806_b((double)prevSpeed, (double)speed);
    }

    public void tickChaser() {
        this.previousValue = this.value;
        if (this.chaseFunction == null) {
            return;
        }
        if (MathHelper.func_219806_b((double)this.value, (double)this.chaseTarget)) {
            this.value = this.chaseTarget;
            return;
        }
        this.value = this.chaseFunction.chase(this.value, this.chaseSpeed, this.chaseTarget);
    }

    public void setValue(double value) {
        this.previousValue = this.value;
        this.value = (float)value;
    }

    public float getValue() {
        return this.getValue(1.0f);
    }

    public float getValue(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.previousValue, (float)this.value);
    }

    public boolean settled() {
        return MathHelper.func_219806_b((double)this.previousValue, (double)this.value);
    }

    public float getChaseTarget() {
        return this.chaseTarget;
    }

    public void forceNextSync() {
        this.forcedSync = true;
    }

    public CompoundNBT writeNBT() {
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_74776_a("Speed", this.chaseSpeed);
        compoundNBT.func_74776_a("Target", this.chaseTarget);
        compoundNBT.func_74776_a("Value", this.value);
        if (this.forcedSync) {
            compoundNBT.func_74757_a("Force", true);
        }
        this.forcedSync = false;
        return compoundNBT;
    }

    public void readNBT(CompoundNBT compoundNBT, boolean clientPacket) {
        if (!clientPacket || compoundNBT.func_74764_b("Force")) {
            this.startWithValue(compoundNBT.func_74760_g("Value"));
        }
        this.readChaser(compoundNBT);
    }

    private void readChaser(CompoundNBT compoundNBT) {
        this.chaseSpeed = compoundNBT.func_74760_g("Speed");
        this.chaseTarget = compoundNBT.func_74760_g("Target");
    }

    @FunctionalInterface
    public static interface Chaser {
        public static final Chaser IDLE = (c, s, t) -> (float)c;
        public static final Chaser EXP = Chaser.exp(Double.MAX_VALUE);
        public static final Chaser LINEAR = (c, s, t) -> (float)(c + MathHelper.func_151237_a((double)(t - c), (double)(-s), (double)s));

        public static Chaser exp(double maxEffectiveSpeed) {
            return (c, s, t) -> (float)(c + MathHelper.func_151237_a((double)((t - c) * s), (double)(-maxEffectiveSpeed), (double)maxEffectiveSpeed));
        }

        public float chase(double var1, double var3, double var5);
    }

    @FunctionalInterface
    public static interface Interpolater {
        public float interpolate(double var1, double var3, double var5);
    }
}

