/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.core;

import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import me.ichun.mods.ichunutil.client.core.ResourceHelper;
import me.ichun.mods.ichunutil.client.gui.bns.Theme;
import me.ichun.mods.ichunutil.client.gui.bns.window.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.window.WindowPopup;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.Constraint;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.IConstrainable;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.IConstrained;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.Element;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementButton;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementDropdownContextMenu;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementList;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementPadding;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementTextWrapper;
import me.ichun.mods.ichunutil.client.gui.config.WorkspaceConfigs;
import me.ichun.mods.ichunutil.common.config.ConfigBase;
import me.ichun.mods.ichunutil.common.config.annotations.CategoryDivider;
import me.ichun.mods.ichunutil.common.config.annotations.Prop;
import me.ichun.mods.ichunutil.common.head.HeadHandler;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.common.util.IOUtil;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.config.ModConfig;

public class ConfigClient
extends ConfigBase {
    @CategoryDivider(name="bns")
    @Prop(min=0.0, max=2.0)
    public int guiMinecraftStyle = 0;
    @Prop(min=0.0, max=50.0)
    public int guiDockPadding = 0;
    @Prop(min=0.0)
    public int guiTooltipCooldown = 10;
    @Prop(min=1.0)
    public int guiDockBorder = 8;
    @Prop(min=1.0)
    public int guiDoubleClickSpeed = 10;
    @Prop(guiElementOverride="iChunUtil:guiDefaultTheme")
    public String guiDefaultTheme = "default";
    @CategoryDivider(name="clientOnly")
    public boolean easterEgg = true;
    public boolean buttonOptionsShiftOpensMods = true;
    @Prop(needsRestart=true)
    public boolean overrideToastGui = true;
    @CategoryDivider(name="headTracking")
    @Prop(min=0.0, max=2.0)
    public int aggressiveHeadTracking = 1;
    @Prop(guiElementOverride="iChunUtil:reloadHeadsButton")
    public boolean horseEasterEgg = true;

    @Override
    public <T extends ConfigBase> T init() {
        GUI_ELEMENT_OVERRIDES.put("iChunUtil:guiDefaultTheme", (value, item) -> {
            Object o;
            Field field = value.value.field;
            field.setAccessible(true);
            try {
                o = field.get(value.value.parent);
            }
            catch (IllegalAccessException e) {
                iChunUtil.LOGGER.error("Error accessing config field {} when creating config. Stopping config creation.", (Object)field.getName());
                e.printStackTrace();
                return true;
            }
            ArrayList<File> files = new ArrayList<File>();
            File[] themes = ResourceHelper.getThemesDir().toFile().listFiles();
            if (themes != null) {
                for (File file : themes) {
                    if (file.isDirectory() || !file.getName().endsWith(".json")) continue;
                    files.add(file);
                }
            }
            Collections.sort(files);
            ElementDropdownContextMenu input = new ElementDropdownContextMenu((Fragment)item, o.toString(), (List<?>)files, (menu, listItem) -> {
                if (listItem.selected) {
                    ElementDropdownContextMenu contextMenu = (ElementDropdownContextMenu)menu;
                    File file = (File)listItem.getObject();
                    contextMenu.text = file.getName().substring(0, file.getName().length() - 5);
                    try {
                        FileInputStream con = new FileInputStream(file);
                        String data = new String(ByteStreams.toByteArray((InputStream)con));
                        ((InputStream)con).close();
                        Theme theme = (Theme)new Gson().fromJson(data, Theme.class);
                        if (theme != null) {
                            field.set(value.value.parent, contextMenu.text);
                            Theme.loadTheme(theme);
                        }
                    }
                    catch (IOException | IllegalAccessException exception) {
                        // empty catch block
                    }
                }
            }).setNameProvider(o1 -> ((File)o1).getName().substring(0, ((File)o1).getName().length() - 5));
            input.setSize(80, 14);
            input.setConstraint(new Constraint(input).top((IConstrainable)item, Constraint.Property.Type.TOP, 3).bottom((IConstrainable)item, Constraint.Property.Type.BOTTOM, 3).right((IConstrainable)item, Constraint.Property.Type.RIGHT, 8));
            item.addElement(input);
            return true;
        });
        GUI_ELEMENT_OVERRIDES.put("iChunUtil:reloadHeadsButton", (value, itemOri) -> {
            ElementList.Item<WorkspaceConfigs.ConfigInfo.ValueWrapperLocalised> item = ((ElementList)itemOri.parentFragment).addItem(value).setBorderSize(0);
            item.setSelectionHandler(itemObj -> {
                if (itemObj.selected) {
                    for (Element<?> element : itemObj.elements) {
                        if (element instanceof ElementTextWrapper || element instanceof ElementPadding) continue;
                        element.parentFragment.func_231035_a_((IGuiEventListener)element);
                        element.func_231044_a_((double)element.getLeft() + (double)element.getWidth() / 2.0, (double)element.getTop() + (double)element.getHeight() / 2.0, 0);
                        element.func_231048_c_((double)element.getLeft() + (double)element.getWidth() / 2.0, (double)element.getTop() + (double)element.getHeight() / 2.0, 0);
                        break;
                    }
                }
            });
            Object wrapper = new ElementTextWrapper(item).setText(I18n.func_135052_a((String)"config.ichunutil.headTracking.reload.desc", (Object[])new Object[0]));
            ((Fragment)wrapper).setConstraint(new Constraint((IConstrained)wrapper).left(item, Constraint.Property.Type.LEFT, 3).right(item, Constraint.Property.Type.RIGHT, 90));
            ((Element)wrapper).setTooltip(value.desc);
            item.addElement((Element<?>)wrapper);
            ElementPadding padding = new ElementPadding(item, 0, 20);
            padding.setConstraint(new Constraint(padding).right(item, Constraint.Property.Type.RIGHT, 0));
            item.addElement(padding);
            ElementButton<ElementButton> button = new ElementButton<ElementButton>(item, "config.ichunutil.headTracking.reload.btn", btn -> {
                if (HeadHandler.hasInit()) {
                    int count = HeadHandler.loadHeadInfos();
                    WindowPopup.popup(item.getWorkspace(), 0.6, 0.6, null, new String[]{I18n.func_135052_a((String)"config.ichunutil.headTracking.reload.count", (Object[])new Object[]{count})});
                } else {
                    WindowPopup.popup(item.getWorkspace(), 0.6, 0.6, null, new String[]{I18n.func_135052_a((String)"config.ichunutil.headTracking.notLoaded", (Object[])new Object[0])});
                }
            });
            button.setTooltip(I18n.func_135052_a((String)"config.ichunutil.headTracking.reload.desc", (Object[])new Object[0]));
            button.setSize(80, 14);
            button.setConstraint(new Constraint(button).top(item, Constraint.Property.Type.TOP, 3).bottom(item, Constraint.Property.Type.BOTTOM, 3).right(item, Constraint.Property.Type.RIGHT, 8));
            item.addElement(button);
            ElementButton<ElementButton> button1 = new ElementButton<ElementButton>(item, "config.ichunutil.headTracking.reload.reextract", btn -> {
                try {
                    if (HeadHandler.hasInit()) {
                        InputStream in = iChunUtil.class.getResourceAsStream("/heads.zip");
                        if (in != null) {
                            int extCount = IOUtil.extractFiles(HeadHandler.getHeadsDir(), in, true);
                            HeadHandler.loadHeadInfos();
                            WindowPopup.popup(item.getWorkspace(), 0.6, 0.6, null, new String[]{I18n.func_135052_a((String)"config.ichunutil.headTracking.reload.reextract.count", (Object[])new Object[]{extCount})});
                        } else {
                            iChunUtil.LOGGER.error("Error extracting heads.zip.");
                            WindowPopup.popup(item.getWorkspace(), 0.6, 0.6, null, new String[]{"Error!", "Error extracting heads.zip."});
                        }
                    } else {
                        WindowPopup.popup(item.getWorkspace(), 0.6, 0.6, null, new String[]{I18n.func_135052_a((String)"config.ichunutil.headTracking.notLoaded", (Object[])new Object[0])});
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            button1.setTooltip(I18n.func_135052_a((String)"config.ichunutil.headTracking.reload.reextract.desc", (Object[])new Object[0]));
            button1.setSize(80, 14);
            button1.setConstraint(new Constraint(button1).top(item, Constraint.Property.Type.TOP, 3).bottom(item, Constraint.Property.Type.BOTTOM, 3).right(button, Constraint.Property.Type.LEFT, 4));
            item.addElement(button1);
            return false;
        });
        return super.init();
    }

    @Override
    public void onConfigLoaded() {
        File file = new File(ResourceHelper.getThemesDir().toFile(), this.guiDefaultTheme + ".json");
        if (file.exists()) {
            try {
                FileInputStream con = new FileInputStream(file);
                String data = new String(ByteStreams.toByteArray((InputStream)con));
                ((InputStream)con).close();
                Theme theme = (Theme)new Gson().fromJson(data, Theme.class);
                if (theme != null) {
                    Theme.loadTheme(theme);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    @Nonnull
    public String getModId() {
        return "ichunutil";
    }

    @Override
    @Nonnull
    public String getConfigName() {
        return "iChunUtil";
    }

    @Override
    @Nonnull
    public ModConfig.Type getConfigType() {
        return ModConfig.Type.CLIENT;
    }
}

