/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.pickupnotifier.client.gui.entry;

import com.fuzs.pickupnotifier.client.gui.entry.DisplayEntry;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.item.Rarity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;

public class ExperienceDisplayEntry
extends DisplayEntry {
    private static final ResourceLocation EXPERIENCE_ORB_TEXTURES = new ResourceLocation("textures/entity/experience_orb.png");
    private final ITextComponent name;

    public ExperienceDisplayEntry(ExperienceOrbEntity orb) {
        this(orb.func_200200_C_(), orb.field_70530_e);
    }

    private ExperienceDisplayEntry(ITextComponent name, int count) {
        super(count, Rarity.COMMON);
        this.name = name;
    }

    @Override
    protected ITextComponent getName() {
        return this.name;
    }

    @Override
    public boolean canMerge(DisplayEntry entry) {
        return entry instanceof ExperienceDisplayEntry;
    }

    @Override
    protected void renderSprite(MatrixStack matrixstack, int posX, int posY) {
        int i = this.getTextureForCount();
        int x = i % 4 * 16;
        int y = i / 4 * 16;
        float color = this.getLife() / 4.0f;
        float r = (MathHelper.func_76126_a((float)color) + 1.0f) * 0.5f;
        float g = 1.0f;
        float b = (MathHelper.func_76126_a((float)(color + 4.1887903f)) + 1.0f) * 0.1f;
        this.mc.func_110434_K().func_110577_a(EXPERIENCE_ORB_TEXTURES);
        RenderSystem.enableBlend();
        RenderSystem.color4f((float)r, (float)g, (float)b, (float)1.0f);
        AbstractGui.func_238463_a_((MatrixStack)matrixstack, (int)posX, (int)posY, (float)x, (float)y, (int)16, (int)16, (int)64, (int)64);
        RenderSystem.disableBlend();
    }

    private int getTextureForCount() {
        if (this.count >= 2477) {
            return 10;
        }
        if (this.count >= 1237) {
            return 9;
        }
        if (this.count >= 617) {
            return 8;
        }
        if (this.count >= 307) {
            return 7;
        }
        if (this.count >= 149) {
            return 6;
        }
        if (this.count >= 73) {
            return 5;
        }
        if (this.count >= 37) {
            return 4;
        }
        if (this.count >= 17) {
            return 3;
        }
        if (this.count >= 7) {
            return 2;
        }
        return this.count >= 3 ? 1 : 0;
    }
}

