/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.module.config.type;

import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.util.math.BlockPos;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.type.AbstractConfigType;

public class OrePocketConfig
extends AbstractConfigType {
    @Config
    @Config.Min(value=0.0)
    @Config.Max(value=255.0)
    private int minHeight;
    @Config
    @Config.Min(value=0.0)
    @Config.Max(value=255.0)
    private int maxHeight;
    @Config
    @Config.Min(value=0.0)
    public int clusterSize;
    @Config
    @Config.Min(value=0.0)
    public int clusterCount;

    public OrePocketConfig(int minHeight, int maxHeight, int clusterSize, int clusterCount) {
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.clusterSize = clusterSize;
        this.clusterCount = clusterCount;
    }

    public int getRandomHeight(Random rand) {
        return this.minHeight + rand.nextInt(this.maxHeight - this.minHeight);
    }

    public void forEach(BlockPos chunkCorner, Random rand, Consumer<BlockPos> callback) {
        for (int i = 0; i < this.clusterCount; ++i) {
            int x = chunkCorner.func_177958_n() + rand.nextInt(16);
            int y = this.getRandomHeight(rand);
            int z = chunkCorner.func_177952_p() + rand.nextInt(16);
            callback.accept(new BlockPos(x, y, z));
        }
    }
}

