/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.world.generator.multichunk;

import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import vazkii.quark.base.handler.GeneralConfig;
import vazkii.quark.base.module.config.type.ClusterSizeConfig;
import vazkii.quark.base.module.config.type.IBiomeConfig;

public class ClusterShape {
    private final BlockPos src;
    private final Vector3d radius;
    private final PerlinNoiseGenerator noiseGenerator;

    public ClusterShape(BlockPos src, Vector3d radius, PerlinNoiseGenerator noiseGenerator) {
        this.src = src;
        this.radius = radius;
        this.noiseGenerator = noiseGenerator;
    }

    public boolean isInside(BlockPos pos) {
        return this.noiseDiff(pos) > 0.0;
    }

    public double noiseDiff(BlockPos pos) {
        double dz;
        double dy;
        double dx = (double)(pos.func_177958_n() - this.src.func_177958_n()) / this.radius.field_72450_a;
        double r = Math.sqrt(dx * dx + (dy = (double)(pos.func_177956_o() - this.src.func_177956_o()) / this.radius.field_72448_b) * dy + (dz = (double)(pos.func_177952_p() - this.src.func_177952_p()) / this.radius.field_72449_c) * dz);
        if (r > 1.0) {
            return -1.0;
        }
        if (GeneralConfig.useFastWorldgen) {
            return 1.0;
        }
        double phi = Math.atan2(dz, dx);
        double theta = r == 0.0 ? 0.0 : Math.acos(dy / r);
        double xn = phi + (double)this.src.func_177958_n();
        double yn = theta + (double)this.src.func_177952_p();
        double noise = this.noiseGenerator.func_215464_a(xn, yn, false);
        double cutoff = 2.356194490192345;
        if (phi > cutoff) {
            double noise0 = this.noiseGenerator.func_215464_a(-Math.PI + (double)this.src.func_177958_n(), yn, false);
            noise = MathHelper.func_219803_d((double)((phi - cutoff) / (Math.PI - cutoff)), (double)noise, (double)noise0);
        }
        double maxR = noise + 0.5;
        return maxR - r;
    }

    public int getUpperBound() {
        return (int)Math.ceil((double)this.src.func_177956_o() + this.radius.func_82617_b());
    }

    public int getLowerBound() {
        return (int)Math.floor((double)this.src.func_177956_o() - this.radius.func_82617_b());
    }

    public static class Provider {
        private final ClusterSizeConfig config;
        private final PerlinNoiseGenerator noiseGenerator;

        public Provider(ClusterSizeConfig config, long seed) {
            this.config = config;
            this.noiseGenerator = new PerlinNoiseGenerator(new SharedSeedRandom(seed), IntStream.rangeClosed(-4, 4));
        }

        public ClusterShape around(BlockPos src) {
            Random rand = this.randAroundBlockPos(src);
            int radiusX = this.config.horizontalSize + rand.nextInt(this.config.horizontalVariation);
            int radiusY = this.config.verticalSize + rand.nextInt(this.config.verticalVariation);
            int radiusZ = this.config.horizontalSize + rand.nextInt(this.config.horizontalVariation);
            return new ClusterShape(src, new Vector3d((double)radiusX, (double)radiusY, (double)radiusZ), this.noiseGenerator);
        }

        public int getRadius() {
            return this.config.horizontalSize + this.config.horizontalVariation;
        }

        public int getRarity() {
            return this.config.rarity;
        }

        public int getRandomYLevel(Random rand) {
            return this.config.minYLevel + (this.config.minYLevel == this.config.maxYLevel ? 0 : rand.nextInt(Math.max(this.config.maxYLevel, this.config.minYLevel) - Math.min(this.config.maxYLevel, this.config.minYLevel)));
        }

        public IBiomeConfig getBiomeTypes() {
            return this.config.biomes;
        }

        public Random randAroundBlockPos(BlockPos pos) {
            return new Random(31 * (31 * (31 + pos.func_177958_n()) + pos.func_177956_o()) + pos.func_177952_p());
        }
    }
}

