/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tools.module;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.content.tools.client.render.PickarangRenderer;
import vazkii.quark.content.tools.entity.PickarangEntity;
import vazkii.quark.content.tools.item.PickarangItem;

@LoadModule(category=ModuleCategory.TOOLS, hasSubscriptions=true)
public class PickarangModule
extends QuarkModule {
    public static EntityType<PickarangEntity> pickarangType;
    @Config(description="How long it takes before the pickarang starts returning to the player if it doesn't hit anything.")
    public static int timeout;
    @Config(description="2 is Iron, 3 is Diamond.")
    public static int harvestLevel;
    @Config(description="2 is Iron, 3 is Diamond.")
    public static int netheriteHarvestLevel;
    @Config(description="Set to -1 to have the Pickarang be unbreakable.")
    public static int durability;
    @Config(description="Set to -1 to have the Flamerang be unbreakable.")
    public static int netheriteDurability;
    @Config(description="22.5 is ender chests, 25.0 is monster boxes, 50 is obsidian. Most things are below 5.")
    public static double maxHardness;
    @Config(description="Set this to true to use the recipe without the Heart of Diamond, even if the Heart of Diamond is enabled.", flag="pickarang_never_uses_heart")
    public static boolean neverUseHeartOfDiamond;
    @Config(description="Set this to true to disable the short cooldown between throwing pickarangs.")
    public static boolean noCooldown;
    public static Item pickarang;
    public static Item flamerang;
    private static boolean isEnabled;
    private static final ThreadLocal<PickarangEntity> ACTIVE_PICKARANG;

    @Override
    public void construct() {
        pickarangType = EntityType.Builder.func_220322_a(PickarangEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.4f, 0.4f).func_233606_a_(4).func_233608_b_(10).setCustomClientFactory((spawnEntity, world) -> new PickarangEntity((EntityType<? extends PickarangEntity>)pickarangType, (World)world)).func_206830_a("pickarang");
        RegistryHelper.register(pickarangType, (String)"pickarang");
        pickarang = new PickarangItem("pickarang", this, PickarangModule.propertiesFor(harvestLevel, durability, false), false);
        flamerang = new PickarangItem("flamerang", this, PickarangModule.propertiesFor(netheriteHarvestLevel, netheriteDurability, true), true);
    }

    private static Item.Properties propertiesFor(int level, int durability, boolean netherite) {
        Item.Properties properties = new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78040_i).addToolType(ToolType.PICKAXE, harvestLevel).addToolType(ToolType.AXE, harvestLevel).addToolType(ToolType.SHOVEL, harvestLevel);
        if (durability > 0) {
            properties.func_200918_c(durability);
        }
        if (netherite) {
            properties.func_234689_a_();
        }
        return properties;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        RenderingRegistry.registerEntityRenderingHandler(pickarangType, PickarangRenderer::new);
    }

    @Override
    public void configChanged() {
        isEnabled = this.enabled;
    }

    public static void setActivePickarang(PickarangEntity pickarang) {
        ACTIVE_PICKARANG.set(pickarang);
    }

    public static DamageSource createDamageSource(PlayerEntity player) {
        PickarangEntity pickarang = ACTIVE_PICKARANG.get();
        if (pickarang == null) {
            return null;
        }
        return new IndirectEntityDamageSource("player", (Entity)pickarang, (Entity)player).func_76349_b();
    }

    public static boolean getIsFireResistant(boolean vanillaVal, Entity entity) {
        if (!isEnabled || vanillaVal) {
            return vanillaVal;
        }
        Entity riding = entity.func_184187_bx();
        if (riding instanceof PickarangEntity) {
            return ((PickarangEntity)riding).netherite;
        }
        return false;
    }

    static {
        timeout = 20;
        harvestLevel = 3;
        netheriteHarvestLevel = 3;
        durability = 800;
        netheriteDurability = 1040;
        maxHardness = 20.0;
        neverUseHeartOfDiamond = false;
        noCooldown = false;
        ACTIVE_PICKARANG = new ThreadLocal();
    }
}

