/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.module.underground;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.BeaconTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.common.BiomeDictionary;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.quark.api.IIndirectConnector;
import vazkii.quark.base.block.QuarkInheritedPaneBlock;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.content.world.block.CaveCrystalBlock;
import vazkii.quark.content.world.block.CaveCrystalClusterBlock;
import vazkii.quark.content.world.config.UndergroundBiomeConfig;
import vazkii.quark.content.world.gen.underground.CaveCrystalUndergroundBiome;
import vazkii.quark.content.world.gen.underground.UndergroundBiome;
import vazkii.quark.content.world.module.underground.UndergroundBiomeModule;

@LoadModule(category=ModuleCategory.WORLD)
public class CaveCrystalUndergroundBiomeModule
extends UndergroundBiomeModule {
    @Config
    @Config.Min(value=0.0)
    @Config.Max(value=1.0)
    public static double crystalChance = 0.16;
    @Config
    @Config.Min(value=0.0)
    @Config.Max(value=1.0)
    public static double crystalClusterChance = 0.2;
    @Config
    @Config.Min(value=0.0)
    @Config.Max(value=1.0)
    public static double crystalClusterOnSidesChance = 0.6;
    @Config
    @Config.Min(value=0.0)
    @Config.Max(value=1.0)
    public static double doubleCrystalChance = 0.2;
    @Config(description="The chance that a crystal can grow, this is on average 1 in X world ticks, set to a higher value to make them grow slower. Minimum is 1, for every tick. Set to 0 to disable growth.")
    public static int caveCrystalGrowthChance = 5;
    @Config(flag="cave_crystal_runes")
    public static boolean crystalsCraftRunes = true;
    @Config
    public static boolean enableBeaconRedirection = true;
    @Config
    public static boolean enableCollateralMovement = true;
    public static boolean staticEnabled;
    public static List<CaveCrystalBlock> crystals;
    public static ITag<Block> crystalTag;

    public static Block crystal(int floorIdx) {
        return (Block)crystals.get(MathHelper.func_76125_a((int)floorIdx, (int)0, (int)(crystals.size() - 1)));
    }

    @Override
    public void construct() {
        this.crystal("red", 0xFF0000, MaterialColor.field_151645_D);
        this.crystal("orange", 0xFF8000, MaterialColor.field_151676_q);
        this.crystal("yellow", 0xFFFF00, MaterialColor.field_151673_t);
        this.crystal("green", 65280, MaterialColor.field_151651_C);
        this.crystal("blue", 65535, MaterialColor.field_151674_s);
        this.crystal("indigo", 255, MaterialColor.field_151649_A);
        this.crystal("violet", 0xFF00FF, MaterialColor.field_151675_r);
        this.crystal("white", 0xFFFFFF, MaterialColor.field_151666_j);
        this.crystal("black", 0, MaterialColor.field_151646_E);
        super.construct();
    }

    private void crystal(String name, int color, MaterialColor material) {
        CaveCrystalBlock crystal = new CaveCrystalBlock(name + "_crystal", color, this, material, false);
        crystals.add(crystal);
        CaveCrystalBlock waxed = new CaveCrystalBlock("waxed_" + name + "_crystal", color, this, material, true);
        waxed.alternate = crystal;
        crystal.alternate = waxed;
        new QuarkInheritedPaneBlock(crystal);
        CaveCrystalClusterBlock cluster = new CaveCrystalClusterBlock(crystal);
        ClusterConnection connection = new ClusterConnection(cluster);
        IIndirectConnector.INDIRECT_STICKY_BLOCKS.add((Pair<Predicate<BlockState>, IIndirectConnector>)Pair.of(x$0 -> connection.isValidState(x$0), (Object)connection));
    }

    @Override
    public void setup() {
        super.setup();
        crystalTag = BlockTags.createOptional((ResourceLocation)new ResourceLocation("quark", "crystal"));
    }

    @Override
    public void configChanged() {
        staticEnabled = this.enabled;
    }

    @Override
    protected String getBiomeName() {
        return "crystal";
    }

    @Override
    protected UndergroundBiomeConfig getBiomeConfig() {
        return new UndergroundBiomeConfig((UndergroundBiome)new CaveCrystalUndergroundBiome(), 400, true, BiomeDictionary.Type.OCEAN).setDefaultSize(42, 18, 22, 8);
    }

    public static int tickBeacon(BeaconTileEntity beacon) {
        BlockPos beaconPos;
        if (!staticEnabled || !enableBeaconRedirection) {
            return 0;
        }
        World world = beacon.func_145831_w();
        BlockPos currPos = beaconPos = beacon.func_174877_v();
        int horizontalMoves = 64;
        int targetHeight = world.func_201676_a(Heightmap.Type.WORLD_SURFACE, beaconPos.func_177958_n(), beaconPos.func_177952_p());
        beacon.field_213934_g.clear();
        boolean broke = false;
        float[] currColor = new float[]{1.0f, 1.0f, 1.0f};
        ExtendedBeamSegment currSegment = new ExtendedBeamSegment(Direction.UP, Vector3i.field_177959_e, currColor);
        LinkedList<BlockPos> seenPositions = new LinkedList<BlockPos>();
        boolean check = true;
        boolean setColor = false;
        while (currPos.func_177956_o() < 256 && currPos.func_177956_o() > 0 && horizontalMoves > 0) {
            currPos = currPos.func_177972_a(currSegment.dir);
            if (currSegment.dir.func_176740_k().func_176722_c()) {
                --horizontalMoves;
            }
            BlockState blockstate = world.func_180495_p(currPos);
            Block block = blockstate.func_177230_c();
            float[] targetColor = blockstate.getBeaconColorMultiplier((IWorldReader)world, currPos, beaconPos);
            if (block instanceof CaveCrystalClusterBlock) {
                Direction dir = (Direction)blockstate.func_177229_b(CaveCrystalClusterBlock.FACING);
                if (dir == currSegment.dir) {
                    currSegment.func_177262_a();
                } else {
                    check = true;
                    beacon.field_213934_g.add(currSegment);
                    targetColor = ((CaveCrystalClusterBlock)block).base.colorComponents;
                    if (targetColor[0] == 1.0f && targetColor[1] == 1.0f && targetColor[2] == 1.0f) {
                        targetColor = currColor;
                    }
                    float[] mixedColor = new float[]{(currColor[0] + targetColor[0] * 3.0f) / 4.0f, (currColor[1] + targetColor[1] * 3.0f) / 4.0f, (currColor[2] + targetColor[2] * 3.0f) / 4.0f};
                    currColor = mixedColor;
                    currSegment = new ExtendedBeamSegment(dir, (Vector3i)currPos.func_177973_b((Vector3i)beaconPos), currColor);
                }
            } else if (targetColor != null) {
                if (Arrays.equals(targetColor, currColor)) {
                    currSegment.func_177262_a();
                } else {
                    check = true;
                    beacon.field_213934_g.add(currSegment);
                    float[] mixedColor = new float[]{(currColor[0] + targetColor[0]) / 2.0f, (currColor[1] + targetColor[1]) / 2.0f, (currColor[2] + targetColor[2]) / 2.0f};
                    if (!setColor) {
                        mixedColor = targetColor;
                        setColor = true;
                    }
                    currColor = mixedColor;
                    currSegment = new ExtendedBeamSegment(currSegment.dir, (Vector3i)currPos.func_177973_b((Vector3i)beaconPos), mixedColor);
                }
            } else {
                if (blockstate.func_200016_a((IBlockReader)world, currPos) >= 15 || block == Blocks.field_150357_h) {
                    broke = true;
                    break;
                }
                currSegment.func_177262_a();
            }
            if (!check) continue;
            if (seenPositions.contains(currPos)) {
                broke = true;
                break;
            }
            seenPositions.add(currPos);
        }
        if (horizontalMoves == 0 || currPos.func_177956_o() <= 0) {
            broke = true;
        }
        if (!broke) {
            beacon.field_213934_g.add(currSegment);
            beacon.field_213935_i = targetHeight + 1;
        } else {
            beacon.field_213934_g.clear();
            beacon.field_213935_i = targetHeight;
        }
        return Integer.MAX_VALUE;
    }

    static {
        crystals = Lists.newArrayList();
    }

    public static class ClusterConnection
    implements IIndirectConnector {
        final CaveCrystalClusterBlock cluster;

        public ClusterConnection(CaveCrystalClusterBlock cluster) {
            this.cluster = cluster;
        }

        @Override
        public boolean isEnabled() {
            return enableCollateralMovement;
        }

        private boolean isValidState(BlockState state) {
            return state.func_177230_c() == this.cluster;
        }

        @Override
        public boolean canConnectIndirectly(World world, BlockPos ourPos, BlockPos sourcePos, BlockState ourState, BlockState sourceState) {
            BlockPos offsetPos = ourPos.func_177972_a(((Direction)ourState.func_177229_b(CaveCrystalClusterBlock.FACING)).func_176734_d());
            if (!offsetPos.equals((Object)sourcePos)) {
                return false;
            }
            return sourceState.func_177230_c() == this.cluster.base;
        }
    }

    public static class ExtendedBeamSegment
    extends BeaconTileEntity.BeamSegment {
        public final Direction dir;
        public final Vector3i offset;
        private boolean isTurn = false;

        public ExtendedBeamSegment(Direction dir, Vector3i offset, float[] colorsIn) {
            super(colorsIn);
            this.offset = offset;
            this.dir = dir;
        }

        public void makeTurn() {
            this.isTurn = true;
        }

        public boolean isTurn() {
            return this.isTurn;
        }

        public void func_177262_a() {
            super.func_177262_a();
        }
    }
}

