/*
 * Decompiled with CFR 0.152.
 */
package com.betterinvisibility;

import com.betterinvisibility.BetterInvisibility;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="betterinvisibility", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BetterInvisibilityConfig {
    public static boolean showArmorWeapons;
    public static boolean showParticles;
    public static boolean invisibleToMobs;
    public static int invisibilityRadius;
    public static int proximityDetectionDistance;
    public static boolean sneakWhenClose;
    public static boolean discoveryRemovesInvisibility;
    public static boolean attackRemovesInvisibility;
    public static boolean removeParticlesFromMobs;
    public static boolean blindWhenInvisible;
    public static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == commonSpec) {
            BetterInvisibilityConfig.bakeCommonConfig();
        }
    }

    public static void bakeCommonConfig() {
        showArmorWeapons = (Boolean)BetterInvisibilityConfig.COMMON.showArmorWeapons.get();
        showParticles = (Boolean)BetterInvisibilityConfig.COMMON.showParticles.get();
        invisibleToMobs = (Boolean)BetterInvisibilityConfig.COMMON.invisibleToMobs.get();
        invisibilityRadius = (Integer)BetterInvisibilityConfig.COMMON.invisibilityRadius.get();
        proximityDetectionDistance = (Integer)BetterInvisibilityConfig.COMMON.proximityDetectionDistance.get();
        sneakWhenClose = (Boolean)BetterInvisibilityConfig.COMMON.sneakWhenClose.get();
        discoveryRemovesInvisibility = (Boolean)BetterInvisibilityConfig.COMMON.discoveryRemovesInvisibility.get();
        attackRemovesInvisibility = (Boolean)BetterInvisibilityConfig.COMMON.attackRemovesInvisibility.get();
        removeParticlesFromMobs = (Boolean)BetterInvisibilityConfig.COMMON.removeParticlesFromMobs.get();
        blindWhenInvisible = (Boolean)BetterInvisibilityConfig.COMMON.blindWhenInvisible.get();
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading configEvent) {
        BetterInvisibility.LOGGER.debug("Loaded Better Invisibility config file.", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfig.Reloading configEvent) {
        BetterInvisibility.LOGGER.debug("Better Invisibility config was just changed on the file system.");
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue showArmorWeapons;
        public final ForgeConfigSpec.BooleanValue showParticles;
        public final ForgeConfigSpec.BooleanValue invisibleToMobs;
        public final ForgeConfigSpec.IntValue invisibilityRadius;
        public final ForgeConfigSpec.IntValue proximityDetectionDistance;
        public final ForgeConfigSpec.BooleanValue sneakWhenClose;
        public final ForgeConfigSpec.BooleanValue discoveryRemovesInvisibility;
        public final ForgeConfigSpec.BooleanValue attackRemovesInvisibility;
        public final ForgeConfigSpec.BooleanValue removeParticlesFromMobs;
        public final ForgeConfigSpec.BooleanValue blindWhenInvisible;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Better Invisibility Config Settings").push("common");
            this.showArmorWeapons = builder.comment("Show armor and weapons when invisible (default:false)").define("showArmorWeapons", false);
            this.showParticles = builder.comment("Show invisiblity potion particles (default:false)").define("showParticles", false);
            this.invisibleToMobs = builder.comment("Invisible to Mob AI when invisible (default:true)").define("invisibleToMobs", true);
            this.invisibilityRadius = builder.comment("Radius of Invisibility Effect (default: 30)").defineInRange("invisibilityRadius", 30, 1, 100);
            this.proximityDetectionDistance = builder.comment("Invisiblity detection distance (default: 3)").defineInRange("proximityDetectionDistance", 3, 1, 10);
            this.sneakWhenClose = builder.comment("Can sneak by mobs when inside detection distance (default:true)").define("sneakWhenClose", true);
            this.discoveryRemovesInvisibility = builder.comment("Invisibility effect removed when discovered by Mobs (default:true)").define("discoveryRemovesInvisibility", true);
            this.attackRemovesInvisibility = builder.comment("Invisibility effect removed if Player attacks (default:true)").define("attackRemovesInvisibility", true);
            this.removeParticlesFromMobs = builder.comment("Remove invisibility particles from other mobs (default:true)").define("removeParticlesFromMobs", false);
            this.blindWhenInvisible = builder.comment("Player loses sight when invisible (default:false)").define("blindWhenInvisible", false);
            builder.pop();
        }
    }
}

