/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.crafting.block;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.crafting.block.IBlockIngredientSerializer;
import net.minecraft.block.BlockState;
import net.minecraft.util.ResourceLocation;

public abstract class BlockIngredient
implements Predicate<BlockState> {
    private static final Map<ResourceLocation, IBlockIngredientSerializer<?>> serializers = new ConcurrentHashMap();

    public static void register(IBlockIngredientSerializer<?> serializer, ResourceLocation id) {
        serializers.put(id, serializer);
    }

    @Nullable
    public static IBlockIngredientSerializer<?> getSerializer(ResourceLocation id) {
        return serializers.get(id);
    }

    public abstract Collection<BlockState> getValidStates();

    public BlockState[] getValidStatesArray() {
        return this.getValidStates().toArray(new BlockState[0]);
    }

    public abstract ResourceLocation getSerializeId();
}

