/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.crafting.block;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.darkhax.bookshelf.crafting.block.BlockIngredient;
import net.darkhax.bookshelf.crafting.block.IBlockIngredientSerializer;
import net.darkhax.bookshelf.serialization.Serializers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;

public class BlockIngredientTestState
extends BlockIngredient {
    public static final ResourceLocation ID = new ResourceLocation("bookshelf", "test_state");
    public static final Serializer SERIALIZER = new Serializer();
    private final List<BlockState> validStates;
    private final Map<Property<?>, Object> props;

    public BlockIngredientTestState(List<BlockState> validStates) {
        this(validStates, new HashMap());
    }

    public BlockIngredientTestState(List<BlockState> validStates, Map<Property<?>, Object> props) {
        this.validStates = validStates;
        this.props = props;
    }

    @Override
    public boolean test(BlockState t) {
        return this.validStates.contains(t);
    }

    @Override
    public Collection<BlockState> getValidStates() {
        return this.validStates;
    }

    @Override
    public ResourceLocation getSerializeId() {
        return ID;
    }

    static class Serializer
    implements IBlockIngredientSerializer<BlockIngredientTestState> {
        Serializer() {
        }

        @Override
        public BlockIngredientTestState read(JsonElement json) {
            Block block = Serializers.BLOCK.read(json.getAsJsonObject(), "block");
            JsonObject properties = json.getAsJsonObject().getAsJsonObject("properties");
            ArrayList<BlockState> validStates = new ArrayList<BlockState>();
            HashMap expectedProps = new HashMap();
            for (Map.Entry propValue : properties.entrySet()) {
                Property property = block.func_176194_O().func_185920_a((String)propValue.getKey());
                if (property != null) {
                    Optional value = property.func_185929_b(((JsonElement)propValue.getValue()).getAsString());
                    if (value.isPresent()) {
                        expectedProps.put(property, value.get());
                        continue;
                    }
                    throw new JsonParseException("Could not resolve prop " + (String)propValue.getKey() + " with value " + ((JsonElement)propValue.getValue()).getAsString() + " for block " + block.getRegistryName());
                }
                throw new JsonParseException("Block " + block.getRegistryName() + " has no property " + (String)propValue.getKey());
            }
            for (BlockState state : block.func_176194_O().func_177619_a()) {
                if (!expectedProps.entrySet().stream().allMatch(e -> state.func_177229_b((Property)e.getKey()).equals(e.getValue()))) continue;
                validStates.add(state);
            }
            return new BlockIngredientTestState(validStates, expectedProps);
        }

        @Override
        public JsonElement write(BlockIngredientTestState ingredient) {
            JsonObject obj = new JsonObject();
            obj.add("block", Serializers.BLOCK.write(((BlockState)ingredient.validStates.get(0)).func_177230_c()));
            JsonObject props = new JsonObject();
            obj.add("properties", (JsonElement)props);
            for (Map.Entry propEntry : ingredient.props.entrySet()) {
                props.addProperty(((Property)propEntry.getKey()).func_177701_a(), propEntry.getValue().toString());
            }
            return obj;
        }

        @Override
        public BlockIngredientTestState read(PacketBuffer buf) {
            List<BlockState> states = Serializers.BLOCK_STATE.readList(buf);
            return new BlockIngredientTestState(states);
        }

        @Override
        public void write(PacketBuffer buf, BlockIngredientTestState ingredient) {
            Serializers.BLOCK_STATE.writeList(buf, ingredient.validStates);
        }
    }
}

