/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.lib.function;

import java.util.function.Supplier;

public class NonNullSupplier<T>
implements Supplier<T> {
    private final Supplier<T> internal;
    private final Supplier<String> errorSupplier;

    private NonNullSupplier(Supplier<T> internal, Supplier<String> errorSupplier) {
        this.internal = internal;
        this.errorSupplier = errorSupplier;
    }

    @Override
    public T get() {
        T value = this.internal.get();
        if (value == null) {
            throw new NullReturnedException(this.errorSupplier.get());
        }
        return value;
    }

    public static <T> Supplier<T> from(Supplier<T> toWrap) {
        return NonNullSupplier.from(toWrap, () -> "The returned value was null.");
    }

    public static <T> Supplier<T> from(Supplier<T> toWrap, Supplier<String> errorSupplier) {
        return new NonNullSupplier<T>(toWrap, errorSupplier);
    }

    public static class NullReturnedException
    extends RuntimeException {
        private static final long serialVersionUID = -1848463236953236103L;

        private NullReturnedException(String message) {
            super(message);
        }
    }
}

