/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import net.darkhax.bookshelf.serialization.ISerializer;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;

public final class SerializerString
implements ISerializer<String> {
    public static final ISerializer<String> SERIALIZER = new SerializerString();

    private SerializerString() {
    }

    @Override
    public String read(JsonElement json) {
        return json.getAsString();
    }

    @Override
    public JsonElement write(String toWrite) {
        return new JsonPrimitive(toWrite);
    }

    @Override
    public String read(PacketBuffer buffer) {
        return buffer.func_218666_n();
    }

    @Override
    public void write(PacketBuffer buffer, String toWrite) {
        buffer.func_180714_a(toWrite);
    }

    @Override
    public INBT writeNBT(String toWrite) {
        return StringNBT.func_229705_a_((String)toWrite);
    }

    @Override
    public String read(INBT nbt) {
        if (nbt instanceof StringNBT) {
            return ((StringNBT)nbt).func_150285_a_();
        }
        throw new IllegalArgumentException("Expected NBT to be a string tag. Class was " + nbt.getClass() + " with ID " + nbt.func_74732_a() + " instead.");
    }
}

